/*
 * Decompiled with CFR 0.152.
 */
package android.sysprop;

import android.os.SystemProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;

public class HdmiProperties {
    private HdmiProperties() {
    }

    private static Boolean tryParseBoolean(String str) {
        switch (str.toLowerCase(Locale.US)) {
            case "1": 
            case "true": {
                return Boolean.TRUE;
            }
            case "0": 
            case "false": {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static Integer tryParseInteger(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Integer tryParseUInt(String str) {
        try {
            return Integer.parseUnsignedInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long tryParseLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long tryParseULong(String str) {
        try {
            return Long.parseUnsignedLong(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Double tryParseDouble(String str) {
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String tryParseString(String str) {
        return "".equals(str) ? null : str;
    }

    private static <T extends Enum<T>> T tryParseEnum(Class<T> enumType, String str) {
        try {
            return Enum.valueOf(enumType, str.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static <T> List<T> tryParseList(Function<String, T> elementParser, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        int p = 0;
        while (true) {
            StringBuilder sb = new StringBuilder();
            while (p < str.length() && str.charAt(p) != ',') {
                if (str.charAt(p) == '\\') {
                    ++p;
                }
                if (p == str.length()) break;
                sb.append(str.charAt(p++));
            }
            ret.add(elementParser.apply(sb.toString()));
            if (p == str.length()) break;
            ++p;
        }
        return ret;
    }

    private static <T extends Enum<T>> List<T> tryParseEnumList(Class<T> enumType, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (String element : str.split(",")) {
            ret.add(HdmiProperties.tryParseEnum(enumType, element));
        }
        return ret;
    }

    private static String escape(String str) {
        return str.replaceAll("([\\\\,])", "\\\\$1");
    }

    private static <T> String formatList(List<T> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (T element : list) {
            joiner.add(element == null ? "" : HdmiProperties.escape(element.toString()));
        }
        return joiner.toString();
    }

    private static String formatUIntList(List<Integer> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (Integer element : list) {
            joiner.add(element == null ? "" : HdmiProperties.escape(Integer.toUnsignedString(element)));
        }
        return joiner.toString();
    }

    private static String formatULongList(List<Long> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (Long element : list) {
            joiner.add(element == null ? "" : HdmiProperties.escape(Long.toUnsignedString(element)));
        }
        return joiner.toString();
    }

    private static <T extends Enum<T>> String formatEnumList(List<T> list, Function<T, String> elementFormatter) {
        StringJoiner joiner = new StringJoiner(",");
        for (Enum element : list) {
            joiner.add(element == null ? "" : (CharSequence)elementFormatter.apply(element));
        }
        return joiner.toString();
    }

    @Deprecated
    public static List<Integer> device_type() {
        String value2 = SystemProperties.get("ro.hdmi.device_type");
        return HdmiProperties.tryParseList(v -> HdmiProperties.tryParseInteger(v), value2);
    }

    public static List<cec_device_types_values> cec_device_types() {
        String value2 = SystemProperties.get("ro.hdmi.cec_device_types");
        return HdmiProperties.tryParseEnumList(cec_device_types_values.class, value2);
    }

    public static Optional<String> arc_port() {
        String value2 = SystemProperties.get("ro.hdmi.property_sytem_audio_device_arc_port");
        return Optional.ofNullable(HdmiProperties.tryParseString(value2));
    }

    public static Optional<Boolean> forward_volume_keys_when_system_audio_mode_off() {
        String value2 = SystemProperties.get("ro.hdmi.cec_audio_device_forward_volume_keys_system_audio_mode_off");
        return Optional.ofNullable(HdmiProperties.tryParseBoolean(value2));
    }

    public static Optional<Boolean> is_switch() {
        String value2 = SystemProperties.get("ro.hdmi.property_is_device_hdmi_cec_switch");
        return Optional.ofNullable(HdmiProperties.tryParseBoolean(value2));
    }

    public static Optional<playback_device_action_on_routing_control_values> playback_device_action_on_routing_control() {
        String value2 = SystemProperties.get("ro.hdmi.cec.source.playback_device_action_on_routing_control");
        return Optional.ofNullable(HdmiProperties.tryParseEnum(playback_device_action_on_routing_control_values.class, value2));
    }

    public static enum playback_device_action_on_routing_control_values {
        NONE("none"),
        WAKE_UP_ONLY("wake_up_only"),
        WAKE_UP_AND_SEND_ACTIVE_SOURCE("wake_up_and_send_active_source");

        private final String propValue;

        private playback_device_action_on_routing_control_values(String propValue) {
            this.propValue = propValue;
        }

        public String getPropValue() {
            return this.propValue;
        }
    }

    public static enum cec_device_types_values {
        TV("tv"),
        RECORDING_DEVICE("recording_device"),
        RESERVED("reserved"),
        TUNER("tuner"),
        PLAYBACK_DEVICE("playback_device"),
        AUDIO_SYSTEM("audio_system"),
        PURE_CEC_SWITCH("pure_cec_switch"),
        VIDEO_PROCESSOR("video_processor");

        private final String propValue;

        private cec_device_types_values(String propValue) {
            this.propValue = propValue;
        }

        public String getPropValue() {
            return this.propValue;
        }
    }
}

