/*
 * Decompiled with CFR 0.152.
 */
package android.telecom.Logging;

import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Log;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;

public class Session {
    public static final String LOG_TAG = "Session";
    public static final String START_SESSION = "START_SESSION";
    public static final String START_EXTERNAL_SESSION = "START_EXTERNAL_SESSION";
    public static final String CREATE_SUBSESSION = "CREATE_SUBSESSION";
    public static final String CONTINUE_SUBSESSION = "CONTINUE_SUBSESSION";
    public static final String END_SUBSESSION = "END_SUBSESSION";
    public static final String END_SESSION = "END_SESSION";
    public static final String SUBSESSION_SEPARATION_CHAR = "->";
    public static final String SESSION_SEPARATION_CHAR_CHILD = "_";
    public static final String EXTERNAL_INDICATOR = "E-";
    public static final String TRUNCATE_STRING = "...";
    private static final int SESSION_RECURSION_LIMIT = 25;
    public static final int UNDEFINED = -1;
    private String mSessionId;
    private String mShortMethodName;
    private long mExecutionStartTimeMs;
    private long mExecutionEndTimeMs = -1L;
    private Session mParentSession;
    private ArrayList<Session> mChildSessions;
    private boolean mIsCompleted = false;
    private boolean mIsExternal = false;
    private int mChildCounter = 0;
    private boolean mIsStartedFromActiveSession = false;
    private String mOwnerInfo;
    private String mFullMethodPathCache;

    public Session(String sessionId, String shortMethodName, long startTimeMs, boolean isStartedFromActiveSession, String ownerInfo) {
        this.setSessionId(sessionId);
        this.setShortMethodName(shortMethodName);
        this.mExecutionStartTimeMs = startTimeMs;
        this.mParentSession = null;
        this.mChildSessions = new ArrayList(5);
        this.mIsStartedFromActiveSession = isStartedFromActiveSession;
        this.mOwnerInfo = ownerInfo;
    }

    public void setSessionId(String sessionId) {
        if (sessionId == null) {
            this.mSessionId = "?";
        }
        this.mSessionId = sessionId;
    }

    public String getShortMethodName() {
        return this.mShortMethodName;
    }

    public void setShortMethodName(String shortMethodName) {
        if (shortMethodName == null) {
            shortMethodName = "";
        }
        this.mShortMethodName = shortMethodName;
    }

    public void setIsExternal(boolean isExternal) {
        this.mIsExternal = isExternal;
    }

    public boolean isExternal() {
        return this.mIsExternal;
    }

    public void setParentSession(Session parentSession) {
        this.mParentSession = parentSession;
    }

    public void addChild(Session childSession) {
        if (childSession != null) {
            this.mChildSessions.add(childSession);
        }
    }

    public void removeChild(Session child) {
        if (child != null) {
            this.mChildSessions.remove(child);
        }
    }

    public long getExecutionStartTimeMilliseconds() {
        return this.mExecutionStartTimeMs;
    }

    public void setExecutionStartTimeMs(long startTimeMs) {
        this.mExecutionStartTimeMs = startTimeMs;
    }

    public Session getParentSession() {
        return this.mParentSession;
    }

    public ArrayList<Session> getChildSessions() {
        return this.mChildSessions;
    }

    public boolean isSessionCompleted() {
        return this.mIsCompleted;
    }

    public boolean isStartedFromActiveSession() {
        return this.mIsStartedFromActiveSession;
    }

    public Info getInfo() {
        return Info.getInfo(this);
    }

    public Info getExternalInfo(String ownerInfo) {
        return Info.getExternalInfo(this, ownerInfo);
    }

    public String getOwnerInfo() {
        return this.mOwnerInfo;
    }

    @VisibleForTesting
    public String getSessionId() {
        return this.mSessionId;
    }

    public void markSessionCompleted(long executionEndTimeMs) {
        this.mExecutionEndTimeMs = executionEndTimeMs;
        this.mIsCompleted = true;
    }

    public long getLocalExecutionTime() {
        if (this.mExecutionEndTimeMs == -1L) {
            return -1L;
        }
        return this.mExecutionEndTimeMs - this.mExecutionStartTimeMs;
    }

    public synchronized String getNextChildId() {
        return String.valueOf(this.mChildCounter++);
    }

    private String getFullSessionId() {
        return this.getFullSessionId(0);
    }

    private String getFullSessionId(int parentCount) {
        if (parentCount >= 25) {
            Slog.w(LOG_TAG, "getFullSessionId: Hit recursion limit!");
            return TRUNCATE_STRING + this.mSessionId;
        }
        Session parentSession = this.mParentSession;
        if (parentSession == null) {
            return this.mSessionId;
        }
        if (Log.VERBOSE) {
            return parentSession.getFullSessionId(parentCount + 1) + SESSION_SEPARATION_CHAR_CHILD + this.mSessionId;
        }
        return parentSession.getFullSessionId(parentCount + 1);
    }

    private Session getRootSession(String callingMethod) {
        int currParentCount = 0;
        Session topNode = this;
        while (topNode.getParentSession() != null) {
            if (currParentCount >= 25) {
                Slog.w(LOG_TAG, "getRootSession: Hit recursion limit from " + callingMethod);
                break;
            }
            topNode = topNode.getParentSession();
            ++currParentCount;
        }
        return topNode;
    }

    public String printFullSessionTree() {
        return this.getRootSession("printFullSessionTree").printSessionTree();
    }

    private String printSessionTree() {
        StringBuilder sb = new StringBuilder();
        this.printSessionTree(0, sb, 0);
        return sb.toString();
    }

    private void printSessionTree(int tabI, StringBuilder sb, int currChildCount) {
        if (currChildCount >= 25) {
            Slog.w(LOG_TAG, "printSessionTree: Hit recursion limit!");
            sb.append(TRUNCATE_STRING);
            return;
        }
        sb.append(this.toString());
        for (Session child : this.mChildSessions) {
            sb.append("\n");
            for (int i = 0; i <= tabI; ++i) {
                sb.append("\t");
            }
            child.printSessionTree(tabI + 1, sb, currChildCount + 1);
        }
    }

    public String getFullMethodPath(boolean truncatePath) {
        StringBuilder sb = new StringBuilder();
        this.getFullMethodPath(sb, truncatePath, 0);
        return sb.toString();
    }

    private synchronized void getFullMethodPath(StringBuilder sb, boolean truncatePath, int parentCount) {
        if (parentCount >= 25) {
            Slog.w(LOG_TAG, "getFullMethodPath: Hit recursion limit!");
            sb.append(TRUNCATE_STRING);
            return;
        }
        if (!TextUtils.isEmpty(this.mFullMethodPathCache) && !truncatePath) {
            sb.append(this.mFullMethodPathCache);
            return;
        }
        Session parentSession = this.getParentSession();
        boolean isSessionStarted = false;
        if (parentSession != null) {
            isSessionStarted = !this.mShortMethodName.equals(parentSession.mShortMethodName);
            parentSession.getFullMethodPath(sb, truncatePath, parentCount + 1);
            sb.append(SUBSESSION_SEPARATION_CHAR);
        }
        if (this.isExternal()) {
            if (truncatePath) {
                sb.append(TRUNCATE_STRING);
            } else {
                sb.append("(");
                sb.append(this.mShortMethodName);
                sb.append(")");
            }
        } else {
            sb.append(this.mShortMethodName);
        }
        if (isSessionStarted && !truncatePath) {
            this.mFullMethodPathCache = sb.toString();
        }
    }

    private boolean isSessionExternal() {
        return this.getRootSession("isSessionExternal").isExternal();
    }

    public int hashCode() {
        int result = this.mSessionId != null ? this.mSessionId.hashCode() : 0;
        result = 31 * result + (this.mShortMethodName != null ? this.mShortMethodName.hashCode() : 0);
        result = 31 * result + (int)(this.mExecutionStartTimeMs ^ this.mExecutionStartTimeMs >>> 32);
        result = 31 * result + (int)(this.mExecutionEndTimeMs ^ this.mExecutionEndTimeMs >>> 32);
        result = 31 * result + (this.mParentSession != null ? this.mParentSession.hashCode() : 0);
        result = 31 * result + (this.mChildSessions != null ? this.mChildSessions.hashCode() : 0);
        result = 31 * result + (this.mIsCompleted ? 1 : 0);
        result = 31 * result + this.mChildCounter;
        result = 31 * result + (this.mIsStartedFromActiveSession ? 1 : 0);
        result = 31 * result + (this.mOwnerInfo != null ? this.mOwnerInfo.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        if (this.mExecutionStartTimeMs != session.mExecutionStartTimeMs) {
            return false;
        }
        if (this.mExecutionEndTimeMs != session.mExecutionEndTimeMs) {
            return false;
        }
        if (this.mIsCompleted != session.mIsCompleted) {
            return false;
        }
        if (this.mChildCounter != session.mChildCounter) {
            return false;
        }
        if (this.mIsStartedFromActiveSession != session.mIsStartedFromActiveSession) {
            return false;
        }
        if (this.mSessionId != null ? !this.mSessionId.equals(session.mSessionId) : session.mSessionId != null) {
            return false;
        }
        if (this.mShortMethodName != null ? !this.mShortMethodName.equals(session.mShortMethodName) : session.mShortMethodName != null) {
            return false;
        }
        if (this.mParentSession != null ? !this.mParentSession.equals(session.mParentSession) : session.mParentSession != null) {
            return false;
        }
        if (this.mChildSessions != null ? !this.mChildSessions.equals(session.mChildSessions) : session.mChildSessions != null) {
            return false;
        }
        return this.mOwnerInfo != null ? this.mOwnerInfo.equals(session.mOwnerInfo) : session.mOwnerInfo == null;
    }

    public String toString() {
        Session sessionToPrint = this;
        if (this.getParentSession() != null && this.isStartedFromActiveSession()) {
            sessionToPrint = this.getRootSession("toString");
        }
        StringBuilder methodName = new StringBuilder();
        methodName.append(sessionToPrint.getFullMethodPath(false));
        if (sessionToPrint.getOwnerInfo() != null && !sessionToPrint.getOwnerInfo().isEmpty()) {
            methodName.append("(");
            methodName.append(sessionToPrint.getOwnerInfo());
            methodName.append(")");
        }
        return methodName.toString() + "@" + sessionToPrint.getFullSessionId();
    }

    public static class Info
    implements Parcelable {
        public final String sessionId;
        public final String methodPath;
        public final String ownerInfo;
        public static final Parcelable.Creator<Info> CREATOR = new Parcelable.Creator<Info>(){

            @Override
            public Info createFromParcel(Parcel source) {
                String id2 = source.readString();
                String methodName = source.readString();
                String ownerInfo = source.readString();
                return new Info(id2, methodName, ownerInfo);
            }

            public Info[] newArray(int size) {
                return new Info[size];
            }
        };

        private Info(String id2, String path, String owner) {
            this.sessionId = id2;
            this.methodPath = path;
            this.ownerInfo = owner;
        }

        public static Info getInfo(Session s) {
            return new Info(s.getFullSessionId(), s.getFullMethodPath(!Log.DEBUG && s.isSessionExternal()), s.getOwnerInfo());
        }

        public static Info getExternalInfo(Session s, String ownerInfo) {
            String newInfo = ownerInfo != null && s.getOwnerInfo() != null ? s.getOwnerInfo() + "/" + ownerInfo : (ownerInfo != null ? ownerInfo : s.getOwnerInfo());
            return new Info(s.getFullSessionId(), s.getFullMethodPath(!Log.DEBUG && s.isSessionExternal()), newInfo);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel destination, int flags) {
            destination.writeString(this.sessionId);
            destination.writeString(this.methodPath);
            destination.writeString(this.ownerInfo);
        }
    }
}

