/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.compat.annotation.UnsupportedAppUsage;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Rlog {
    private static final boolean USER_BUILD = _Original_Build.IS_USER;

    private Rlog() {
    }

    @UnsupportedAppUsage
    public static int v(String tag2, String msg) {
        return Log.println_native(1, 2, tag2, msg);
    }

    public static int v(String tag2, String msg, Throwable tr) {
        return Log.println_native(1, 2, tag2, msg + '\n' + Log.getStackTraceString(tr));
    }

    @UnsupportedAppUsage
    public static int d(String tag2, String msg) {
        return Log.println_native(1, 3, tag2, msg);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int d(String tag2, String msg, Throwable tr) {
        return Log.println_native(1, 3, tag2, msg + '\n' + Log.getStackTraceString(tr));
    }

    @UnsupportedAppUsage
    public static int i(String tag2, String msg) {
        return Log.println_native(1, 4, tag2, msg);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static int i(String tag2, String msg, Throwable tr) {
        return Log.println_native(1, 4, tag2, msg + '\n' + Log.getStackTraceString(tr));
    }

    @UnsupportedAppUsage
    public static int w(String tag2, String msg) {
        return Log.println_native(1, 5, tag2, msg);
    }

    @UnsupportedAppUsage
    public static int w(String tag2, String msg, Throwable tr) {
        return Log.println_native(1, 5, tag2, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int w(String tag2, Throwable tr) {
        return Log.println_native(1, 5, tag2, Log.getStackTraceString(tr));
    }

    @UnsupportedAppUsage
    public static int e(String tag2, String msg) {
        return Log.println_native(1, 6, tag2, msg);
    }

    @UnsupportedAppUsage
    public static int e(String tag2, String msg, Throwable tr) {
        return Log.println_native(1, 6, tag2, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int println(int priority, String tag2, String msg) {
        return Log.println_native(1, priority, tag2, msg);
    }

    public static boolean isLoggable(String tag2, int level) {
        return Log.isLoggable(tag2, level);
    }

    public static String pii(String tag2, Object pii) {
        String val = String.valueOf(pii);
        if (pii == null || TextUtils.isEmpty(val) || Rlog.isLoggable(tag2, 2)) {
            return val;
        }
        return "[" + Rlog.secureHash(val.getBytes()) + "]";
    }

    public static String pii(boolean enablePiiLogging, Object pii) {
        String val = String.valueOf(pii);
        if (pii == null || TextUtils.isEmpty(val) || enablePiiLogging) {
            return val;
        }
        return "[" + Rlog.secureHash(val.getBytes()) + "]";
    }

    private static String secureHash(byte[] input) {
        MessageDigest messageDigest;
        if (USER_BUILD) {
            return "****";
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            return "####";
        }
        byte[] result = messageDigest.digest(input);
        return Base64.encodeToString(result, 11);
    }
}

