/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.app.PropertyInvalidatedCache;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.NetworkPolicyManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelUuid;
import android.os.Process;
import android.os.RemoteException;
import android.provider.Telephony;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionPlan;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.TelephonyManager;
import android.telephony.TelephonyRegistryManager;
import android.telephony.UiccAccessRule;
import android.telephony.euicc.EuiccManager;
import android.util.Base64;
import android.util.Log;
import android.util.Pair;
import com.android.internal.telephony.ISetOpportunisticDataCallback;
import com.android.internal.telephony.ISub;
import com.android.internal.telephony.util.HandlerExecutor;
import com.android.internal.util.FunctionalUtils;
import com.android.internal.util.Preconditions;
import com.android.telephony.Rlog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SubscriptionManager {
    private static final String LOG_TAG = "SubscriptionManager";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    public static final int INVALID_SUBSCRIPTION_ID = -1;
    public static final int PLACEHOLDER_SUBSCRIPTION_ID_BASE = -2;
    public static final int INVALID_PHONE_INDEX = -1;
    public static final int INVALID_SIM_SLOT_INDEX = -1;
    public static final int DEFAULT_SUBSCRIPTION_ID = Integer.MAX_VALUE;
    public static final int DEFAULT_PHONE_INDEX = Integer.MAX_VALUE;
    public static final int DEFAULT_SIM_SLOT_INDEX = Integer.MAX_VALUE;
    public static final int MIN_SUBSCRIPTION_ID_VALUE = 0;
    public static final int MAX_SUBSCRIPTION_ID_VALUE = 0x7FFFFFFE;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final Uri CONTENT_URI = Telephony.SimInfo.CONTENT_URI;
    public static final String CACHE_KEY_DEFAULT_SUB_ID_PROPERTY = "cache_key.telephony.get_default_sub_id";
    public static final String CACHE_KEY_DEFAULT_DATA_SUB_ID_PROPERTY = "cache_key.telephony.get_default_data_sub_id";
    public static final String CACHE_KEY_DEFAULT_SMS_SUB_ID_PROPERTY = "cache_key.telephony.get_default_sms_sub_id";
    public static final String CACHE_KEY_ACTIVE_DATA_SUB_ID_PROPERTY = "cache_key.telephony.get_active_data_sub_id";
    public static final String CACHE_KEY_SLOT_INDEX_PROPERTY = "cache_key.telephony.get_slot_index";
    public static final String GET_SIM_SPECIFIC_SETTINGS_METHOD_NAME = "getSimSpecificSettings";
    public static final String RESTORE_SIM_SPECIFIC_SETTINGS_METHOD_NAME = "restoreSimSpecificSettings";
    public static final String KEY_SIM_SPECIFIC_SETTINGS_DATA = "KEY_SIM_SPECIFIC_SETTINGS_DATA";
    private static final int MAX_CACHE_SIZE = 4;
    private static VoidPropertyInvalidatedCache<Integer> sDefaultSubIdCache = new VoidPropertyInvalidatedCache<Integer>(ISub::getDefaultSubId, "cache_key.telephony.get_default_sub_id", -1);
    private static VoidPropertyInvalidatedCache<Integer> sDefaultDataSubIdCache = new VoidPropertyInvalidatedCache<Integer>(ISub::getDefaultDataSubId, "cache_key.telephony.get_default_data_sub_id", -1);
    private static VoidPropertyInvalidatedCache<Integer> sDefaultSmsSubIdCache = new VoidPropertyInvalidatedCache<Integer>(ISub::getDefaultSmsSubId, "cache_key.telephony.get_default_sms_sub_id", -1);
    private static VoidPropertyInvalidatedCache<Integer> sActiveDataSubIdCache = new VoidPropertyInvalidatedCache<Integer>(ISub::getActiveDataSubscriptionId, "cache_key.telephony.get_active_data_sub_id", -1);
    private static IntegerPropertyInvalidatedCache<Integer> sSlotIndexCache = new IntegerPropertyInvalidatedCache<Integer>(ISub::getSlotIndex, "cache_key.telephony.get_slot_index", -1);
    private static IntegerPropertyInvalidatedCache<Integer> sPhoneIdCache = new IntegerPropertyInvalidatedCache<Integer>(ISub::getPhoneId, "cache_key.telephony.get_default_sub_id", -1);
    @SystemApi
    public static final Uri WFC_ENABLED_CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "wfc");
    @SystemApi
    public static final Uri ADVANCED_CALLING_ENABLED_CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "advanced_calling");
    @SystemApi
    public static final Uri WFC_MODE_CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "wfc_mode");
    @SystemApi
    public static final Uri WFC_ROAMING_MODE_CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "wfc_roaming_mode");
    @SystemApi
    public static final Uri VT_ENABLED_CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "vt_enabled");
    @SystemApi
    public static final Uri WFC_ROAMING_ENABLED_CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "wfc_roaming_enabled");
    public static final Uri SIM_INFO_BACKUP_AND_RESTORE_CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "backup_and_restore");
    public static final Uri SIM_INFO_SUW_RESTORE_CONTENT_URI = Uri.withAppendedPath(SIM_INFO_BACKUP_AND_RESTORE_CONTENT_URI, "suw_restore");
    @SystemApi
    public static final Uri CROSS_SIM_ENABLED_CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "cross_sim_calling_enabled");
    public static final String UNIQUE_KEY_SUBSCRIPTION_ID = "_id";
    public static final String ICC_ID = "icc_id";
    public static final String SIM_SLOT_INDEX = "sim_id";
    public static final int SIM_NOT_INSERTED = -1;
    public static final int SLOT_INDEX_FOR_REMOTE_SIM_SUB = -1;
    public static final String SUBSCRIPTION_TYPE = "subscription_type";
    public static final String DATA_ENABLED_OVERRIDE_RULES = "data_enabled_override_rules";
    public static final int SUBSCRIPTION_TYPE_LOCAL_SIM = 0;
    public static final int SUBSCRIPTION_TYPE_REMOTE_SIM = 1;
    public static final String DISPLAY_NAME = "display_name";
    public static final String CARRIER_NAME = "carrier_name";
    public static final int DEFAULT_NAME_RES = 17039374;
    public static final String NAME_SOURCE = "name_source";
    public static final int NAME_SOURCE_CARRIER_ID = 0;
    public static final int NAME_SOURCE_SIM_SPN = 1;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static final int NAME_SOURCE_USER_INPUT = 2;
    public static final int NAME_SOURCE_CARRIER = 3;
    public static final int NAME_SOURCE_SIM_PNN = 4;
    public static final int D2D_SHARING_DISABLED = 0;
    public static final int D2D_SHARING_ALL_CONTACTS = 1;
    public static final int D2D_SHARING_SELECTED_CONTACTS = 2;
    public static final int D2D_SHARING_ALL = 3;
    public static final String D2D_STATUS_SHARING = "d2d_sharing_status";
    public static final String D2D_STATUS_SHARING_SELECTED_CONTACTS = "d2d_sharing_contacts";
    public static final String HUE = "color";
    public static final String NUMBER = "number";
    public static final String DATA_ROAMING = "data_roaming";
    public static final int DATA_ROAMING_ENABLE = 1;
    public static final int DATA_ROAMING_DISABLE = 0;
    public static final String CARRIER_ID = "carrier_id";
    public static final String EHPLMNS = "ehplmns";
    public static final String HPLMNS = "hplmns";
    public static final String MCC_STRING = "mcc_string";
    public static final String MNC_STRING = "mnc_string";
    public static final String MCC = "mcc";
    public static final String MNC = "mnc";
    public static final String ISO_COUNTRY_CODE = "iso_country_code";
    public static final String IS_EMBEDDED = "is_embedded";
    public static final String CARD_ID = "card_id";
    public static final String ACCESS_RULES = "access_rules";
    public static final String ACCESS_RULES_FROM_CARRIER_CONFIGS = "access_rules_from_carrier_configs";
    public static final String IS_REMOVABLE = "is_removable";
    public static final String CB_EXTREME_THREAT_ALERT = "enable_cmas_extreme_threat_alerts";
    public static final String CB_SEVERE_THREAT_ALERT = "enable_cmas_severe_threat_alerts";
    public static final String CB_AMBER_ALERT = "enable_cmas_amber_alerts";
    public static final String CB_EMERGENCY_ALERT = "enable_emergency_alerts";
    public static final String CB_ALERT_SOUND_DURATION = "alert_sound_duration";
    public static final String CB_ALERT_REMINDER_INTERVAL = "alert_reminder_interval";
    public static final String CB_ALERT_VIBRATE = "enable_alert_vibrate";
    public static final String CB_ALERT_SPEECH = "enable_alert_speech";
    public static final String CB_ETWS_TEST_ALERT = "enable_etws_test_alerts";
    public static final String CB_CHANNEL_50_ALERT = "enable_channel_50_alerts";
    public static final String CB_CMAS_TEST_ALERT = "enable_cmas_test_alerts";
    public static final String CB_OPT_OUT_DIALOG = "show_cmas_opt_out_dialog";
    public static final String ENHANCED_4G_MODE_ENABLED = "volte_vt_enabled";
    public static final String VT_IMS_ENABLED = "vt_ims_enabled";
    public static final String WFC_IMS_ENABLED = "wfc_ims_enabled";
    public static final String WFC_IMS_MODE = "wfc_ims_mode";
    public static final String WFC_IMS_ROAMING_MODE = "wfc_ims_roaming_mode";
    public static final String WFC_IMS_ROAMING_ENABLED = "wfc_ims_roaming_enabled";
    public static final String IMS_RCS_UCE_ENABLED = "ims_rcs_uce_enabled";
    public static final String CROSS_SIM_CALLING_ENABLED = "cross_sim_calling_enabled";
    public static final String IS_OPPORTUNISTIC = "is_opportunistic";
    public static final String GROUP_UUID = "group_uuid";
    public static final String GROUP_OWNER = "group_owner";
    public static final String PROFILE_CLASS = "profile_class";
    public static final String PORT_INDEX = "port_index";
    public static final String VOIMS_OPT_IN_STATUS = "voims_opt_in_status";
    public static final String NR_ADVANCED_CALLING_ENABLED = "nr_advanced_calling_enabled";
    @SystemApi
    public static final int PROFILE_CLASS_TESTING = 0;
    @SystemApi
    public static final int PROFILE_CLASS_PROVISIONING = 1;
    @SystemApi
    public static final int PROFILE_CLASS_OPERATIONAL = 2;
    @SystemApi
    public static final int PROFILE_CLASS_UNSET = -1;
    @SystemApi
    @Deprecated
    public static final int PROFILE_CLASS_DEFAULT = -1;
    public static final String IMSI = "imsi";
    public static final String UICC_APPLICATIONS_ENABLED = "uicc_applications_enabled";
    public static final String ALLOWED_NETWORK_TYPES = "allowed_network_types_for_reasons";
    public static final int USAGE_SETTING_UNKNOWN = -1;
    public static final int USAGE_SETTING_DEFAULT = 0;
    public static final int USAGE_SETTING_VOICE_CENTRIC = 1;
    public static final int USAGE_SETTING_DATA_CENTRIC = 2;
    public static final String USAGE_SETTING = "usage_setting";
    public static final String SUB_DEFAULT_CHANGED_ACTION = "android.intent.action.SUB_DEFAULT_CHANGED";
    public static final String ACTION_DEFAULT_SUBSCRIPTION_CHANGED = "android.telephony.action.DEFAULT_SUBSCRIPTION_CHANGED";
    public static final String ACTION_DEFAULT_SMS_SUBSCRIPTION_CHANGED = "android.telephony.action.DEFAULT_SMS_SUBSCRIPTION_CHANGED";
    public static final String ACTION_MANAGE_SUBSCRIPTION_PLANS = "android.telephony.action.MANAGE_SUBSCRIPTION_PLANS";
    public static final String ACTION_REFRESH_SUBSCRIPTION_PLANS = "android.telephony.action.REFRESH_SUBSCRIPTION_PLANS";
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_SUBSCRIPTION_PLANS")
    public static final String ACTION_SUBSCRIPTION_PLANS_CHANGED = "android.telephony.action.SUBSCRIPTION_PLANS_CHANGED";
    public static final String EXTRA_SUBSCRIPTION_INDEX = "android.telephony.extra.SUBSCRIPTION_INDEX";
    public static final String EXTRA_SLOT_INDEX = "android.telephony.extra.SLOT_INDEX";
    public static final int PHONE_NUMBER_SOURCE_UICC = 1;
    public static final int PHONE_NUMBER_SOURCE_CARRIER = 2;
    public static final int PHONE_NUMBER_SOURCE_IMS = 3;
    private final Context mContext;
    private static final Map<Pair<Context, Integer>, Resources> sResourcesCache = new ConcurrentHashMap<Pair<Context, Integer>, Resources>();

    public static Uri getUriForSubscriptionId(int subscriptionId) {
        return Uri.withAppendedPath(CONTENT_URI, String.valueOf(subscriptionId));
    }

    @UnsupportedAppUsage
    public SubscriptionManager(Context context) {
        this.mContext = context;
    }

    private NetworkPolicyManager getNetworkPolicyManager() {
        return (NetworkPolicyManager)this.mContext.getSystemService("netpolicy");
    }

    @Deprecated
    public static SubscriptionManager from(Context context) {
        return (SubscriptionManager)context.getSystemService("telephony_subscription_service");
    }

    @Deprecated
    public void addOnSubscriptionsChangedListener(OnSubscriptionsChangedListener listener2) {
        if (listener2 == null) {
            return;
        }
        this.addOnSubscriptionsChangedListener(listener2.mExecutor, listener2);
    }

    public void addOnSubscriptionsChangedListener(Executor executor, OnSubscriptionsChangedListener listener2) {
        String pkgName = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        TelephonyRegistryManager telephonyRegistryManager = (TelephonyRegistryManager)this.mContext.getSystemService("telephony_registry");
        if (telephonyRegistryManager != null) {
            telephonyRegistryManager.addOnSubscriptionsChangedListener(listener2, executor);
        } else {
            SubscriptionManager.loge("addOnSubscriptionsChangedListener: pkgname=" + pkgName + " failed to be added  due to TELEPHONY_REGISTRY_SERVICE being unavailable.");
            executor.execute(() -> listener2.onAddListenerFailed());
        }
    }

    public void removeOnSubscriptionsChangedListener(OnSubscriptionsChangedListener listener2) {
        if (listener2 == null) {
            return;
        }
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        TelephonyRegistryManager telephonyRegistryManager = (TelephonyRegistryManager)this.mContext.getSystemService("telephony_registry");
        if (telephonyRegistryManager != null) {
            telephonyRegistryManager.removeOnSubscriptionsChangedListener(listener2);
        }
    }

    public void addOnOpportunisticSubscriptionsChangedListener(Executor executor, OnOpportunisticSubscriptionsChangedListener listener2) {
        if (executor == null || listener2 == null) {
            return;
        }
        String pkgName = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        TelephonyRegistryManager telephonyRegistryManager = (TelephonyRegistryManager)this.mContext.getSystemService("telephony_registry");
        if (telephonyRegistryManager != null) {
            telephonyRegistryManager.addOnOpportunisticSubscriptionsChangedListener(listener2, executor);
        }
    }

    public void removeOnOpportunisticSubscriptionsChangedListener(OnOpportunisticSubscriptionsChangedListener listener2) {
        Preconditions.checkNotNull(listener2, "listener cannot be null");
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        TelephonyRegistryManager telephonyRegistryManager = (TelephonyRegistryManager)this.mContext.getSystemService("telephony_registry");
        if (telephonyRegistryManager != null) {
            telephonyRegistryManager.removeOnOpportunisticSubscriptionsChangedListener(listener2);
        }
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public SubscriptionInfo getActiveSubscriptionInfo(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return null;
        }
        SubscriptionInfo subInfo = null;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                subInfo = iSub.getActiveSubscriptionInfo(subId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subInfo;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public SubscriptionInfo getActiveSubscriptionInfoForIcc(String iccId) {
        if (iccId == null) {
            SubscriptionManager.logd("[getActiveSubscriptionInfoForIccIndex]- null iccid");
            return null;
        }
        SubscriptionInfo result = null;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoForIccId(iccId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int slotIndex) {
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            SubscriptionManager.logd("[getActiveSubscriptionInfoForSimSlotIndex]- invalid slotIndex");
            return null;
        }
        SubscriptionInfo result = null;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoForSimSlotIndex(slotIndex, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    @UnsupportedAppUsage
    public List<SubscriptionInfo> getAllSubscriptionInfoList() {
        List<SubscriptionInfo> result = null;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                result = iSub.getAllSubInfoList(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public List<SubscriptionInfo> getActiveSubscriptionInfoList() {
        return this.getActiveSubscriptionInfoList(true);
    }

    public List<SubscriptionInfo> getCompleteActiveSubscriptionInfoList() {
        List<SubscriptionInfo> completeList = this.getActiveSubscriptionInfoList(false);
        if (completeList == null) {
            completeList = new ArrayList<SubscriptionInfo>();
        }
        return completeList;
    }

    public List<SubscriptionInfo> getActiveSubscriptionInfoList(boolean userVisibleOnly) {
        List<SubscriptionInfo> activeList = null;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                activeList = iSub.getActiveSubscriptionInfoList(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (!userVisibleOnly || activeList == null) {
            return activeList;
        }
        return activeList.stream().filter(subInfo -> this.isSubscriptionVisible((SubscriptionInfo)subInfo)).collect(Collectors.toList());
    }

    @SystemApi
    public List<SubscriptionInfo> getAvailableSubscriptionInfoList() {
        List<SubscriptionInfo> result = null;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                result = iSub.getAvailableSubscriptionInfoList(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public List<SubscriptionInfo> getAccessibleSubscriptionInfoList() {
        List<SubscriptionInfo> result = null;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                result = iSub.getAccessibleSubscriptionInfoList(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    @SystemApi
    public void requestEmbeddedSubscriptionInfoListRefresh() {
        int cardId = TelephonyManager.from(this.mContext).getCardIdForDefaultEuicc();
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                iSub.requestEmbeddedSubscriptionInfoListRefresh(cardId);
            }
        }
        catch (RemoteException ex) {
            SubscriptionManager.logd("requestEmbeddedSubscriptionInfoListFresh for card = " + cardId + " failed.");
        }
    }

    @SystemApi
    public void requestEmbeddedSubscriptionInfoListRefresh(int cardId) {
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                iSub.requestEmbeddedSubscriptionInfoListRefresh(cardId);
            }
        }
        catch (RemoteException ex) {
            SubscriptionManager.logd("requestEmbeddedSubscriptionInfoListFresh for card = " + cardId + " failed.");
        }
    }

    @UnsupportedAppUsage
    public int getAllSubscriptionInfoCount() {
        int result = 0;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                result = iSub.getAllSubInfoCount(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public int getActiveSubscriptionInfoCount() {
        int result = 0;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                result = iSub.getActiveSubInfoCount(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public int getActiveSubscriptionInfoCountMax() {
        int result = 0;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                result = iSub.getActiveSubInfoCountMax();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public Uri addSubscriptionInfoRecord(String iccId, int slotIndex) {
        if (iccId == null) {
            SubscriptionManager.logd("[addSubscriptionInfoRecord]- null iccId");
        }
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            SubscriptionManager.logd("[addSubscriptionInfoRecord]- invalid slotIndex");
        }
        this.addSubscriptionInfoRecord(iccId, null, slotIndex, 0);
        return null;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void addSubscriptionInfoRecord(String uniqueId, String displayName, int slotIndex, int subscriptionType) {
        if (uniqueId == null) {
            Log.e(LOG_TAG, "[addSubscriptionInfoRecord]- uniqueId is null");
            return;
        }
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub == null) {
                Log.e(LOG_TAG, "[addSubscriptionInfoRecord]- ISub service is null");
                return;
            }
            int result = iSub.addSubInfo(uniqueId, displayName, slotIndex, subscriptionType);
            if (result < 0) {
                Log.e(LOG_TAG, "Adding of subscription didn't succeed: error = " + result);
            } else {
                SubscriptionManager.logd("successfully added new subscription");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void removeSubscriptionInfoRecord(String uniqueId, int subscriptionType) {
        if (uniqueId == null) {
            Log.e(LOG_TAG, "[addSubscriptionInfoRecord]- uniqueId is null");
            return;
        }
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub == null) {
                Log.e(LOG_TAG, "[removeSubscriptionInfoRecord]- ISub service is null");
                return;
            }
            int result = iSub.removeSubInfo(uniqueId, subscriptionType);
            if (result < 0) {
                Log.e(LOG_TAG, "Removal of subscription didn't succeed: error = " + result);
            } else {
                SubscriptionManager.logd("successfully removed subscription");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public int setIconTint(int tint, int subId) {
        return this.setSubscriptionPropertyHelper(subId, "setIconTint", iSub -> iSub.setIconTint(tint, subId));
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public int setDisplayName(String displayName, int subId, int nameSource) {
        return this.setSubscriptionPropertyHelper(subId, "setDisplayName", iSub -> iSub.setDisplayNameUsingSrc(displayName, subId, nameSource));
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int setDisplayNumber(String number, int subId) {
        if (number == null) {
            SubscriptionManager.logd("[setDisplayNumber]- fail");
            return -1;
        }
        return this.setSubscriptionPropertyHelper(subId, "setDisplayNumber", iSub -> iSub.setDisplayNumber(number, subId));
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int setDataRoaming(int roaming, int subId) {
        return this.setSubscriptionPropertyHelper(subId, "setDataRoaming", iSub -> iSub.setDataRoaming(roaming, subId));
    }

    public static int getSlotIndex(int subscriptionId) {
        return (Integer)sSlotIndexCache.query(subscriptionId);
    }

    public int[] getSubscriptionIds(int slotIndex) {
        return SubscriptionManager.getSubId(slotIndex);
    }

    @UnsupportedAppUsage
    public static int[] getSubId(int slotIndex) {
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            SubscriptionManager.logd("[getSubId]- fail");
            return null;
        }
        int[] subId = null;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                subId = iSub.getSubId(slotIndex);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public static int getPhoneId(int subId) {
        return (Integer)sPhoneIdCache.query(subId);
    }

    private static void logd(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private static void loge(String msg) {
        Rlog.e(LOG_TAG, msg);
    }

    public static int getDefaultSubscriptionId() {
        return (Integer)sDefaultSubIdCache.query(null);
    }

    public static int getDefaultVoiceSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                subId = iSub.getDefaultVoiceSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setDefaultVoiceSubscriptionId(int subscriptionId) {
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                iSub.setDefaultVoiceSubId(subscriptionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setDefaultVoiceSubId(int subId) {
        this.setDefaultVoiceSubscriptionId(subId);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public SubscriptionInfo getDefaultVoiceSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int getDefaultVoicePhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    public static int getDefaultSmsSubscriptionId() {
        return (Integer)sDefaultSmsSubIdCache.query(null);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setDefaultSmsSubId(int subscriptionId) {
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                iSub.setDefaultSmsSubId(subscriptionId);
            }
        }
        catch (RemoteException ex) {
            ex.rethrowFromSystemServer();
        }
    }

    public SubscriptionInfo getDefaultSmsSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultSmsSubscriptionId());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getDefaultSmsPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultSmsSubscriptionId());
    }

    public static int getDefaultDataSubscriptionId() {
        return (Integer)sDefaultDataSubIdCache.query(null);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setDefaultDataSubId(int subscriptionId) {
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                iSub.setDefaultDataSubId(subscriptionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @UnsupportedAppUsage
    public SubscriptionInfo getDefaultDataSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultDataSubscriptionId());
    }

    @UnsupportedAppUsage
    public int getDefaultDataPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultDataSubscriptionId());
    }

    public void clearSubscriptionInfo() {
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                iSub.clearSubInfo();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean allDefaultsSelected() {
        if (!SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultDataSubscriptionId())) {
            return false;
        }
        if (!SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultSmsSubscriptionId())) {
            return false;
        }
        return SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    public static boolean isValidSubscriptionId(int subscriptionId) {
        return subscriptionId > -1;
    }

    public static boolean isUsableSubscriptionId(int subscriptionId) {
        return SubscriptionManager.isUsableSubIdValue(subscriptionId);
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public static boolean isUsableSubIdValue(int subId) {
        return subId >= 0 && subId <= 0x7FFFFFFE;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static boolean isValidSlotIndex(int slotIndex) {
        return slotIndex >= 0 && slotIndex < TelephonyManager.getDefault().getActiveModemCount();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static boolean isValidPhoneId(int phoneId) {
        return phoneId >= 0 && phoneId < TelephonyManager.getDefault().getActiveModemCount();
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public static void putPhoneIdAndSubIdExtra(Intent intent, int phoneId) {
        int[] subIds = SubscriptionManager.getSubId(phoneId);
        if (subIds != null && subIds.length > 0) {
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId, subIds[0]);
        } else {
            SubscriptionManager.logd("putPhoneIdAndSubIdExtra: no valid subs");
            intent.putExtra("phone", phoneId);
            intent.putExtra(EXTRA_SLOT_INDEX, phoneId);
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static void putPhoneIdAndSubIdExtra(Intent intent, int phoneId, int subId) {
        intent.putExtra(EXTRA_SLOT_INDEX, phoneId);
        intent.putExtra("phone", phoneId);
        SubscriptionManager.putSubscriptionIdExtra(intent, subId);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int[] getActiveSubscriptionIdList() {
        return this.getActiveSubscriptionIdList(true);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int[] getCompleteActiveSubscriptionIdList() {
        return this.getActiveSubscriptionIdList(false);
    }

    public int[] getActiveSubscriptionIdList(boolean visibleOnly) {
        try {
            int[] subId;
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null && (subId = iSub.getActiveSubIdList(visibleOnly)) != null) {
                return subId;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return new int[0];
    }

    public boolean isNetworkRoaming(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        if (phoneId < 0) {
            return false;
        }
        return TelephonyManager.getDefault().isNetworkRoaming(subId);
    }

    public static int getSimStateForSlotIndex(int slotIndex) {
        int simState = 0;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                simState = iSub.getSimStateForSlotIndex(slotIndex);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return simState;
    }

    public static void setSubscriptionProperty(int subId, String propKey, String propValue) {
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                iSub.setSubscriptionProperty(subId, propKey, propValue);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static String serializeUriLists(List<Uri> uris) {
        ArrayList<String> contacts = new ArrayList<String>();
        for (Uri uri : uris) {
            contacts.add(uri.toString());
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(contacts);
            oos.flush();
            return Base64.encodeToString(bos.toByteArray(), 0);
        }
        catch (IOException e) {
            SubscriptionManager.logd("serializeUriLists IO exception");
            return "";
        }
    }

    private static List<Uri> getContactsFromSubscriptionProperty(int subId, String propKey, Context context) {
        String result = SubscriptionManager.getSubscriptionProperty(subId, propKey, context);
        if (result != null) {
            try {
                byte[] b = Base64.decode(result, 0);
                ByteArrayInputStream bis = new ByteArrayInputStream(b);
                ObjectInputStream ois = new ObjectInputStream(bis);
                List contacts = (List)ArrayList.class.cast(ois.readObject());
                ArrayList<Uri> uris = new ArrayList<Uri>();
                for (String contact : contacts) {
                    uris.add(Uri.parse(contact));
                }
                return uris;
            }
            catch (IOException e) {
                SubscriptionManager.logd("getContactsFromSubscriptionProperty IO exception");
            }
            catch (ClassNotFoundException e) {
                SubscriptionManager.logd("getContactsFromSubscriptionProperty ClassNotFound exception");
            }
        }
        return new ArrayList<Uri>();
    }

    private static String getSubscriptionProperty(int subId, String propKey, Context context) {
        String resultValue = null;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                resultValue = iSub.getSubscriptionProperty(subId, propKey, context.getOpPackageName(), context.getAttributionTag());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return resultValue;
    }

    public static boolean getBooleanSubscriptionProperty(int subId, String propKey, boolean defValue, Context context) {
        String result = SubscriptionManager.getSubscriptionProperty(subId, propKey, context);
        if (result != null) {
            try {
                return Integer.parseInt(result) == 1;
            }
            catch (NumberFormatException err) {
                SubscriptionManager.logd("getBooleanSubscriptionProperty NumberFormat exception");
            }
        }
        return defValue;
    }

    public static int getIntegerSubscriptionProperty(int subId, String propKey, int defValue, Context context) {
        String result = SubscriptionManager.getSubscriptionProperty(subId, propKey, context);
        if (result != null) {
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException err) {
                SubscriptionManager.logd("getIntegerSubscriptionProperty NumberFormat exception");
            }
        }
        return defValue;
    }

    public static long getLongSubscriptionProperty(int subId, String propKey, long defValue, Context context) {
        String result = SubscriptionManager.getSubscriptionProperty(subId, propKey, context);
        if (result != null) {
            try {
                return Long.parseLong(result);
            }
            catch (NumberFormatException err) {
                SubscriptionManager.logd("getLongSubscriptionProperty NumberFormat exception");
            }
        }
        return defValue;
    }

    @SystemApi
    public static Resources getResourcesForSubId(Context context, int subId) {
        return SubscriptionManager.getResourcesForSubId(context, subId, false);
    }

    public static Resources getResourcesForSubId(Context context, int subId, boolean useRootLocale) {
        Pair<Context, Integer> cacheKey = null;
        if (SubscriptionManager.isValidSubscriptionId(subId) && !useRootLocale && sResourcesCache.containsKey(cacheKey = Pair.create(context, subId))) {
            return sResourcesCache.get(cacheKey);
        }
        SubscriptionInfo subInfo = SubscriptionManager.from(context).getActiveSubscriptionInfo(subId);
        Configuration overrideConfig = new Configuration();
        if (subInfo != null) {
            overrideConfig.mcc = subInfo.getMcc();
            overrideConfig.mnc = subInfo.getMnc();
            if (overrideConfig.mnc == 0) {
                overrideConfig.mnc = 65535;
                cacheKey = null;
            }
        } else {
            cacheKey = null;
        }
        if (useRootLocale) {
            overrideConfig.setLocale(Locale.ROOT);
        }
        Context newContext = context.createConfigurationContext(overrideConfig);
        Resources res = newContext.getResources();
        if (cacheKey != null) {
            sResourcesCache.put(cacheKey, res);
        }
        return res;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public boolean isActiveSubscriptionId(int subscriptionId) {
        return this.isActiveSubId(subscriptionId);
    }

    @UnsupportedAppUsage
    public boolean isActiveSubId(int subId) {
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                return iSub.isActiveSubId(subId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    public List<SubscriptionPlan> getSubscriptionPlans(int subId) {
        SubscriptionPlan[] subscriptionPlans = this.getNetworkPolicyManager().getSubscriptionPlans(subId, this.mContext.getOpPackageName());
        return subscriptionPlans == null ? Collections.emptyList() : Arrays.asList(subscriptionPlans);
    }

    @Deprecated
    public void setSubscriptionPlans(int subId, List<SubscriptionPlan> plans) {
        this.setSubscriptionPlans(subId, plans, 0L);
    }

    public void setSubscriptionPlans(int subId, List<SubscriptionPlan> plans, long expirationDurationMillis) {
        this.getNetworkPolicyManager().setSubscriptionPlans(subId, plans.toArray(new SubscriptionPlan[0]), expirationDurationMillis, this.mContext.getOpPackageName());
    }

    public void setSubscriptionOverrideUnmetered(int subId, boolean overrideUnmetered, long expirationDurationMillis) {
        this.setSubscriptionOverrideUnmetered(subId, overrideUnmetered, TelephonyManager.getAllNetworkTypes(), expirationDurationMillis);
    }

    public void setSubscriptionOverrideUnmetered(int subId, boolean overrideUnmetered, int[] networkTypes, long expirationDurationMillis) {
        int overrideValue = overrideUnmetered ? 1 : 0;
        this.getNetworkPolicyManager().setSubscriptionOverride(subId, 1, overrideValue, networkTypes, expirationDurationMillis, this.mContext.getOpPackageName());
    }

    public void setSubscriptionOverrideCongested(int subId, boolean overrideCongested, long expirationDurationMillis) {
        this.setSubscriptionOverrideCongested(subId, overrideCongested, TelephonyManager.getAllNetworkTypes(), expirationDurationMillis);
    }

    public void setSubscriptionOverrideCongested(int subId, boolean overrideCongested, int[] networkTypes, long expirationDurationMillis) {
        int overrideValue = overrideCongested ? 2 : 0;
        this.getNetworkPolicyManager().setSubscriptionOverride(subId, 2, overrideValue, networkTypes, expirationDurationMillis, this.mContext.getOpPackageName());
    }

    public boolean canManageSubscription(SubscriptionInfo info) {
        return this.canManageSubscription(info, this.mContext.getPackageName());
    }

    @SystemApi
    public boolean canManageSubscription(SubscriptionInfo info, String packageName) {
        PackageInfo packageInfo;
        if (info == null || info.getAllAccessRules() == null || packageName == null) {
            return false;
        }
        PackageManager packageManager = this.mContext.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0x8000000);
        }
        catch (PackageManager.NameNotFoundException e) {
            SubscriptionManager.logd("Unknown package: " + packageName);
            return false;
        }
        for (UiccAccessRule rule : info.getAllAccessRules()) {
            if (rule.getCarrierPrivilegeStatus(packageInfo) != 1) continue;
            return true;
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setPreferredDataSubscriptionId(int subId, boolean needValidation, final Executor executor, final Consumer<Integer> callback2) {
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub == null) {
                return;
            }
            ISetOpportunisticDataCallback.Stub callbackStub = new ISetOpportunisticDataCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(int result) {
                    if (executor == null || callback2 == null) {
                        return;
                    }
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback2.accept(result));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            };
            iSub.setPreferredDataSubscriptionId(subId, needValidation, callbackStub);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getPreferredDataSubscriptionId() {
        int preferredSubId = Integer.MAX_VALUE;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                preferredSubId = iSub.getPreferredDataSubscriptionId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return preferredSubId;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public List<SubscriptionInfo> getOpportunisticSubscriptions() {
        String contextPkg = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        String contextAttributionTag = this.mContext != null ? this.mContext.getAttributionTag() : null;
        List<Object> subInfoList = null;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                subInfoList = iSub.getOpportunisticSubscriptions(contextPkg, contextAttributionTag);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (subInfoList == null) {
            subInfoList = new ArrayList();
        }
        return subInfoList;
    }

    @RequiresPermission(value="android.permission.WRITE_EMBEDDED_SUBSCRIPTIONS")
    public void switchToSubscription(int subId, PendingIntent callbackIntent) {
        Preconditions.checkNotNull(callbackIntent, "callbackIntent cannot be null");
        EuiccManager euiccManager = new EuiccManager(this.mContext);
        euiccManager.switchToSubscription(subId, callbackIntent);
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean setOpportunistic(boolean opportunistic, int subId) {
        return this.setSubscriptionPropertyHelper(subId, "setOpportunistic", iSub -> iSub.setOpportunistic(opportunistic, subId, this.mContext.getOpPackageName())) == 1;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public ParcelUuid createSubscriptionGroup(List<Integer> subIdList) {
        ParcelUuid groupUuid;
        block5: {
            Preconditions.checkNotNull(subIdList, "can't create group for null subId list");
            String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
            groupUuid = null;
            int[] subIdArray = subIdList.stream().mapToInt(i -> i).toArray();
            try {
                ISub iSub = TelephonyManager.getSubscriptionService();
                if (iSub != null) {
                    groupUuid = iSub.createSubscriptionGroup(subIdArray, pkgForDebug);
                } else if (!this.isSystemProcess()) {
                    throw new IllegalStateException("telephony service is null.");
                }
            }
            catch (RemoteException ex) {
                SubscriptionManager.loge("createSubscriptionGroup RemoteException " + ex);
                if (this.isSystemProcess()) break block5;
                ex.rethrowAsRuntimeException();
            }
        }
        return groupUuid;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void addSubscriptionsIntoGroup(List<Integer> subIdList, ParcelUuid groupUuid) {
        block5: {
            Preconditions.checkNotNull(subIdList, "subIdList can't be null.");
            Preconditions.checkNotNull(groupUuid, "groupUuid can't be null.");
            String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
            int[] subIdArray = subIdList.stream().mapToInt(i -> i).toArray();
            try {
                ISub iSub = TelephonyManager.getSubscriptionService();
                if (iSub != null) {
                    iSub.addSubscriptionsIntoGroup(subIdArray, groupUuid, pkgForDebug);
                } else if (!this.isSystemProcess()) {
                    throw new IllegalStateException("telephony service is null.");
                }
            }
            catch (RemoteException ex) {
                SubscriptionManager.loge("addSubscriptionsIntoGroup RemoteException " + ex);
                if (this.isSystemProcess()) break block5;
                ex.rethrowAsRuntimeException();
            }
        }
    }

    private boolean isSystemProcess() {
        return Process.myUid() == 1000;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void removeSubscriptionsFromGroup(List<Integer> subIdList, ParcelUuid groupUuid) {
        block5: {
            Preconditions.checkNotNull(subIdList, "subIdList can't be null.");
            Preconditions.checkNotNull(groupUuid, "groupUuid can't be null.");
            String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
            int[] subIdArray = subIdList.stream().mapToInt(i -> i).toArray();
            try {
                ISub iSub = TelephonyManager.getSubscriptionService();
                if (iSub != null) {
                    iSub.removeSubscriptionsFromGroup(subIdArray, groupUuid, pkgForDebug);
                } else if (!this.isSystemProcess()) {
                    throw new IllegalStateException("telephony service is null.");
                }
            }
            catch (RemoteException ex) {
                SubscriptionManager.loge("removeSubscriptionsFromGroup RemoteException " + ex);
                if (this.isSystemProcess()) break block5;
                ex.rethrowAsRuntimeException();
            }
        }
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public List<SubscriptionInfo> getSubscriptionsInGroup(ParcelUuid groupUuid) {
        List<SubscriptionInfo> result;
        block5: {
            Preconditions.checkNotNull(groupUuid, "groupUuid can't be null");
            String contextPkg = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
            String contextAttributionTag = this.mContext != null ? this.mContext.getAttributionTag() : null;
            result = null;
            try {
                ISub iSub = TelephonyManager.getSubscriptionService();
                if (iSub != null) {
                    result = iSub.getSubscriptionsInGroup(groupUuid, contextPkg, contextAttributionTag);
                } else if (!this.isSystemProcess()) {
                    throw new IllegalStateException("telephony service is null.");
                }
            }
            catch (RemoteException ex) {
                SubscriptionManager.loge("removeSubscriptionsFromGroup RemoteException " + ex);
                if (this.isSystemProcess()) break block5;
                ex.rethrowAsRuntimeException();
            }
        }
        return result;
    }

    public boolean isSubscriptionVisible(SubscriptionInfo info) {
        if (info == null) {
            return false;
        }
        if (info.getGroupUuid() == null || !info.isOpportunistic()) {
            return true;
        }
        boolean hasCarrierPrivilegePermission = TelephonyManager.from(this.mContext).hasCarrierPrivileges(info.getSubscriptionId()) || this.canManageSubscription(info);
        return hasCarrierPrivilegePermission;
    }

    public List<SubscriptionInfo> getSelectableSubscriptionInfoList() {
        List<SubscriptionInfo> availableList = this.getAvailableSubscriptionInfoList();
        if (availableList == null) {
            return null;
        }
        ArrayList<SubscriptionInfo> selectableList = new ArrayList<SubscriptionInfo>();
        HashMap<ParcelUuid, SubscriptionInfo> groupMap = new HashMap<ParcelUuid, SubscriptionInfo>();
        for (SubscriptionInfo info : availableList) {
            if (!this.isSubscriptionVisible(info)) continue;
            ParcelUuid groupUuid = info.getGroupUuid();
            if (groupUuid == null) {
                selectableList.add(info);
                continue;
            }
            if (groupMap.containsKey(groupUuid) && (((SubscriptionInfo)groupMap.get(groupUuid)).getSimSlotIndex() != -1 || info.getSimSlotIndex() == -1)) continue;
            selectableList.remove(groupMap.get(groupUuid));
            selectableList.add(info);
            groupMap.put(groupUuid, info);
        }
        return selectableList;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean setSubscriptionEnabled(int subscriptionId, boolean enable) {
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                return iSub.setSubscriptionEnabled(enable, subscriptionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setUiccApplicationsEnabled(int subscriptionId, boolean enabled) {
        try {
            ISub iSub = ISub.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getSubscriptionServiceRegisterer().get());
            if (iSub != null) {
                iSub.setUiccApplicationsEnabled(enabled, subscriptionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean canDisablePhysicalSubscription() {
        try {
            ISub iSub = ISub.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getSubscriptionServiceRegisterer().get());
            if (iSub != null) {
                return iSub.canDisablePhysicalSubscription();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isSubscriptionEnabled(int subscriptionId) {
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                return iSub.isSubscriptionEnabled(subscriptionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setDeviceToDeviceStatusSharingPreference(int subscriptionId, int sharing) {
        this.setSubscriptionPropertyHelper(subscriptionId, "setDeviceToDeviceSharingStatus", iSub -> iSub.setDeviceToDeviceStatusSharing(sharing, subscriptionId));
    }

    public int getDeviceToDeviceStatusSharingPreference(int subscriptionId) {
        return SubscriptionManager.getIntegerSubscriptionProperty(subscriptionId, D2D_STATUS_SHARING, 0, this.mContext);
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setDeviceToDeviceStatusSharingContacts(int subscriptionId, List<Uri> contacts) {
        String contactString = SubscriptionManager.serializeUriLists(contacts);
        this.setSubscriptionPropertyHelper(subscriptionId, "setDeviceToDeviceSharingStatus", iSub -> iSub.setDeviceToDeviceStatusSharingContacts(SubscriptionManager.serializeUriLists(contacts), subscriptionId));
    }

    public List<Uri> getDeviceToDeviceStatusSharingContacts(int subscriptionId) {
        return SubscriptionManager.getContactsFromSubscriptionProperty(subscriptionId, D2D_STATUS_SHARING_SELECTED_CONTACTS, this.mContext);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getEnabledSubscriptionId(int slotIndex) {
        int subId = -1;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                subId = iSub.getEnabledSubscriptionId(slotIndex);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private int setSubscriptionPropertyHelper(int subId, String methodName, CallISubMethodHelper helper) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[" + methodName + "]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                result = helper.callMethod(iSub);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public static int getActiveDataSubscriptionId() {
        return (Integer)sActiveDataSubIdCache.query(null);
    }

    public static void putSubscriptionIdExtra(Intent intent, int subId) {
        intent.putExtra(EXTRA_SUBSCRIPTION_INDEX, subId);
        intent.putExtra("subscription", subId);
    }

    public static void invalidateDefaultSubIdCaches() {
        PropertyInvalidatedCache.invalidateCache(CACHE_KEY_DEFAULT_SUB_ID_PROPERTY);
    }

    public static void invalidateDefaultDataSubIdCaches() {
        PropertyInvalidatedCache.invalidateCache(CACHE_KEY_DEFAULT_DATA_SUB_ID_PROPERTY);
    }

    public static void invalidateDefaultSmsSubIdCaches() {
        PropertyInvalidatedCache.invalidateCache(CACHE_KEY_DEFAULT_SMS_SUB_ID_PROPERTY);
    }

    public static void invalidateActiveDataSubIdCaches() {
        PropertyInvalidatedCache.invalidateCache(CACHE_KEY_ACTIVE_DATA_SUB_ID_PROPERTY);
    }

    public static void invalidateSlotIndexCaches() {
        PropertyInvalidatedCache.invalidateCache(CACHE_KEY_SLOT_INDEX_PROPERTY);
    }

    public static void disableCaching() {
        sDefaultSubIdCache.disableLocal();
        sDefaultDataSubIdCache.disableLocal();
        sActiveDataSubIdCache.disableLocal();
        sDefaultSmsSubIdCache.disableLocal();
        sSlotIndexCache.disableLocal();
        sPhoneIdCache.disableLocal();
    }

    public static void clearCaches() {
        sDefaultSubIdCache.clear();
        sDefaultDataSubIdCache.clear();
        sActiveDataSubIdCache.clear();
        sDefaultSmsSubIdCache.clear();
        sSlotIndexCache.clear();
        sPhoneIdCache.clear();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public byte[] getAllSimSpecificSettingsForBackup() {
        Bundle bundle = this.mContext.getContentResolver().call(SIM_INFO_BACKUP_AND_RESTORE_CONTENT_URI, GET_SIM_SPECIFIC_SETTINGS_METHOD_NAME, null, null);
        return bundle.getByteArray(KEY_SIM_SPECIFIC_SETTINGS_DATA);
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void restoreSimSpecificSettingsForIccIdFromBackup(String iccId) {
        this.mContext.getContentResolver().call(SIM_INFO_BACKUP_AND_RESTORE_CONTENT_URI, RESTORE_SIM_SPECIFIC_SETTINGS_METHOD_NAME, iccId, null);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void restoreAllSimSpecificSettingsFromBackup(byte[] data) {
        Bundle bundle = new Bundle();
        bundle.putByteArray(KEY_SIM_SPECIFIC_SETTINGS_DATA, data);
        this.mContext.getContentResolver().call(SIM_INFO_BACKUP_AND_RESTORE_CONTENT_URI, RESTORE_SIM_SPECIFIC_SETTINGS_METHOD_NAME, null, bundle);
    }

    @RequiresPermission(anyOf={"android.permission.READ_PHONE_NUMBERS", "android.permission.READ_PRIVILEGED_PHONE_STATE", "carrier privileges"})
    public String getPhoneNumber(int subscriptionId, int source) {
        if (subscriptionId == Integer.MAX_VALUE) {
            subscriptionId = SubscriptionManager.getDefaultSubscriptionId();
        }
        if (source != 1 && source != 2 && source != 3) {
            throw new IllegalArgumentException("invalid source " + source);
        }
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                return iSub.getPhoneNumber(subscriptionId, source, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            throw new IllegalStateException("subscription service unavailable.");
        }
        catch (RemoteException ex) {
            throw ex.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PHONE_NUMBERS", "android.permission.READ_PRIVILEGED_PHONE_STATE", "carrier privileges"})
    public String getPhoneNumber(int subscriptionId) {
        if (subscriptionId == Integer.MAX_VALUE) {
            subscriptionId = SubscriptionManager.getDefaultSubscriptionId();
        }
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub != null) {
                return iSub.getPhoneNumberFromFirstAvailableSource(subscriptionId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            throw new IllegalStateException("subscription service unavailable.");
        }
        catch (RemoteException ex) {
            throw ex.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="carrier privileges")
    public void setCarrierPhoneNumber(int subscriptionId, String number) {
        if (subscriptionId == Integer.MAX_VALUE) {
            subscriptionId = SubscriptionManager.getDefaultSubscriptionId();
        }
        if (number == null) {
            throw new NullPointerException("invalid number null");
        }
        try {
            ISub iSub = TelephonyManager.getSubscriptionService();
            if (iSub == null) {
                throw new IllegalStateException("subscription service unavailable.");
            }
            iSub.setPhoneNumber(subscriptionId, 2, number, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException ex) {
            throw ex.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    void setUsageSetting(int subscriptionId, int usageSetting) {
        this.setSubscriptionPropertyHelper(subscriptionId, "setUsageSetting", iSub -> iSub.setUsageSetting(usageSetting, subscriptionId, this.mContext.getOpPackageName()));
    }

    private static interface CallISubMethodHelper {
        public int callMethod(ISub var1) throws RemoteException;
    }

    public static class OnOpportunisticSubscriptionsChangedListener {
        public void onOpportunisticSubscriptionsChanged() {
        }

        private void log(String s) {
            Rlog.d(SubscriptionManager.LOG_TAG, s);
        }
    }

    public static class OnSubscriptionsChangedListener {
        private final HandlerExecutor mExecutor;

        public HandlerExecutor getHandlerExecutor() {
            return this.mExecutor;
        }

        public OnSubscriptionsChangedListener() {
            this.mExecutor = new HandlerExecutor(new OnSubscriptionsChangedListenerHandler());
        }

        public OnSubscriptionsChangedListener(Looper looper) {
            this.mExecutor = new HandlerExecutor(new OnSubscriptionsChangedListenerHandler(looper));
        }

        public void onSubscriptionsChanged() {
        }

        public void onAddListenerFailed() {
            Rlog.w(SubscriptionManager.LOG_TAG, "onAddListenerFailed not overridden");
        }

        private void log(String s) {
            Rlog.d(SubscriptionManager.LOG_TAG, s);
        }

        private class OnSubscriptionsChangedListenerHandler
        extends Handler {
            OnSubscriptionsChangedListenerHandler() {
            }

            OnSubscriptionsChangedListenerHandler(Looper looper) {
                super(looper);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PhoneNumberSource {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UsageSetting {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProfileClass {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceToDeviceStatusSharingPreference {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SimDisplayNameSource {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SubscriptionType {
    }

    private static class IntegerPropertyInvalidatedCache<T>
    extends PropertyInvalidatedCache<Integer, T> {
        private final FunctionalUtils.ThrowingBiFunction<ISub, Integer, T> mInterfaceMethod;
        private final String mCacheKeyProperty;
        private final T mDefaultValue;

        IntegerPropertyInvalidatedCache(FunctionalUtils.ThrowingBiFunction<ISub, Integer, T> subscriptionInterfaceMethod, String cacheKeyProperty, T defaultValue) {
            super(4, cacheKeyProperty);
            this.mInterfaceMethod = subscriptionInterfaceMethod;
            this.mCacheKeyProperty = cacheKeyProperty;
            this.mDefaultValue = defaultValue;
        }

        @Override
        public T recompute(Integer query) {
            T result = this.mDefaultValue;
            try {
                ISub iSub = TelephonyManager.getSubscriptionService();
                if (iSub != null) {
                    result = this.mInterfaceMethod.applyOrThrow(iSub, query);
                }
            }
            catch (Exception ex) {
                Rlog.w(SubscriptionManager.LOG_TAG, "Failed to recompute cache key for " + this.mCacheKeyProperty);
            }
            return result;
        }
    }

    private static class VoidPropertyInvalidatedCache<T>
    extends PropertyInvalidatedCache<Void, T> {
        private final FunctionalUtils.ThrowingFunction<ISub, T> mInterfaceMethod;
        private final String mCacheKeyProperty;
        private final T mDefaultValue;

        VoidPropertyInvalidatedCache(FunctionalUtils.ThrowingFunction<ISub, T> subscriptionInterfaceMethod, String cacheKeyProperty, T defaultValue) {
            super(4, cacheKeyProperty);
            this.mInterfaceMethod = subscriptionInterfaceMethod;
            this.mCacheKeyProperty = cacheKeyProperty;
            this.mDefaultValue = defaultValue;
        }

        @Override
        public T recompute(Void aVoid) {
            T result = this.mDefaultValue;
            try {
                ISub iSub = TelephonyManager.getSubscriptionService();
                if (iSub != null) {
                    result = this.mInterfaceMethod.applyOrThrow(iSub);
                }
            }
            catch (Exception ex) {
                Rlog.w(SubscriptionManager.LOG_TAG, "Failed to recompute cache key for " + this.mCacheKeyProperty);
            }
            return result;
        }
    }
}

