/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.SubscriptionInfo;
import java.util.Objects;

public class UiccPortInfo
implements Parcelable {
    private final String mIccId;
    private final int mPortIndex;
    private final int mLogicalSlotIndex;
    private final boolean mIsActive;
    public static final String ICCID_REDACTED = "FFFFFFFFFFFFFFFFFFFF";
    public static final Parcelable.Creator<UiccPortInfo> CREATOR = new Parcelable.Creator<UiccPortInfo>(){

        @Override
        public UiccPortInfo createFromParcel(Parcel in) {
            return new UiccPortInfo(in);
        }

        public UiccPortInfo[] newArray(int size) {
            return new UiccPortInfo[size];
        }
    };

    private UiccPortInfo(Parcel in) {
        this.mIccId = in.readString8();
        this.mPortIndex = in.readInt();
        this.mLogicalSlotIndex = in.readInt();
        this.mIsActive = in.readBoolean();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString8(this.mIccId);
        dest.writeInt(this.mPortIndex);
        dest.writeInt(this.mLogicalSlotIndex);
        dest.writeBoolean(this.mIsActive);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public UiccPortInfo(String iccId, int portIndex, int logicalSlotIndex, boolean isActive) {
        this.mIccId = iccId;
        this.mPortIndex = portIndex;
        this.mLogicalSlotIndex = logicalSlotIndex;
        this.mIsActive = isActive;
    }

    public String getIccId() {
        return this.mIccId;
    }

    public int getPortIndex() {
        return this.mPortIndex;
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    public int getLogicalSlotIndex() {
        return this.mLogicalSlotIndex;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UiccPortInfo that = (UiccPortInfo)obj;
        return Objects.equals(this.mIccId, that.mIccId) && this.mPortIndex == that.mPortIndex && this.mLogicalSlotIndex == that.mLogicalSlotIndex && this.mIsActive == that.mIsActive;
    }

    public int hashCode() {
        return Objects.hash(this.mIccId, this.mPortIndex, this.mLogicalSlotIndex, this.mIsActive);
    }

    public String toString() {
        return "UiccPortInfo (isActive=" + this.mIsActive + ", iccId=" + SubscriptionInfo.givePrintableIccid(this.mIccId) + ", portIndex=" + this.mPortIndex + ", mLogicalSlotIndex=" + this.mLogicalSlotIndex + ")";
    }
}

