/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.VideoProfile;
import android.telephony.emergency.EmergencyNumber;
import android.telephony.ims.ImsStreamMediaProfile;
import android.telephony.ims.RtpHeaderExtensionType;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.util.TelephonyUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@SystemApi
public class ImsCallProfile
implements Parcelable {
    private static final String TAG = "ImsCallProfile";
    public static final int SERVICE_TYPE_NONE = 0;
    public static final int SERVICE_TYPE_NORMAL = 1;
    public static final int SERVICE_TYPE_EMERGENCY = 2;
    public static final int CALL_TYPE_VOICE_N_VIDEO = 1;
    public static final int CALL_TYPE_VOICE = 2;
    public static final int CALL_TYPE_VIDEO_N_VOICE = 3;
    public static final int CALL_TYPE_VT = 4;
    public static final int CALL_TYPE_VT_TX = 5;
    public static final int CALL_TYPE_VT_RX = 6;
    public static final int CALL_TYPE_VT_NODIR = 7;
    public static final int CALL_TYPE_VS = 8;
    public static final int CALL_TYPE_VS_TX = 9;
    public static final int CALL_TYPE_VS_RX = 10;
    @SystemApi
    public static final String EXTRA_CONFERENCE = "android.telephony.ims.extra.CONFERENCE";
    public static final String EXTRA_CONFERENCE_DEPRECATED = "conference";
    public static final String EXTRA_EMERGENCY_CALL = "e_call";
    public static final String EXTRA_VMS = "vms";
    public static final String EXTRA_CALL_MODE_CHANGEABLE = "call_mode_changeable";
    @SystemApi
    public static final String EXTRA_EXTENDING_TO_CONFERENCE_SUPPORTED = "android.telephony.ims.extra.EXTENDING_TO_CONFERENCE_SUPPORTED";
    public static final String EXTRA_CONFERENCE_AVAIL = "conference_avail";
    public static final String EXTRA_OEM_EXTRAS = "android.telephony.ims.extra.OEM_EXTRAS";
    public static final String EXTRA_OIR = "oir";
    public static final String EXTRA_CNAP = "cnap";
    public static final String EXTRA_DIALSTRING = "dialstring";
    public static final String EXTRA_RETRY_CALL_FAIL_REASON = "android.telephony.ims.extra.RETRY_CALL_FAIL_REASON";
    public static final String EXTRA_RETRY_CALL_FAIL_NETWORKTYPE = "android.telephony.ims.extra.RETRY_CALL_FAIL_NETWORKTYPE";
    public static final String EXTRA_PRIORITY = "android.telephony.ims.extra.PRIORITY";
    public static final String EXTRA_CALL_SUBJECT = "android.telephony.ims.extra.CALL_SUBJECT";
    public static final String EXTRA_LOCATION = "android.telephony.ims.extra.LOCATION";
    public static final String EXTRA_PICTURE_URL = "android.telephony.ims.extra.PICTURE_URL";
    public static final String EXTRA_IS_BUSINESS_CALL = "android.telephony.ims.extra.IS_BUSINESS_CALL";
    public static final int OIR_DEFAULT = 0;
    public static final int OIR_PRESENTATION_RESTRICTED = 1;
    public static final int OIR_PRESENTATION_NOT_RESTRICTED = 2;
    public static final int OIR_PRESENTATION_UNKNOWN = 3;
    public static final int OIR_PRESENTATION_PAYPHONE = 4;
    public static final int OIR_PRESENTATION_UNAVAILABLE = 5;
    public static final int DIALSTRING_NORMAL = 0;
    public static final int DIALSTRING_SS_CONF = 1;
    public static final int DIALSTRING_USSD = 2;
    public static final int PRIORITY_NORMAL = 0;
    public static final int PRIORITY_URGENT = 1;
    public static final int CALL_RESTRICT_CAUSE_NONE = 0;
    public static final int CALL_RESTRICT_CAUSE_RAT = 1;
    public static final int CALL_RESTRICT_CAUSE_DISABLED = 2;
    public static final int CALL_RESTRICT_CAUSE_HD = 3;
    public static final String EXTRA_OI = "oi";
    public static final String EXTRA_CNA = "cna";
    public static final String EXTRA_USSD = "ussd";
    public static final String EXTRA_REMOTE_URI = "remote_uri";
    public static final String EXTRA_CHILD_NUMBER = "ChildNum";
    public static final String EXTRA_CODEC = "Codec";
    public static final String EXTRA_DISPLAY_TEXT = "DisplayText";
    public static final String EXTRA_ADDITIONAL_CALL_INFO = "AdditionalCallInfo";
    public static final String EXTRA_IS_CALL_PULL = "CallPull";
    public static final String EXTRA_ADDITIONAL_SIP_INVITE_FIELDS = "android.telephony.ims.extra.ADDITIONAL_SIP_INVITE_FIELDS";
    public static final String EXTRA_CALL_DISCONNECT_CAUSE = "android.telephony.ims.extra.CALL_DISCONNECT_CAUSE";
    @Deprecated
    public static final String EXTRA_CALL_RAT_TYPE = "CallRadioTech";
    public static final String EXTRA_CALL_NETWORK_TYPE = "android.telephony.ims.extra.CALL_NETWORK_TYPE";
    @Deprecated
    public static final String EXTRA_CALL_RAT_TYPE_ALT = "callRadioTech";
    public static final String EXTRA_FORWARDED_NUMBER = "android.telephony.ims.extra.FORWARDED_NUMBER";
    public static final String EXTRA_IS_CROSS_SIM_CALL = "android.telephony.ims.extra.IS_CROSS_SIM_CALL";
    public int mServiceType;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int mCallType;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int mRestrictCause = 0;
    private int mCallerNumberVerificationStatus;
    public static final int VERIFICATION_STATUS_NOT_VERIFIED = 0;
    public static final int VERIFICATION_STATUS_PASSED = 1;
    public static final int VERIFICATION_STATUS_FAILED = 2;
    private int mEmergencyServiceCategories = 0;
    private List<String> mEmergencyUrns = new ArrayList<String>();
    private int mEmergencyCallRouting = 0;
    private boolean mEmergencyCallTesting = false;
    private boolean mHasKnownUserIntentEmergency = false;
    private Set<RtpHeaderExtensionType> mAcceptedRtpHeaderExtensionTypes = new ArraySet<RtpHeaderExtensionType>();
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public Bundle mCallExtras;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public ImsStreamMediaProfile mMediaProfile;
    public static final Parcelable.Creator<ImsCallProfile> CREATOR = new Parcelable.Creator<ImsCallProfile>(){

        @Override
        public ImsCallProfile createFromParcel(Parcel in) {
            return new ImsCallProfile(in);
        }

        public ImsCallProfile[] newArray(int size) {
            return new ImsCallProfile[size];
        }
    };

    public ImsCallProfile(Parcel in) {
        this.readFromParcel(in);
    }

    public ImsCallProfile() {
        this.mServiceType = 1;
        this.mCallType = 1;
        this.mCallExtras = new Bundle();
        this.mMediaProfile = new ImsStreamMediaProfile();
    }

    public ImsCallProfile(int serviceType, int callType) {
        this.mServiceType = serviceType;
        this.mCallType = callType;
        this.mCallExtras = new Bundle();
        this.mMediaProfile = new ImsStreamMediaProfile();
    }

    public ImsCallProfile(int serviceType, int callType, Bundle callExtras, ImsStreamMediaProfile mediaProfile) {
        this.mServiceType = serviceType;
        this.mCallType = callType;
        this.mCallExtras = callExtras;
        this.mMediaProfile = mediaProfile;
    }

    public String getCallExtra(String name) {
        return this.getCallExtra(name, "");
    }

    public String getCallExtra(String name, String defaultValue) {
        if (this.mCallExtras == null) {
            return defaultValue;
        }
        return this.mCallExtras.getString(name, defaultValue);
    }

    public boolean getCallExtraBoolean(String name) {
        return this.getCallExtraBoolean(name, false);
    }

    public boolean getCallExtraBoolean(String name, boolean defaultValue) {
        if (this.mCallExtras == null) {
            return defaultValue;
        }
        return this.mCallExtras.getBoolean(name, defaultValue);
    }

    public int getCallExtraInt(String name) {
        return this.getCallExtraInt(name, -1);
    }

    public int getCallExtraInt(String name, int defaultValue) {
        if (this.mCallExtras == null) {
            return defaultValue;
        }
        return this.mCallExtras.getInt(name, defaultValue);
    }

    public <T extends Parcelable> T getCallExtraParcelable(String name) {
        if (this.mCallExtras != null) {
            return this.mCallExtras.getParcelable(name);
        }
        return null;
    }

    public void setCallExtra(String name, String value2) {
        if (this.mCallExtras != null) {
            this.mCallExtras.putString(name, value2);
        }
    }

    public void setCallExtraBoolean(String name, boolean value2) {
        if (this.mCallExtras != null) {
            this.mCallExtras.putBoolean(name, value2);
        }
    }

    public void setCallExtraInt(String name, int value2) {
        if (this.mCallExtras != null) {
            this.mCallExtras.putInt(name, value2);
        }
    }

    public void setCallExtraParcelable(String name, Parcelable parcelable) {
        if (this.mCallExtras != null) {
            this.mCallExtras.putParcelable(name, parcelable);
        }
    }

    public void setCallRestrictCause(int cause) {
        this.mRestrictCause = cause;
    }

    public void updateCallType(ImsCallProfile profile) {
        this.mCallType = profile.mCallType;
    }

    public void updateCallExtras(ImsCallProfile profile) {
        this.mCallExtras.clear();
        this.mCallExtras = (Bundle)profile.mCallExtras.clone();
    }

    public void updateMediaProfile(ImsCallProfile profile) {
        this.mMediaProfile = profile.mMediaProfile;
    }

    public void setCallerNumberVerificationStatus(int callerNumberVerificationStatus) {
        this.mCallerNumberVerificationStatus = callerNumberVerificationStatus;
    }

    public int getCallerNumberVerificationStatus() {
        return this.mCallerNumberVerificationStatus;
    }

    public String toString() {
        return "{ serviceType=" + this.mServiceType + ", callType=" + this.mCallType + ", restrictCause=" + this.mRestrictCause + ", mediaProfile=" + (this.mMediaProfile != null ? this.mMediaProfile.toString() : "null") + ", emergencyServiceCategories=" + this.mEmergencyServiceCategories + ", emergencyUrns=" + this.mEmergencyUrns + ", emergencyCallRouting=" + this.mEmergencyCallRouting + ", emergencyCallTesting=" + this.mEmergencyCallTesting + ", hasKnownUserIntentEmergency=" + this.mHasKnownUserIntentEmergency + ", mRestrictCause=" + this.mRestrictCause + ", mCallerNumberVerstat= " + this.mCallerNumberVerificationStatus + ", mAcceptedRtpHeaderExtensions= " + this.mAcceptedRtpHeaderExtensionTypes + " }";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        Bundle filteredExtras = this.maybeCleanseExtras(this.mCallExtras);
        out.writeInt(this.mServiceType);
        out.writeInt(this.mCallType);
        out.writeBundle(filteredExtras);
        out.writeParcelable(this.mMediaProfile, 0);
        out.writeInt(this.mEmergencyServiceCategories);
        out.writeStringList(this.mEmergencyUrns);
        out.writeInt(this.mEmergencyCallRouting);
        out.writeBoolean(this.mEmergencyCallTesting);
        out.writeBoolean(this.mHasKnownUserIntentEmergency);
        out.writeInt(this.mRestrictCause);
        out.writeInt(this.mCallerNumberVerificationStatus);
        out.writeArray(this.mAcceptedRtpHeaderExtensionTypes.toArray());
    }

    private void readFromParcel(Parcel in) {
        this.mServiceType = in.readInt();
        this.mCallType = in.readInt();
        this.mCallExtras = in.readBundle();
        this.mMediaProfile = in.readParcelable(ImsStreamMediaProfile.class.getClassLoader(), ImsStreamMediaProfile.class);
        this.mEmergencyServiceCategories = in.readInt();
        this.mEmergencyUrns = in.createStringArrayList();
        this.mEmergencyCallRouting = in.readInt();
        this.mEmergencyCallTesting = in.readBoolean();
        this.mHasKnownUserIntentEmergency = in.readBoolean();
        this.mRestrictCause = in.readInt();
        this.mCallerNumberVerificationStatus = in.readInt();
        RtpHeaderExtensionType[] accepted = in.readArray(RtpHeaderExtensionType.class.getClassLoader(), RtpHeaderExtensionType.class);
        this.mAcceptedRtpHeaderExtensionTypes = Arrays.stream(accepted).map(o -> (RtpHeaderExtensionType)o).collect(Collectors.toSet());
    }

    public int getServiceType() {
        return this.mServiceType;
    }

    public int getCallType() {
        return this.mCallType;
    }

    public int getRestrictCause() {
        return this.mRestrictCause;
    }

    public Bundle getCallExtras() {
        return this.mCallExtras;
    }

    public Bundle getProprietaryCallExtras() {
        if (this.mCallExtras == null) {
            return new Bundle();
        }
        Bundle proprietaryExtras = this.mCallExtras.getBundle(EXTRA_OEM_EXTRAS);
        if (proprietaryExtras == null) {
            return new Bundle();
        }
        return new Bundle(proprietaryExtras);
    }

    public ImsStreamMediaProfile getMediaProfile() {
        return this.mMediaProfile;
    }

    public static int getVideoStateFromImsCallProfile(ImsCallProfile callProfile) {
        int videostate = ImsCallProfile.getVideoStateFromCallType(callProfile.mCallType);
        videostate = callProfile.isVideoPaused() && !VideoProfile.isAudioOnly(videostate) ? (videostate |= 4) : (videostate &= 0xFFFFFFFB);
        return videostate;
    }

    public static int getVideoStateFromCallType(int callType) {
        int videostate = 0;
        switch (callType) {
            case 5: {
                videostate = 1;
                break;
            }
            case 6: {
                videostate = 2;
                break;
            }
            case 4: {
                videostate = 3;
                break;
            }
            case 2: {
                videostate = 0;
                break;
            }
            default: {
                videostate = 0;
            }
        }
        return videostate;
    }

    public static int getCallTypeFromVideoState(int videoState) {
        boolean videoTx = ImsCallProfile.isVideoStateSet(videoState, 1);
        boolean videoRx = ImsCallProfile.isVideoStateSet(videoState, 2);
        boolean isPaused = ImsCallProfile.isVideoStateSet(videoState, 4);
        if (isPaused) {
            return 7;
        }
        if (videoTx && !videoRx) {
            return 5;
        }
        if (!videoTx && videoRx) {
            return 6;
        }
        if (videoTx && videoRx) {
            return 4;
        }
        return 2;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int presentationToOIR(int presentation) {
        switch (presentation) {
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 5: {
                return 5;
            }
        }
        return 0;
    }

    public static int presentationToOir(int presentation) {
        return ImsCallProfile.presentationToOIR(presentation);
    }

    public static int OIRToPresentation(int oir) {
        switch (oir) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 3: {
                return 3;
            }
        }
        return 3;
    }

    public boolean isVideoPaused() {
        return this.mMediaProfile.mVideoDirection == 0;
    }

    public boolean isVideoCall() {
        return VideoProfile.isVideo(ImsCallProfile.getVideoStateFromCallType(this.mCallType));
    }

    private Bundle maybeCleanseExtras(Bundle extras) {
        Bundle filtered;
        int endSize;
        if (extras == null) {
            return null;
        }
        int startSize = extras.size();
        if (startSize != (endSize = (filtered = TelephonyUtils.filterValues(extras)).size())) {
            Log.i(TAG, "maybeCleanseExtras: " + (startSize - endSize) + " extra values were removed - only primitive types and system parcelables are permitted.");
        }
        return filtered;
    }

    private static boolean isVideoStateSet(int videoState, int videoStateToCheck) {
        return (videoState & videoStateToCheck) == videoStateToCheck;
    }

    public void setEmergencyCallInfo(EmergencyNumber num, boolean hasKnownUserIntentEmergency) {
        this.setEmergencyServiceCategories(num.getEmergencyServiceCategoryBitmaskInternalDial());
        this.setEmergencyUrns(num.getEmergencyUrns());
        this.setEmergencyCallRouting(num.getEmergencyCallRouting());
        this.setEmergencyCallTesting(num.getEmergencyNumberSourceBitmask() == 32);
        this.setHasKnownUserIntentEmergency(hasKnownUserIntentEmergency);
    }

    @VisibleForTesting
    public void setEmergencyServiceCategories(int emergencyServiceCategories) {
        this.mEmergencyServiceCategories = emergencyServiceCategories;
    }

    @VisibleForTesting
    public void setEmergencyUrns(List<String> emergencyUrns) {
        this.mEmergencyUrns = emergencyUrns;
    }

    @VisibleForTesting
    public void setEmergencyCallRouting(int emergencyCallRouting) {
        this.mEmergencyCallRouting = emergencyCallRouting;
    }

    @VisibleForTesting
    public void setEmergencyCallTesting(boolean isTesting) {
        this.mEmergencyCallTesting = isTesting;
    }

    @VisibleForTesting
    public void setHasKnownUserIntentEmergency(boolean hasKnownUserIntentEmergency) {
        this.mHasKnownUserIntentEmergency = hasKnownUserIntentEmergency;
    }

    public int getEmergencyServiceCategories() {
        return this.mEmergencyServiceCategories;
    }

    public List<String> getEmergencyUrns() {
        return this.mEmergencyUrns;
    }

    public int getEmergencyCallRouting() {
        return this.mEmergencyCallRouting;
    }

    public boolean isEmergencyCallTesting() {
        return this.mEmergencyCallTesting;
    }

    public boolean hasKnownUserIntentEmergency() {
        return this.mHasKnownUserIntentEmergency;
    }

    public Set<RtpHeaderExtensionType> getAcceptedRtpHeaderExtensionTypes() {
        return this.mAcceptedRtpHeaderExtensionTypes;
    }

    public void setAcceptedRtpHeaderExtensionTypes(Set<RtpHeaderExtensionType> rtpHeaderExtensions) {
        this.mAcceptedRtpHeaderExtensionTypes.clear();
        this.mAcceptedRtpHeaderExtensionTypes.addAll(rtpHeaderExtensions);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VerificationStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CallRestrictCause {
    }
}

