/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.telephony.BinderCacheManager;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.ims.ImsMmTelManager;
import android.telephony.ims.ImsRcsManager;
import android.telephony.ims.ProvisioningManager;
import android.telephony.ims.SipDelegateManager;
import android.telephony.ims.aidl.IImsRcsController;
import com.android.internal.telephony.ITelephony;

public class ImsManager {
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_FORBIDDEN_NO_SERVICE_AUTHORIZATION = "com.android.internal.intent.action.ACTION_FORBIDDEN_NO_SERVICE_AUTHORIZATION";
    public static final String ACTION_WFC_IMS_REGISTRATION_ERROR = "android.telephony.ims.action.WFC_IMS_REGISTRATION_ERROR";
    public static final String EXTRA_WFC_REGISTRATION_FAILURE_TITLE = "android.telephony.ims.extra.WFC_REGISTRATION_FAILURE_TITLE";
    public static final String EXTRA_WFC_REGISTRATION_FAILURE_MESSAGE = "android.telephony.ims.extra.WFC_REGISTRATION_FAILURE_MESSAGE";
    private static final BinderCacheManager<ITelephony> sTelephonyCache = new BinderCacheManager<ITelephony>(ImsManager::getITelephonyInterface);
    private static final BinderCacheManager<IImsRcsController> sRcsCache = new BinderCacheManager<IImsRcsController>(ImsManager::getIImsRcsControllerInterface);
    private final Context mContext;

    public ImsManager(Context context) {
        this.mContext = context;
    }

    public ImsRcsManager getImsRcsManager(int subscriptionId) {
        if (!SubscriptionManager.isValidSubscriptionId(subscriptionId)) {
            throw new IllegalArgumentException("Invalid subscription ID: " + subscriptionId);
        }
        return new ImsRcsManager(this.mContext, subscriptionId, sRcsCache, sTelephonyCache);
    }

    public ImsMmTelManager getImsMmTelManager(int subscriptionId) {
        if (!SubscriptionManager.isValidSubscriptionId(subscriptionId)) {
            throw new IllegalArgumentException("Invalid subscription ID: " + subscriptionId);
        }
        return new ImsMmTelManager(this.mContext, subscriptionId, sTelephonyCache);
    }

    @SystemApi
    public SipDelegateManager getSipDelegateManager(int subscriptionId) {
        if (!SubscriptionManager.isValidSubscriptionId(subscriptionId)) {
            throw new IllegalArgumentException("Invalid subscription ID: " + subscriptionId);
        }
        return new SipDelegateManager(this.mContext, subscriptionId, sRcsCache, sTelephonyCache);
    }

    public ProvisioningManager getProvisioningManager(int subscriptionId) {
        if (!SubscriptionManager.isValidSubscriptionId(subscriptionId)) {
            throw new IllegalArgumentException("Invalid subscription ID: " + subscriptionId);
        }
        return new ProvisioningManager(subscriptionId);
    }

    private static IImsRcsController getIImsRcsControllerInterface() {
        return IImsRcsController.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyImsServiceRegisterer().get());
    }

    private static ITelephony getITelephonyInterface() {
        return ITelephony.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyServiceRegisterer().get());
    }
}

