/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ims.RegistrationManager;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class ImsRegistrationAttributes
implements Parcelable {
    public static final int ATTR_EPDG_OVER_CELL_INTERNET = 1;
    private final int mRegistrationTech;
    private final int mTransportType;
    private final int mImsAttributeFlags;
    private final ArrayList<String> mFeatureTags;
    public static final Parcelable.Creator<ImsRegistrationAttributes> CREATOR = new Parcelable.Creator<ImsRegistrationAttributes>(){

        @Override
        public ImsRegistrationAttributes createFromParcel(Parcel source) {
            return new ImsRegistrationAttributes(source);
        }

        public ImsRegistrationAttributes[] newArray(int size) {
            return new ImsRegistrationAttributes[size];
        }
    };

    public ImsRegistrationAttributes(int registrationTech, int transportType, int imsAttributeFlags, Set<String> featureTags) {
        this.mRegistrationTech = registrationTech;
        this.mTransportType = transportType;
        this.mImsAttributeFlags = imsAttributeFlags;
        this.mFeatureTags = new ArrayList<String>(featureTags);
    }

    public ImsRegistrationAttributes(Parcel source) {
        this.mRegistrationTech = source.readInt();
        this.mTransportType = source.readInt();
        this.mImsAttributeFlags = source.readInt();
        this.mFeatureTags = new ArrayList();
        source.readList(this.mFeatureTags, null, String.class);
    }

    @SystemApi
    public int getRegistrationTechnology() {
        return this.mRegistrationTech;
    }

    public int getTransportType() {
        return this.mTransportType;
    }

    public int getAttributeFlags() {
        return this.mImsAttributeFlags;
    }

    public Set<String> getFeatureTags() {
        if (this.mFeatureTags == null) {
            return Collections.emptySet();
        }
        return new ArraySet<String>(this.mFeatureTags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mRegistrationTech);
        dest.writeInt(this.mTransportType);
        dest.writeInt(this.mImsAttributeFlags);
        dest.writeList(this.mFeatureTags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImsRegistrationAttributes that = (ImsRegistrationAttributes)o;
        return this.mRegistrationTech == that.mRegistrationTech && this.mTransportType == that.mTransportType && this.mImsAttributeFlags == that.mImsAttributeFlags && Objects.equals(this.mFeatureTags, that.mFeatureTags);
    }

    public int hashCode() {
        return Objects.hash(this.mRegistrationTech, this.mTransportType, this.mImsAttributeFlags, this.mFeatureTags);
    }

    public String toString() {
        return "ImsRegistrationAttributes { transportType= " + this.mTransportType + ", attributeFlags=" + this.mImsAttributeFlags + ", featureTags=[" + this.mFeatureTags + "]}";
    }

    @SystemApi
    public static class Builder {
        private final int mRegistrationTech;
        private Set<String> mFeatureTags = Collections.emptySet();

        public Builder(int registrationTech) {
            this.mRegistrationTech = registrationTech;
        }

        public Builder setFeatureTags(Set<String> tags) {
            if (tags == null) {
                throw new IllegalArgumentException("feature tag set must not be null");
            }
            this.mFeatureTags = new ArraySet<String>(tags);
            return this;
        }

        public ImsRegistrationAttributes build() {
            return new ImsRegistrationAttributes(this.mRegistrationTech, RegistrationManager.getAccessType(this.mRegistrationTech), Builder.getAttributeFlags(this.mRegistrationTech), this.mFeatureTags);
        }

        private static int getAttributeFlags(int imsRadioTech) {
            int attributes = 0;
            if (imsRadioTech == 2) {
                attributes |= 1;
            }
            return attributes;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsAttributeFlag {
    }
}

