/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class ImsSsInfo
implements Parcelable {
    public static final int NOT_REGISTERED = -1;
    public static final int DISABLED = 0;
    public static final int ENABLED = 1;
    public static final int SERVICE_PROVISIONING_UNKNOWN = -1;
    public static final int SERVICE_NOT_PROVISIONED = 0;
    public static final int SERVICE_PROVISIONED = 1;
    public static final int CLIR_OUTGOING_DEFAULT = 0;
    public static final int CLIR_OUTGOING_INVOCATION = 1;
    public static final int CLIR_OUTGOING_SUPPRESSION = 2;
    public static final int CLIR_STATUS_NOT_PROVISIONED = 0;
    public static final int CLIR_STATUS_PROVISIONED_PERMANENT = 1;
    public static final int CLIR_STATUS_UNKNOWN = 2;
    public static final int CLIR_STATUS_TEMPORARILY_RESTRICTED = 3;
    public static final int CLIR_STATUS_TEMPORARILY_ALLOWED = 4;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int mStatus;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public String mIcbNum;
    public int mProvisionStatus = -1;
    private int mClirInterrogationStatus = 2;
    private int mClirOutgoingState = 0;
    public static final Parcelable.Creator<ImsSsInfo> CREATOR = new Parcelable.Creator<ImsSsInfo>(){

        @Override
        public ImsSsInfo createFromParcel(Parcel in) {
            return new ImsSsInfo(in);
        }

        public ImsSsInfo[] newArray(int size) {
            return new ImsSsInfo[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public ImsSsInfo() {
    }

    @Deprecated
    public ImsSsInfo(int status, String icbNum) {
        this.mStatus = status;
        this.mIcbNum = icbNum;
    }

    private ImsSsInfo(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mStatus);
        out.writeString(this.mIcbNum);
        out.writeInt(this.mProvisionStatus);
        out.writeInt(this.mClirInterrogationStatus);
        out.writeInt(this.mClirOutgoingState);
    }

    public String toString() {
        return super.toString() + ", Status: " + (this.mStatus == 0 ? "disabled" : "enabled") + ", ProvisionStatus: " + ImsSsInfo.provisionStatusToString(this.mProvisionStatus);
    }

    private static String provisionStatusToString(int pStatus) {
        switch (pStatus) {
            case 0: {
                return "Service not provisioned";
            }
            case 1: {
                return "Service provisioned";
            }
        }
        return "Service provisioning unknown";
    }

    private void readFromParcel(Parcel in) {
        this.mStatus = in.readInt();
        this.mIcbNum = in.readString();
        this.mProvisionStatus = in.readInt();
        this.mClirInterrogationStatus = in.readInt();
        this.mClirOutgoingState = in.readInt();
    }

    public int getStatus() {
        return this.mStatus;
    }

    @Deprecated
    public String getIcbNum() {
        return this.mIcbNum;
    }

    public String getIncomingCommunicationBarringNumber() {
        return this.mIcbNum;
    }

    public int getProvisionStatus() {
        return this.mProvisionStatus;
    }

    public int getClirOutgoingState() {
        return this.mClirOutgoingState;
    }

    public int getClirInterrogationStatus() {
        return this.mClirInterrogationStatus;
    }

    public int[] getCompatArray(int type) {
        int[] result = new int[2];
        if (type == 8) {
            result[0] = this.getClirOutgoingState();
            result[1] = this.getClirInterrogationStatus();
            return result;
        }
        if (type == 10) {
            result[0] = this.getProvisionStatus();
        }
        result[0] = this.getStatus();
        result[1] = this.getProvisionStatus();
        return result;
    }

    public static class Builder {
        private final ImsSsInfo mImsSsInfo = new ImsSsInfo();

        public Builder(int status) {
            this.mImsSsInfo.mStatus = status;
        }

        public Builder setIncomingCommunicationBarringNumber(String number) {
            this.mImsSsInfo.mIcbNum = number;
            return this;
        }

        public Builder setProvisionStatus(int provisionStatus) {
            this.mImsSsInfo.mProvisionStatus = provisionStatus;
            return this;
        }

        public Builder setClirInterrogationStatus(int status) {
            this.mImsSsInfo.mClirInterrogationStatus = status;
            return this;
        }

        public Builder setClirOutgoingState(int state) {
            this.mImsSsInfo.mClirOutgoingState = state;
            return this;
        }

        public ImsSsInfo build() {
            return this.mImsSsInfo;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ClirInterrogationStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ClirOutgoingState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ServiceProvisionStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ServiceStatus {
    }
}

