/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.os.Binder;
import com.android.internal.telephony.IImsStateCallback;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;

public abstract class ImsStateCallback {
    public static final int REASON_UNKNOWN_TEMPORARY_ERROR = 1;
    public static final int REASON_UNKNOWN_PERMANENT_ERROR = 2;
    public static final int REASON_IMS_SERVICE_DISCONNECTED = 3;
    public static final int REASON_NO_IMS_SERVICE_CONFIGURED = 4;
    public static final int REASON_SUBSCRIPTION_INACTIVE = 5;
    public static final int REASON_IMS_SERVICE_NOT_READY = 6;
    private IImsStateCallbackStub mCallback;

    public void init(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("ImsStateCallback Executor must be non-null");
        }
        this.mCallback = new IImsStateCallbackStub(this, executor);
    }

    public abstract void onUnavailable(int var1);

    public abstract void onAvailable();

    public abstract void onError();

    public void binderDied() {
        if (this.mCallback != null) {
            this.mCallback.getExecutor().execute(() -> this.onError());
        }
    }

    public IImsStateCallbackStub getCallbackBinder() {
        return this.mCallback;
    }

    private static class IImsStateCallbackStub
    extends IImsStateCallback.Stub {
        private WeakReference<ImsStateCallback> mImsStateCallbackWeakRef;
        private Executor mExecutor;

        IImsStateCallbackStub(ImsStateCallback imsStateCallback, Executor executor) {
            this.mImsStateCallbackWeakRef = new WeakReference<ImsStateCallback>(imsStateCallback);
            this.mExecutor = executor;
        }

        Executor getExecutor() {
            return this.mExecutor;
        }

        @Override
        public void onAvailable() {
            ImsStateCallback callback2 = (ImsStateCallback)this.mImsStateCallbackWeakRef.get();
            if (callback2 == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> callback2.onAvailable()));
        }

        @Override
        public void onUnavailable(int reason) {
            ImsStateCallback callback2 = (ImsStateCallback)this.mImsStateCallbackWeakRef.get();
            if (callback2 == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> callback2.onUnavailable(reason)));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisconnectedReason {
    }
}

