/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.ims.ImsException;
import android.telephony.ims.RcsClientConfiguration;
import android.telephony.ims.aidl.IFeatureProvisioningCallback;
import android.telephony.ims.aidl.IImsConfigCallback;
import android.telephony.ims.aidl.IRcsConfigCallback;
import com.android.internal.telephony.ITelephony;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

public class ProvisioningManager {
    private static final String TAG = "ProvisioningManager";
    @SystemApi
    public static final String STRING_QUERY_RESULT_ERROR_GENERIC = "STRING_QUERY_RESULT_ERROR_GENERIC";
    @SystemApi
    public static final String STRING_QUERY_RESULT_ERROR_NOT_READY = "STRING_QUERY_RESULT_ERROR_NOT_READY";
    public static final int PROVISIONING_RESULT_UNKNOWN = -1;
    @SystemApi
    public static final int PROVISIONING_VALUE_DISABLED = 0;
    @SystemApi
    public static final int PROVISIONING_VALUE_ENABLED = 1;
    public static final int KEY_AMR_CODEC_MODE_SET_VALUES = 0;
    public static final int KEY_AMR_WB_CODEC_MODE_SET_VALUES = 1;
    public static final int KEY_SIP_SESSION_TIMER_SEC = 2;
    public static final int KEY_MINIMUM_SIP_SESSION_EXPIRATION_TIMER_SEC = 3;
    public static final int KEY_SIP_INVITE_CANCELLATION_TIMER_MS = 4;
    public static final int KEY_TRANSITION_TO_LTE_DELAY_MS = 5;
    public static final int KEY_ENABLE_SILENT_REDIAL = 6;
    public static final int KEY_T1_TIMER_VALUE_MS = 7;
    public static final int KEY_T2_TIMER_VALUE_MS = 8;
    public static final int KEY_TF_TIMER_VALUE_MS = 9;
    public static final int KEY_VOLTE_PROVISIONING_STATUS = 10;
    public static final int KEY_VT_PROVISIONING_STATUS = 11;
    public static final int KEY_REGISTRATION_DOMAIN_NAME = 12;
    public static final int KEY_SMS_FORMAT = 13;
    public static final int SMS_FORMAT_3GPP2 = 0;
    public static final int SMS_FORMAT_3GPP = 1;
    public static final int KEY_SMS_OVER_IP_ENABLED = 14;
    public static final int KEY_RCS_PUBLISH_TIMER_SEC = 15;
    public static final int KEY_RCS_PUBLISH_OFFLINE_AVAILABILITY_TIMER_SEC = 16;
    public static final int KEY_RCS_CAPABILITY_DISCOVERY_ENABLED = 17;
    public static final int KEY_RCS_CAPABILITIES_CACHE_EXPIRATION_SEC = 18;
    public static final int KEY_RCS_AVAILABILITY_CACHE_EXPIRATION_SEC = 19;
    public static final int KEY_RCS_CAPABILITIES_POLL_INTERVAL_SEC = 20;
    public static final int KEY_RCS_PUBLISH_SOURCE_THROTTLE_MS = 21;
    public static final int KEY_RCS_MAX_NUM_ENTRIES_IN_RCL = 22;
    public static final int KEY_RCS_CAPABILITY_POLL_LIST_SUB_EXP_SEC = 23;
    public static final int KEY_USE_GZIP_FOR_LIST_SUBSCRIPTION = 24;
    public static final int KEY_EAB_PROVISIONING_STATUS = 25;
    @SystemApi
    public static final int KEY_VOICE_OVER_WIFI_ROAMING_ENABLED_OVERRIDE = 26;
    @SystemApi
    public static final int KEY_VOICE_OVER_WIFI_MODE_OVERRIDE = 27;
    public static final int KEY_VOICE_OVER_WIFI_ENABLED_OVERRIDE = 28;
    public static final int KEY_MOBILE_DATA_ENABLED = 29;
    public static final int KEY_VOLTE_USER_OPT_IN_STATUS = 30;
    public static final int KEY_LOCAL_BREAKOUT_PCSCF_ADDRESS = 31;
    public static final int KEY_SIP_KEEP_ALIVE_ENABLED = 32;
    public static final int KEY_REGISTRATION_RETRY_BASE_TIME_SEC = 33;
    public static final int KEY_REGISTRATION_RETRY_MAX_TIME_SEC = 34;
    public static final int KEY_RTP_SPEECH_START_PORT = 35;
    public static final int KEY_RTP_SPEECH_END_PORT = 36;
    public static final int KEY_SIP_INVITE_REQUEST_TRANSMIT_INTERVAL_MS = 37;
    public static final int KEY_SIP_INVITE_ACK_WAIT_TIME_MS = 38;
    public static final int KEY_SIP_INVITE_RESPONSE_RETRANSMIT_WAIT_TIME_MS = 39;
    public static final int KEY_SIP_NON_INVITE_REQUEST_RETRANSMIT_INTERVAL_MS = 40;
    public static final int KEY_SIP_NON_INVITE_TRANSACTION_TIMEOUT_TIMER_MS = 41;
    public static final int KEY_SIP_INVITE_RESPONSE_RETRANSMIT_INTERVAL_MS = 42;
    public static final int KEY_SIP_ACK_RECEIPT_WAIT_TIME_MS = 43;
    public static final int KEY_SIP_ACK_RETRANSMIT_WAIT_TIME_MS = 44;
    public static final int KEY_SIP_NON_INVITE_REQUEST_RETRANSMISSION_WAIT_TIME_MS = 45;
    public static final int KEY_SIP_NON_INVITE_RESPONSE_RETRANSMISSION_WAIT_TIME_MS = 46;
    public static final int KEY_AMR_WB_OCTET_ALIGNED_PAYLOAD_TYPE = 47;
    public static final int KEY_AMR_WB_BANDWIDTH_EFFICIENT_PAYLOAD_TYPE = 48;
    public static final int KEY_AMR_OCTET_ALIGNED_PAYLOAD_TYPE = 49;
    public static final int KEY_AMR_BANDWIDTH_EFFICIENT_PAYLOAD_TYPE = 50;
    public static final int KEY_DTMF_WB_PAYLOAD_TYPE = 51;
    public static final int KEY_DTMF_NB_PAYLOAD_TYPE = 52;
    public static final int KEY_AMR_DEFAULT_ENCODING_MODE = 53;
    public static final int KEY_SMS_PUBLIC_SERVICE_IDENTITY = 54;
    public static final int KEY_VIDEO_QUALITY = 55;
    public static final int VIDEO_QUALITY_LOW = 0;
    public static final int VIDEO_QUALITY_HIGH = 1;
    public static final int KEY_LTE_THRESHOLD_1 = 56;
    public static final int KEY_LTE_THRESHOLD_2 = 57;
    public static final int KEY_LTE_THRESHOLD_3 = 58;
    public static final int KEY_1X_THRESHOLD = 59;
    public static final int KEY_WIFI_THRESHOLD_A = 60;
    public static final int KEY_WIFI_THRESHOLD_B = 61;
    public static final int KEY_LTE_EPDG_TIMER_SEC = 62;
    public static final int KEY_WIFI_EPDG_TIMER_SEC = 63;
    public static final int KEY_1X_EPDG_TIMER_SEC = 64;
    public static final int KEY_MULTIENDPOINT_ENABLED = 65;
    public static final int KEY_RTT_ENABLED = 66;
    @SystemApi
    public static final int KEY_VOICE_OVER_WIFI_ENTITLEMENT_ID = 67;
    public static final int KEY_VOIMS_OPT_IN_STATUS = 68;
    private int mSubId;
    @SystemApi
    @RequiresPermission(value="android.permission.PERFORM_IMS_SINGLE_REGISTRATION")
    public static final String ACTION_RCS_SINGLE_REGISTRATION_CAPABILITY_UPDATE = "android.telephony.ims.action.RCS_SINGLE_REGISTRATION_CAPABILITY_UPDATE";
    @SystemApi
    public static final String EXTRA_SUBSCRIPTION_ID = "android.telephony.ims.extra.SUBSCRIPTION_ID";
    @SystemApi
    public static final String EXTRA_STATUS = "android.telephony.ims.extra.STATUS";
    @SystemApi
    public static final int STATUS_CAPABLE = 0;
    @SystemApi
    public static final int STATUS_DEVICE_NOT_CAPABLE = 1;
    @SystemApi
    public static final int STATUS_CARRIER_NOT_CAPABLE = 2;

    @SystemApi
    public static ProvisioningManager createForSubscriptionId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            throw new IllegalArgumentException("Invalid subscription ID");
        }
        return new ProvisioningManager(subId);
    }

    public ProvisioningManager(int subId) {
        this.mSubId = subId;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void registerProvisioningChangedCallback(Executor executor, Callback callback2) throws ImsException {
        callback2.setExecutor(executor);
        try {
            ProvisioningManager.getITelephony().registerImsProvisioningChangedCallback(this.mSubId, callback2.getBinder());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void unregisterProvisioningChangedCallback(Callback callback2) {
        try {
            ProvisioningManager.getITelephony().unregisterImsProvisioningChangedCallback(this.mSubId, callback2.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public void registerFeatureProvisioningChangedCallback(Executor executor, FeatureProvisioningCallback callback2) throws ImsException {
        callback2.setExecutor(executor);
        try {
            ProvisioningManager.getITelephony().registerFeatureProvisioningChangedCallback(this.mSubId, callback2.getBinder());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    public void unregisterFeatureProvisioningChangedCallback(FeatureProvisioningCallback callback2) {
        try {
            ProvisioningManager.getITelephony().unregisterFeatureProvisioningChangedCallback(this.mSubId, callback2.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getProvisioningIntValue(int key) {
        try {
            return ProvisioningManager.getITelephony().getImsProvisioningInt(this.mSubId, key);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getProvisioningStringValue(int key) {
        try {
            return ProvisioningManager.getITelephony().getImsProvisioningString(this.mSubId, key);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public int setProvisioningIntValue(int key, int value2) {
        try {
            return ProvisioningManager.getITelephony().setImsProvisioningInt(this.mSubId, key, value2);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public int setProvisioningStringValue(int key, String value2) {
        try {
            return ProvisioningManager.getITelephony().setImsProvisioningString(this.mSubId, key, value2);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setProvisioningStatusForCapability(int capability, int tech, boolean isProvisioned) {
        try {
            ProvisioningManager.getITelephony().setImsProvisioningStatusForCapability(this.mSubId, capability, tech, isProvisioned);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public boolean getProvisioningStatusForCapability(int capability, int tech) {
        try {
            return ProvisioningManager.getITelephony().getImsProvisioningStatusForCapability(this.mSubId, capability, tech);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean getRcsProvisioningStatusForCapability(int capability) {
        try {
            return ProvisioningManager.getITelephony().getRcsProvisioningStatusForCapability(this.mSubId, capability, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public boolean getRcsProvisioningStatusForCapability(int capability, int tech) {
        try {
            return ProvisioningManager.getITelephony().getRcsProvisioningStatusForCapability(this.mSubId, capability, tech);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setRcsProvisioningStatusForCapability(int capability, boolean isProvisioned) {
        try {
            ProvisioningManager.getITelephony().setRcsProvisioningStatusForCapability(this.mSubId, capability, 0, isProvisioned);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setRcsProvisioningStatusForCapability(int capability, int tech, boolean isProvisioned) {
        try {
            ProvisioningManager.getITelephony().setRcsProvisioningStatusForCapability(this.mSubId, capability, tech, isProvisioned);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public boolean isProvisioningRequiredForCapability(int capability, int tech) {
        try {
            return ProvisioningManager.getITelephony().isProvisioningRequiredForCapability(this.mSubId, capability, tech);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public boolean isRcsProvisioningRequiredForCapability(int capability, int tech) {
        try {
            return ProvisioningManager.getITelephony().isRcsProvisioningRequiredForCapability(this.mSubId, capability, tech);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void notifyRcsAutoConfigurationReceived(byte[] config, boolean isCompressed) {
        if (config == null) {
            throw new IllegalArgumentException("Must include a non-null config XML file.");
        }
        try {
            ProvisioningManager.getITelephony().notifyRcsAutoConfigurationReceived(this.mSubId, config, isCompressed);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.PERFORM_IMS_SINGLE_REGISTRATION")
    public void setRcsClientConfiguration(RcsClientConfiguration rcc) throws ImsException {
        try {
            ProvisioningManager.getITelephony().setRcsClientConfiguration(this.mSubId, rcc);
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.PERFORM_IMS_SINGLE_REGISTRATION"})
    public boolean isRcsVolteSingleRegistrationCapable() throws ImsException {
        try {
            return ProvisioningManager.getITelephony().isRcsVolteSingleRegistrationCapable(this.mSubId);
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.PERFORM_IMS_SINGLE_REGISTRATION"})
    public void registerRcsProvisioningCallback(Executor executor, RcsProvisioningCallback callback2) throws ImsException {
        callback2.setExecutor(executor);
        try {
            ProvisioningManager.getITelephony().registerRcsProvisioningCallback(this.mSubId, callback2.getBinder());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.PERFORM_IMS_SINGLE_REGISTRATION"})
    public void unregisterRcsProvisioningCallback(RcsProvisioningCallback callback2) {
        try {
            ProvisioningManager.getITelephony().unregisterRcsProvisioningCallback(this.mSubId, callback2.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.PERFORM_IMS_SINGLE_REGISTRATION")
    public void triggerRcsReconfiguration() {
        try {
            ProvisioningManager.getITelephony().triggerRcsReconfiguration(this.mSubId);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    private static ITelephony getITelephony() {
        ITelephony binder = ITelephony.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyServiceRegisterer().get());
        if (binder == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        return binder;
    }

    @SystemApi
    public static class RcsProvisioningCallback {
        private final CallbackBinder mBinder = new CallbackBinder(this);

        public void onConfigurationChanged(byte[] configXml) {
        }

        public void onAutoConfigurationErrorReceived(int errorCode, String errorString) {
        }

        public void onConfigurationReset() {
        }

        public void onRemoved() {
        }

        public void onPreProvisioningReceived(byte[] configXml) {
        }

        public IRcsConfigCallback getBinder() {
            return this.mBinder;
        }

        public void setExecutor(Executor executor) {
            this.mBinder.setExecutor(executor);
        }

        private static class CallbackBinder
        extends IRcsConfigCallback.Stub {
            private final RcsProvisioningCallback mLocalCallback;
            private Executor mExecutor;

            private CallbackBinder(RcsProvisioningCallback localCallback) {
                this.mLocalCallback = localCallback;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigurationChanged(byte[] configXml) {
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onConfigurationChanged(configXml));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAutoConfigurationErrorReceived(int errorCode, String errorString) {
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onAutoConfigurationErrorReceived(errorCode, errorString));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }

            @Override
            public void onConfigurationReset() {
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onConfigurationReset());
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }

            @Override
            public void onRemoved() {
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onRemoved());
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPreProvisioningReceived(byte[] configXml) {
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalCallback.onPreProvisioningReceived(configXml));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }

            private void setExecutor(Executor executor) {
                this.mExecutor = executor;
            }
        }
    }

    public static abstract class FeatureProvisioningCallback {
        private final CallbackBinder mBinder = new CallbackBinder(this);

        public abstract void onFeatureProvisioningChanged(int var1, int var2, boolean var3);

        public abstract void onRcsFeatureProvisioningChanged(int var1, int var2, boolean var3);

        public IFeatureProvisioningCallback getBinder() {
            return this.mBinder;
        }

        public void setExecutor(Executor executor) {
            this.mBinder.setExecutor(executor);
        }

        private static class CallbackBinder
        extends IFeatureProvisioningCallback.Stub {
            private final FeatureProvisioningCallback mFeatureProvisioningCallback;
            private Executor mExecutor;

            private CallbackBinder(FeatureProvisioningCallback featureProvisioningCallback) {
                this.mFeatureProvisioningCallback = featureProvisioningCallback;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFeatureProvisioningChanged(int capability, int tech, boolean isProvisioned) {
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mFeatureProvisioningCallback.onFeatureProvisioningChanged(capability, tech, isProvisioned));
                }
                finally {
                    CallbackBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRcsFeatureProvisioningChanged(int capability, int tech, boolean isProvisioned) {
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mFeatureProvisioningCallback.onRcsFeatureProvisioningChanged(capability, tech, isProvisioned));
                }
                finally {
                    CallbackBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            private void setExecutor(Executor executor) {
                this.mExecutor = executor;
            }
        }
    }

    @SystemApi
    public static class Callback {
        private final CallbackBinder mBinder = new CallbackBinder(this);

        public void onProvisioningIntChanged(int item, int value2) {
        }

        public void onProvisioningStringChanged(int item, String value2) {
        }

        public IImsConfigCallback getBinder() {
            return this.mBinder;
        }

        public void setExecutor(Executor executor) {
            this.mBinder.setExecutor(executor);
        }

        private static class CallbackBinder
        extends IImsConfigCallback.Stub {
            private final Callback mLocalConfigurationCallback;
            private Executor mExecutor;

            private CallbackBinder(Callback localConfigurationCallback) {
                this.mLocalConfigurationCallback = localConfigurationCallback;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onIntConfigChanged(int item, int value2) {
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalConfigurationCallback.onProvisioningIntChanged(item, value2));
                }
                finally {
                    CallbackBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStringConfigChanged(int item, String value2) {
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mLocalConfigurationCallback.onProvisioningStringChanged(item, value2));
                }
                finally {
                    CallbackBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            private void setExecutor(Executor executor) {
                this.mExecutor = executor;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StringResultError {
    }
}

