/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SystemApi;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.telephony.ims.RcsContactPresenceTuple;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@SystemApi
public class RcsContactUceCapability
implements Parcelable {
    public static final int CAPABILITY_MECHANISM_PRESENCE = 1;
    public static final int CAPABILITY_MECHANISM_OPTIONS = 2;
    public static final int SOURCE_TYPE_NETWORK = 0;
    public static final int SOURCE_TYPE_CACHED = 1;
    public static final int REQUEST_RESULT_UNKNOWN = 0;
    public static final int REQUEST_RESULT_NOT_ONLINE = 1;
    public static final int REQUEST_RESULT_NOT_FOUND = 2;
    public static final int REQUEST_RESULT_FOUND = 3;
    private final Uri mContactUri;
    private int mSourceType;
    private int mCapabilityMechanism;
    private int mRequestResult;
    private Uri mEntityUri;
    private final Set<String> mFeatureTags = new HashSet<String>();
    private final List<RcsContactPresenceTuple> mPresenceTuples = new ArrayList<RcsContactPresenceTuple>();
    public static final Parcelable.Creator<RcsContactUceCapability> CREATOR = new Parcelable.Creator<RcsContactUceCapability>(){

        @Override
        public RcsContactUceCapability createFromParcel(Parcel in) {
            return new RcsContactUceCapability(in);
        }

        public RcsContactUceCapability[] newArray(int size) {
            return new RcsContactUceCapability[size];
        }
    };

    private RcsContactUceCapability(Uri contactUri, int mechanism, int sourceType) {
        this.mContactUri = contactUri;
        this.mCapabilityMechanism = mechanism;
        this.mSourceType = sourceType;
    }

    private RcsContactUceCapability(Parcel in) {
        this.mContactUri = in.readParcelable(Uri.class.getClassLoader(), Uri.class);
        this.mCapabilityMechanism = in.readInt();
        this.mSourceType = in.readInt();
        this.mRequestResult = in.readInt();
        this.mEntityUri = in.readParcelable(Uri.class.getClassLoader(), Uri.class);
        ArrayList<String> featureTagList = new ArrayList<String>();
        in.readStringList(featureTagList);
        this.mFeatureTags.addAll(featureTagList);
        in.readParcelableList(this.mPresenceTuples, RcsContactPresenceTuple.class.getClassLoader(), RcsContactPresenceTuple.class);
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.mContactUri, flags);
        out.writeInt(this.mCapabilityMechanism);
        out.writeInt(this.mSourceType);
        out.writeInt(this.mRequestResult);
        out.writeParcelable(this.mEntityUri, flags);
        out.writeStringList(new ArrayList<String>(this.mFeatureTags));
        out.writeParcelableList(this.mPresenceTuples, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getCapabilityMechanism() {
        return this.mCapabilityMechanism;
    }

    public Set<String> getFeatureTags() {
        if (this.mCapabilityMechanism != 2) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.mFeatureTags);
    }

    public List<RcsContactPresenceTuple> getCapabilityTuples() {
        if (this.mCapabilityMechanism != 1) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.mPresenceTuples);
    }

    public RcsContactPresenceTuple getCapabilityTuple(String serviceId) {
        if (this.mCapabilityMechanism != 1) {
            return null;
        }
        for (RcsContactPresenceTuple tuple : this.mPresenceTuples) {
            if (tuple.getServiceId() == null || !tuple.getServiceId().equals(serviceId)) continue;
            return tuple;
        }
        return null;
    }

    public int getSourceType() {
        return this.mSourceType;
    }

    public int getRequestResult() {
        return this.mRequestResult;
    }

    public Uri getContactUri() {
        return this.mContactUri;
    }

    public Uri getEntityUri() {
        return this.mEntityUri;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder("RcsContactUceCapability");
        if (this.mCapabilityMechanism == 1) {
            builder2.append("(presence) {");
        } else if (this.mCapabilityMechanism == 2) {
            builder2.append("(options) {");
        } else {
            builder2.append("(?) {");
        }
        if (_Original_Build.IS_ENG) {
            builder2.append("uri=");
            builder2.append(this.mContactUri);
        } else {
            builder2.append("uri (isNull)=");
            builder2.append(this.mContactUri != null ? "XXX" : "null");
        }
        builder2.append(", sourceType=");
        builder2.append(this.mSourceType);
        builder2.append(", requestResult=");
        builder2.append(this.mRequestResult);
        if (_Original_Build.IS_ENG) {
            builder2.append("entity uri=");
            builder2.append(this.mEntityUri != null ? this.mEntityUri : "null");
        } else {
            builder2.append("entity uri (isNull)=");
            builder2.append(this.mEntityUri != null ? "XXX" : "null");
        }
        if (this.mCapabilityMechanism == 1) {
            builder2.append(", presenceTuples={");
            builder2.append(this.mPresenceTuples);
            builder2.append("}");
        } else if (this.mCapabilityMechanism == 2) {
            builder2.append(", featureTags={");
            builder2.append(this.mFeatureTags);
            builder2.append("}");
        }
        return builder2.toString();
    }

    public static class PresenceBuilder {
        private final RcsContactUceCapability mCapabilities;

        public PresenceBuilder(Uri contact, int sourceType, int requestResult) {
            this.mCapabilities = new RcsContactUceCapability(contact, 1, sourceType);
            this.mCapabilities.mRequestResult = requestResult;
        }

        public PresenceBuilder addCapabilityTuple(RcsContactPresenceTuple tuple) {
            this.mCapabilities.mPresenceTuples.add(tuple);
            return this;
        }

        public PresenceBuilder addCapabilityTuples(List<RcsContactPresenceTuple> tuples) {
            this.mCapabilities.mPresenceTuples.addAll(tuples);
            return this;
        }

        public PresenceBuilder setEntityUri(Uri entityUri) {
            this.mCapabilities.mEntityUri = entityUri;
            return this;
        }

        public RcsContactUceCapability build() {
            return this.mCapabilities;
        }
    }

    public static class OptionsBuilder {
        private final RcsContactUceCapability mCapabilities;

        public OptionsBuilder(Uri contact) {
            this.mCapabilities = new RcsContactUceCapability(contact, 2, 0);
        }

        public OptionsBuilder(Uri contact, int sourceType) {
            this.mCapabilities = new RcsContactUceCapability(contact, 2, sourceType);
        }

        public OptionsBuilder setRequestResult(int requestResult) {
            this.mCapabilities.mRequestResult = requestResult;
            return this;
        }

        public OptionsBuilder addFeatureTag(String tag2) {
            this.mCapabilities.mFeatureTags.add(tag2);
            return this;
        }

        public OptionsBuilder addFeatureTags(Set<String> tags) {
            this.mCapabilities.mFeatureTags.addAll(tags);
            return this;
        }

        public RcsContactUceCapability build() {
            return this.mCapabilities;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CapabilityMechanism {
    }
}

