/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class RtpHeaderExtension
implements Parcelable {
    private int mLocalIdentifier;
    private byte[] mExtensionData;
    public static final Parcelable.Creator<RtpHeaderExtension> CREATOR = new Parcelable.Creator<RtpHeaderExtension>(){

        @Override
        public RtpHeaderExtension createFromParcel(Parcel in) {
            return new RtpHeaderExtension(in);
        }

        public RtpHeaderExtension[] newArray(int size) {
            return new RtpHeaderExtension[size];
        }
    };

    public RtpHeaderExtension(int localIdentifier, byte[] extensionData) {
        if (localIdentifier < 1 || localIdentifier > 13) {
            throw new IllegalArgumentException("localIdentifier must be in range 1-14");
        }
        if (extensionData == null) {
            throw new NullPointerException("extensionDa is required.");
        }
        this.mLocalIdentifier = localIdentifier;
        this.mExtensionData = extensionData;
    }

    private RtpHeaderExtension(Parcel in) {
        this.mLocalIdentifier = in.readInt();
        this.mExtensionData = in.createByteArray();
    }

    public int getLocalIdentifier() {
        return this.mLocalIdentifier;
    }

    public byte[] getExtensionData() {
        return this.mExtensionData;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mLocalIdentifier);
        dest.writeByteArray(this.mExtensionData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RtpHeaderExtension that = (RtpHeaderExtension)o;
        return this.mLocalIdentifier == that.mLocalIdentifier && Arrays.equals(this.mExtensionData, that.mExtensionData);
    }

    public int hashCode() {
        int result = Objects.hash(this.mLocalIdentifier);
        result = 31 * result + Arrays.hashCode(this.mExtensionData);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RtpHeaderExtension{mLocalIdentifier=");
        sb.append(this.mLocalIdentifier);
        sb.append(", mData=");
        for (byte b : this.mExtensionData) {
            sb.append(Integer.toBinaryString(b));
            sb.append("b_");
        }
        sb.append("}");
        return sb.toString();
    }
}

