/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.net.InetAddresses;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.telephony.ims.SipDelegateConfiguration;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetSocketAddress;

@Deprecated
@SystemApi
public class SipDelegateImsConfiguration
implements Parcelable {
    public static final String IPTYPE_IPV4 = "IPV4";
    public static final String IPTYPE_IPV6 = "IPV6";
    public static final String SIP_TRANSPORT_UDP = "UDP";
    public static final String SIP_TRANSPORT_TCP = "TCP";
    public static final String KEY_SIP_CONFIG_IS_COMPACT_FORM_ENABLED_BOOL = "sip_config_is_compact_form_enabled_bool";
    public static final String KEY_SIP_CONFIG_IS_KEEPALIVE_ENABLED_BOOL = "sip_config_is_keepalive_enabled_bool";
    public static final String KEY_SIP_CONFIG_MAX_PAYLOAD_SIZE_ON_UDP_INT = "sip_config_udp_max_payload_size_int";
    public static final String KEY_SIP_CONFIG_TRANSPORT_TYPE_STRING = "sip_config_protocol_type_string";
    public static final String KEY_SIP_CONFIG_UE_PUBLIC_USER_ID_STRING = "sip_config_ue_public_user_id_string";
    public static final String KEY_SIP_CONFIG_UE_PRIVATE_USER_ID_STRING = "sip_config_ue_private_user_id_string";
    public static final String KEY_SIP_CONFIG_HOME_DOMAIN_STRING = "sip_config_home_domain_string";
    public static final String KEY_SIP_CONFIG_IMEI_STRING = "sip_config_imei_string";
    public static final String KEY_SIP_CONFIG_IPTYPE_STRING = "sip_config_iptype_string";
    public static final String KEY_SIP_CONFIG_UE_DEFAULT_IPADDRESS_STRING = "sip_config_ue_default_ipaddress_string";
    public static final String KEY_SIP_CONFIG_UE_DEFAULT_PORT_INT = "sip_config_ue_default_port_int";
    public static final String KEY_SIP_CONFIG_SERVER_DEFAULT_IPADDRESS_STRING = "sip_config_server_default_ipaddress_string";
    public static final String KEY_SIP_CONFIG_SERVER_DEFAULT_PORT_INT = "sip_config_server_default_port_int";
    public static final String KEY_SIP_CONFIG_IS_NAT_ENABLED_BOOL = "sip_config_is_nat_enabled_bool";
    public static final String KEY_SIP_CONFIG_UE_PUBLIC_IPADDRESS_WITH_NAT_STRING = "sip_config_ue_public_ipaddress_with_nat_string";
    public static final String KEY_SIP_CONFIG_UE_PUBLIC_PORT_WITH_NAT_INT = "sip_config_ue_public_port_with_nat_int";
    public static final String KEY_SIP_CONFIG_IS_GRUU_ENABLED_BOOL = "sip_config_is_gruu_enabled_bool";
    public static final String KEY_SIP_CONFIG_UE_PUBLIC_GRUU_STRING = "sip_config_ue_public_gruu_string";
    public static final String KEY_SIP_CONFIG_IS_IPSEC_ENABLED_BOOL = "sip_config_is_ipsec_enabled_bool";
    public static final String KEY_SIP_CONFIG_UE_IPSEC_CLIENT_PORT_INT = "sip_config_ue_ipsec_client_port_int";
    public static final String KEY_SIP_CONFIG_UE_IPSEC_SERVER_PORT_INT = "sip_config_ue_ipsec_server_port_int";
    public static final String KEY_SIP_CONFIG_UE_IPSEC_OLD_CLIENT_PORT_INT = "sip_config_ue_ipsec_old_client_port_int";
    public static final String KEY_SIP_CONFIG_SERVER_IPSEC_CLIENT_PORT_INT = "sip_config_server_ipsec_client_port_int";
    public static final String KEY_SIP_CONFIG_SERVER_IPSEC_SERVER_PORT_INT = "sip_config_server_ipsec_server_port_int";
    public static final String KEY_SIP_CONFIG_SERVER_IPSEC_OLD_CLIENT_PORT_INT = "sip_config_server_ipsec_old_client_port_int";
    public static final String KEY_SIP_CONFIG_AUTHENTICATION_HEADER_STRING = "sip_config_auhentication_header_string";
    public static final String KEY_SIP_CONFIG_AUTHENTICATION_NONCE_STRING = "sip_config_authentication_nonce_string";
    public static final String KEY_SIP_CONFIG_SERVICE_ROUTE_HEADER_STRING = "sip_config_service_route_header_string";
    public static final String KEY_SIP_CONFIG_SECURITY_VERIFY_HEADER_STRING = "sip_config_security_verify_header_string";
    public static final String KEY_SIP_CONFIG_PATH_HEADER_STRING = "sip_config_path_header_string";
    public static final String KEY_SIP_CONFIG_USER_AGENT_HEADER_STRING = "sip_config_sip_user_agent_header_string";
    public static final String KEY_SIP_CONFIG_URI_USER_PART_STRING = "sip_config_uri_user_part_string";
    public static final String KEY_SIP_CONFIG_P_ACCESS_NETWORK_INFO_HEADER_STRING = "sip_config_p_access_network_info_header_string";
    public static final String KEY_SIP_CONFIG_P_LAST_ACCESS_NETWORK_INFO_HEADER_STRING = "sip_config_p_last_access_network_info_header_string";
    public static final String KEY_SIP_CONFIG_CELLULAR_NETWORK_INFO_HEADER_STRING = "sip_config_cellular_network_info_header_string";
    public static final String KEY_SIP_CONFIG_P_ASSOCIATED_URI_HEADER_STRING = "sip_config_p_associated_uri_header_string";
    private final long mVersion;
    private final PersistableBundle mBundle;
    public static final Parcelable.Creator<SipDelegateImsConfiguration> CREATOR = new Parcelable.Creator<SipDelegateImsConfiguration>(){

        @Override
        public SipDelegateImsConfiguration createFromParcel(Parcel source) {
            return new SipDelegateImsConfiguration(source);
        }

        public SipDelegateImsConfiguration[] newArray(int size) {
            return new SipDelegateImsConfiguration[size];
        }
    };

    private SipDelegateImsConfiguration(long version, PersistableBundle bundle) {
        this.mVersion = version;
        this.mBundle = bundle;
    }

    private SipDelegateImsConfiguration(Parcel source) {
        this.mVersion = source.readLong();
        this.mBundle = source.readPersistableBundle();
    }

    public boolean containsKey(String key) {
        return this.mBundle.containsKey(key);
    }

    public String getString(String key) {
        return this.mBundle.getString(key);
    }

    public int getInt(String key, int defaultValue) {
        if (!this.mBundle.containsKey(key)) {
            return defaultValue;
        }
        return this.mBundle.getInt(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (!this.mBundle.containsKey(key)) {
            return defaultValue;
        }
        return this.mBundle.getBoolean(key);
    }

    public PersistableBundle copyBundle() {
        return new PersistableBundle(this.mBundle);
    }

    public long getVersion() {
        return this.mVersion;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mVersion);
        dest.writePersistableBundle(this.mBundle);
    }

    public SipDelegateConfiguration toNewConfig() {
        String transportTypeString = this.getString(KEY_SIP_CONFIG_TRANSPORT_TYPE_STRING);
        int transportType = transportTypeString != null && transportTypeString.equals(SIP_TRANSPORT_UDP) ? 0 : 1;
        SipDelegateConfiguration.Builder builder2 = new SipDelegateConfiguration.Builder(this.mVersion, transportType, this.getSocketAddr(this.getString(KEY_SIP_CONFIG_UE_DEFAULT_IPADDRESS_STRING), this.getInt(KEY_SIP_CONFIG_UE_DEFAULT_PORT_INT, -1)), this.getSocketAddr(this.getString(KEY_SIP_CONFIG_SERVER_DEFAULT_IPADDRESS_STRING), this.getInt(KEY_SIP_CONFIG_SERVER_DEFAULT_PORT_INT, -1)));
        builder2.setSipCompactFormEnabled(this.getBoolean(KEY_SIP_CONFIG_IS_COMPACT_FORM_ENABLED_BOOL, false));
        builder2.setSipKeepaliveEnabled(this.getBoolean(KEY_SIP_CONFIG_IS_KEEPALIVE_ENABLED_BOOL, false));
        builder2.setMaxUdpPayloadSizeBytes(this.getInt(KEY_SIP_CONFIG_MAX_PAYLOAD_SIZE_ON_UDP_INT, -1));
        builder2.setPublicUserIdentifier(this.getString(KEY_SIP_CONFIG_UE_PUBLIC_USER_ID_STRING));
        builder2.setPrivateUserIdentifier(this.getString(KEY_SIP_CONFIG_UE_PRIVATE_USER_ID_STRING));
        builder2.setHomeDomain(this.getString(KEY_SIP_CONFIG_HOME_DOMAIN_STRING));
        builder2.setImei(this.getString(KEY_SIP_CONFIG_IMEI_STRING));
        builder2.setSipAuthenticationHeader(this.getString(KEY_SIP_CONFIG_AUTHENTICATION_HEADER_STRING));
        builder2.setSipAuthenticationNonce(this.getString(KEY_SIP_CONFIG_AUTHENTICATION_NONCE_STRING));
        builder2.setSipServiceRouteHeader(this.getString(KEY_SIP_CONFIG_SERVICE_ROUTE_HEADER_STRING));
        builder2.setSipPathHeader(this.getString(KEY_SIP_CONFIG_PATH_HEADER_STRING));
        builder2.setSipUserAgentHeader(this.getString(KEY_SIP_CONFIG_USER_AGENT_HEADER_STRING));
        builder2.setSipContactUserParameter(this.getString(KEY_SIP_CONFIG_URI_USER_PART_STRING));
        builder2.setSipPaniHeader(this.getString(KEY_SIP_CONFIG_P_ACCESS_NETWORK_INFO_HEADER_STRING));
        builder2.setSipPlaniHeader(this.getString(KEY_SIP_CONFIG_P_LAST_ACCESS_NETWORK_INFO_HEADER_STRING));
        builder2.setSipCniHeader(this.getString(KEY_SIP_CONFIG_CELLULAR_NETWORK_INFO_HEADER_STRING));
        builder2.setSipAssociatedUriHeader(this.getString(KEY_SIP_CONFIG_P_ASSOCIATED_URI_HEADER_STRING));
        if (this.getBoolean(KEY_SIP_CONFIG_IS_GRUU_ENABLED_BOOL, false)) {
            String uri = this.getString(KEY_SIP_CONFIG_UE_PUBLIC_GRUU_STRING);
            Uri gruuUri = null;
            if (!TextUtils.isEmpty(uri)) {
                gruuUri = Uri.parse(uri);
            }
            builder2.setPublicGruuUri(gruuUri);
        }
        if (this.getBoolean(KEY_SIP_CONFIG_IS_IPSEC_ENABLED_BOOL, false)) {
            builder2.setIpSecConfiguration(new SipDelegateConfiguration.IpSecConfiguration(this.getInt(KEY_SIP_CONFIG_UE_IPSEC_CLIENT_PORT_INT, -1), this.getInt(KEY_SIP_CONFIG_UE_IPSEC_SERVER_PORT_INT, -1), this.getInt(KEY_SIP_CONFIG_UE_IPSEC_OLD_CLIENT_PORT_INT, -1), this.getInt(KEY_SIP_CONFIG_SERVER_IPSEC_CLIENT_PORT_INT, -1), this.getInt(KEY_SIP_CONFIG_SERVER_IPSEC_SERVER_PORT_INT, -1), this.getInt(KEY_SIP_CONFIG_SERVER_IPSEC_OLD_CLIENT_PORT_INT, -1), this.getString(KEY_SIP_CONFIG_SECURITY_VERIFY_HEADER_STRING)));
        }
        if (this.getBoolean(KEY_SIP_CONFIG_IS_NAT_ENABLED_BOOL, false)) {
            builder2.setNatSocketAddress(this.getSocketAddr(this.getString(KEY_SIP_CONFIG_UE_PUBLIC_IPADDRESS_WITH_NAT_STRING), this.getInt(KEY_SIP_CONFIG_UE_PUBLIC_PORT_WITH_NAT_INT, -1)));
        }
        return builder2.build();
    }

    private InetSocketAddress getSocketAddr(String ipAddr, int port) {
        return new InetSocketAddress(InetAddresses.parseNumericAddress(ipAddr), port);
    }

    public static class Builder {
        private final long mVersion;
        private final PersistableBundle mBundle;

        public Builder(int version) {
            this.mVersion = version;
            this.mBundle = new PersistableBundle();
        }

        public Builder(SipDelegateImsConfiguration config) {
            this.mVersion = config.getVersion() + 1L;
            this.mBundle = config.copyBundle();
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addString(String key, String value2) {
            this.mBundle.putString(key, value2);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addInt(String key, int value2) {
            this.mBundle.putInt(key, value2);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addBoolean(String key, boolean value2) {
            this.mBundle.putBoolean(key, value2);
            return this;
        }

        public SipDelegateImsConfiguration build() {
            return new SipDelegateImsConfiguration(this.mVersion, this.mBundle);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BooleanConfigKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IntConfigKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StringConfigKey {
    }
}

