/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.os.Binder;
import android.os.RemoteException;
import android.telephony.ims.DelegateMessageCallback;
import android.telephony.ims.DelegateRegistrationState;
import android.telephony.ims.DelegateStateCallback;
import android.telephony.ims.FeatureTagState;
import android.telephony.ims.SipDelegateConfiguration;
import android.telephony.ims.SipDelegateImsConfiguration;
import android.telephony.ims.SipMessage;
import android.telephony.ims.aidl.ISipDelegate;
import android.telephony.ims.aidl.ISipDelegateMessageCallback;
import android.telephony.ims.aidl.ISipDelegateStateCallback;
import android.telephony.ims.stub.SipDelegate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executor;

public class SipDelegateAidlWrapper
implements DelegateStateCallback,
DelegateMessageCallback {
    private static final String LOG_TAG = "SipDelegateAW";
    private final ISipDelegate.Stub mDelegateBinder = new ISipDelegate.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendMessage(SipMessage sipMessage, long configVersion) {
            SipDelegate d = SipDelegateAidlWrapper.this.mDelegate;
            if (d == null) {
                return;
            }
            long token = Binder.clearCallingIdentity();
            try {
                SipDelegateAidlWrapper.this.mExecutor.execute(() -> d.sendMessage(sipMessage, configVersion));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyMessageReceived(String viaTransactionId) {
            SipDelegate d = SipDelegateAidlWrapper.this.mDelegate;
            if (d == null) {
                return;
            }
            long token = Binder.clearCallingIdentity();
            try {
                SipDelegateAidlWrapper.this.mExecutor.execute(() -> d.notifyMessageReceived(viaTransactionId));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyMessageReceiveError(String viaTransactionId, int reason) {
            SipDelegate d = SipDelegateAidlWrapper.this.mDelegate;
            if (d == null) {
                return;
            }
            long token = Binder.clearCallingIdentity();
            try {
                SipDelegateAidlWrapper.this.mExecutor.execute(() -> d.notifyMessageReceiveError(viaTransactionId, reason));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleanupSession(String callId) {
            SipDelegate d = SipDelegateAidlWrapper.this.mDelegate;
            if (d == null) {
                return;
            }
            long token = Binder.clearCallingIdentity();
            try {
                SipDelegateAidlWrapper.this.mExecutor.execute(() -> d.cleanupSession(callId));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    };
    private final ISipDelegateMessageCallback mMessageBinder;
    private final ISipDelegateStateCallback mStateBinder;
    private final Executor mExecutor;
    private volatile SipDelegate mDelegate;

    public SipDelegateAidlWrapper(Executor executor, ISipDelegateStateCallback stateBinder, ISipDelegateMessageCallback messageBinder) {
        this.mExecutor = executor;
        this.mStateBinder = stateBinder;
        this.mMessageBinder = messageBinder;
    }

    @Override
    public void onMessageReceived(SipMessage message) {
        block2: {
            try {
                this.mMessageBinder.onMessageReceived(message);
            }
            catch (RemoteException e) {
                SipDelegate d = this.mDelegate;
                if (d == null) break block2;
                this.notifyLocalMessageFailedToBeReceived(message, 1);
            }
        }
    }

    @Override
    public void onMessageSent(String viaTransactionId) {
        try {
            this.mMessageBinder.onMessageSent(viaTransactionId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onMessageSendFailure(String viaTransactionId, int reason) {
        try {
            this.mMessageBinder.onMessageSendFailure(viaTransactionId, reason);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onCreated(SipDelegate delegate, Set<FeatureTagState> deniedTags) {
        this.mDelegate = delegate;
        deniedTags = deniedTags == null ? Collections.emptySet() : deniedTags;
        try {
            this.mStateBinder.onCreated(this.mDelegateBinder, new ArrayList<FeatureTagState>(deniedTags));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onFeatureTagRegistrationChanged(DelegateRegistrationState registrationState) {
        try {
            this.mStateBinder.onFeatureTagRegistrationChanged(registrationState);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onImsConfigurationChanged(SipDelegateImsConfiguration config) {
        try {
            this.mStateBinder.onImsConfigurationChanged(config);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onConfigurationChanged(SipDelegateConfiguration config) {
        try {
            this.mStateBinder.onConfigurationChanged(config);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void onDestroyed(int reasonCode) {
        this.mDelegate = null;
        try {
            this.mStateBinder.onDestroyed(reasonCode);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public SipDelegate getDelegate() {
        return this.mDelegate;
    }

    public ISipDelegate getDelegateBinder() {
        return this.mDelegateBinder;
    }

    public ISipDelegateStateCallback getStateCallbackBinder() {
        return this.mStateBinder;
    }

    private void notifyLocalMessageFailedToBeReceived(SipMessage m, int reason) {
        String transactionId = m.getViaBranchParameter();
        SipDelegate d = this.mDelegate;
        if (d != null) {
            this.mExecutor.execute(() -> d.notifyMessageReceiveError(transactionId, reason));
        }
    }
}

