/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.feature;

import android.annotation.SystemApi;
import android.content.Context;
import android.os.IInterface;
import android.os.RemoteException;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.feature.CapabilityChangeRequest;
import android.util.Log;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.util.RemoteCallbackListExt;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;

@SystemApi
public abstract class ImsFeature {
    private static final String LOG_TAG = "ImsFeature";
    public static final int FEATURE_INVALID = -1;
    @SystemApi
    public static final int FEATURE_EMERGENCY_MMTEL = 0;
    @SystemApi
    public static final int FEATURE_MMTEL = 1;
    @SystemApi
    public static final int FEATURE_RCS = 2;
    public static final int FEATURE_MAX = 3;
    public static final Map<Integer, String> FEATURE_LOG_MAP = new HashMap<Integer, String>(){
        {
            this.put(0, "EMERGENCY_MMTEL");
            this.put(1, "MMTEL");
            this.put(2, "RCS");
        }
    };
    @SystemApi
    public static final int STATE_UNAVAILABLE = 0;
    @SystemApi
    public static final int STATE_INITIALIZING = 1;
    @SystemApi
    public static final int STATE_READY = 2;
    public static final Map<Integer, String> STATE_LOG_MAP = new HashMap<Integer, String>(){
        {
            this.put(0, "UNAVAILABLE");
            this.put(1, "INITIALIZING");
            this.put(2, "READY");
        }
    };
    @SystemApi
    public static final int CAPABILITY_ERROR_GENERIC = -1;
    @SystemApi
    public static final int CAPABILITY_SUCCESS = 0;
    protected Context mContext;
    protected final Object mLock = new Object();
    private final RemoteCallbackListExt<IImsFeatureStatusCallback> mStatusCallbacks = new RemoteCallbackListExt();
    private int mState = 0;
    private int mSlotId = -1;
    private final RemoteCallbackListExt<IImsCapabilityCallback> mCapabilityCallbacks = new RemoteCallbackListExt();
    private Capabilities mCapabilityStatus = new Capabilities();

    public void initialize(Context context, int slotId) {
        this.mContext = context;
        this.mSlotId = slotId;
    }

    @SystemApi
    public int getSlotIndex() {
        return this.mSlotId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public int getFeatureState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void setFeatureState(int state) {
        boolean isNotify = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState != state) {
                this.mState = state;
                isNotify = true;
            }
        }
        if (isNotify) {
            this.notifyFeatureState(state);
        }
    }

    @VisibleForTesting
    public void addImsFeatureStatusCallback(IImsFeatureStatusCallback c) {
        try {
            c.notifyImsFeatureStatus(this.getFeatureState());
            this.mStatusCallbacks.register(c);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Couldn't notify feature state: " + e.getMessage());
        }
    }

    @VisibleForTesting
    public void removeImsFeatureStatusCallback(IImsFeatureStatusCallback c) {
        this.mStatusCallbacks.unregister(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFeatureState(int state) {
        RemoteCallbackListExt<IImsFeatureStatusCallback> remoteCallbackListExt = this.mStatusCallbacks;
        synchronized (remoteCallbackListExt) {
            this.mStatusCallbacks.broadcastAction(c -> {
                try {
                    c.notifyImsFeatureStatus(state);
                }
                catch (RemoteException e) {
                    Log.w(LOG_TAG, e + " notifyFeatureState() - Skipping callback.");
                }
            });
        }
    }

    public void addCapabilityCallback(IImsCapabilityCallback c) {
        this.mCapabilityCallbacks.register(c);
        try {
            c.onCapabilitiesStatusChanged(this.queryCapabilityStatus().mCapabilities);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "addCapabilityCallback: error accessing callback: " + e.getMessage());
        }
    }

    void removeCapabilityCallback(IImsCapabilityCallback c) {
        this.mCapabilityCallbacks.unregister(c);
    }

    void queryCapabilityConfigurationInternal(int capability, int radioTech, IImsCapabilityCallback c) {
        boolean enabled = this.queryCapabilityConfiguration(capability, radioTech);
        try {
            if (c != null) {
                c.onQueryCapabilityConfiguration(capability, radioTech, enabled);
            }
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "queryCapabilityConfigurationInternal called on dead binder!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public Capabilities queryCapabilityStatus() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCapabilityStatus.copy();
        }
    }

    @VisibleForTesting
    public void requestChangeEnabledCapabilities(CapabilityChangeRequest request, IImsCapabilityCallback c) {
        if (request == null) {
            throw new IllegalArgumentException("ImsFeature#requestChangeEnabledCapabilities called with invalid params.");
        }
        this.changeEnabledCapabilities(request, new CapabilityCallbackProxy(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCapabilitiesStatusChanged(Capabilities caps) {
        RemoteCallbackListExt<IImsCapabilityCallback> remoteCallbackListExt = this.mLock;
        synchronized (remoteCallbackListExt) {
            this.mCapabilityStatus = caps.copy();
        }
        remoteCallbackListExt = this.mCapabilityCallbacks;
        synchronized (remoteCallbackListExt) {
            this.mCapabilityCallbacks.broadcastAction(callback2 -> {
                try {
                    Log.d(LOG_TAG, "ImsFeature notifyCapabilitiesStatusChanged Capabilities = " + caps.mCapabilities);
                    callback2.onCapabilitiesStatusChanged(caps.mCapabilities);
                }
                catch (RemoteException e) {
                    Log.w(LOG_TAG, e + " notifyCapabilitiesStatusChanged() - Skipping callback.");
                }
            });
        }
    }

    public abstract boolean queryCapabilityConfiguration(int var1, int var2);

    public abstract void changeEnabledCapabilities(CapabilityChangeRequest var1, CapabilityCallbackProxy var2);

    public abstract void onFeatureRemoved();

    public abstract void onFeatureReady();

    protected abstract IInterface getBinder();

    @Deprecated
    @SystemApi
    public static class Capabilities {
        protected int mCapabilities = 0;

        public Capabilities() {
        }

        protected Capabilities(int capabilities) {
            this.mCapabilities = capabilities;
        }

        public void addCapabilities(int capabilities) {
            this.mCapabilities |= capabilities;
        }

        public void removeCapabilities(int capabilities) {
            this.mCapabilities &= ~capabilities;
        }

        public boolean isCapable(int capabilities) {
            return (this.mCapabilities & capabilities) == capabilities;
        }

        public Capabilities copy() {
            return new Capabilities(this.mCapabilities);
        }

        public int getMask() {
            return this.mCapabilities;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Capabilities)) {
                return false;
            }
            Capabilities that = (Capabilities)o;
            return this.mCapabilities == that.mCapabilities;
        }

        public int hashCode() {
            return this.mCapabilities;
        }

        public String toString() {
            return "Capabilities: " + Integer.toBinaryString(this.mCapabilities);
        }
    }

    protected static class CapabilityCallbackProxy {
        private final IImsCapabilityCallback mCallback;

        public CapabilityCallbackProxy(IImsCapabilityCallback c) {
            this.mCallback = c;
        }

        public void onChangeCapabilityConfigurationError(int capability, int radioTech, int reason) {
            if (this.mCallback == null) {
                return;
            }
            try {
                this.mCallback.onChangeCapabilityConfigurationError(capability, radioTech, reason);
            }
            catch (RemoteException e) {
                Log.e(ImsFeature.LOG_TAG, "onChangeCapabilityConfigurationError called on dead binder.");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsCapabilityError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeatureType {
    }
}

