/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.feature;

import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.RtpHeaderExtensionType;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsMmTelListener;
import android.telephony.ims.aidl.IImsSmsListener;
import android.telephony.ims.feature.CapabilityChangeRequest;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.stub.ImsCallSessionImplBase;
import android.telephony.ims.stub.ImsEcbmImplBase;
import android.telephony.ims.stub.ImsMultiEndpointImplBase;
import android.telephony.ims.stub.ImsSmsImplBase;
import android.telephony.ims.stub.ImsUtImplBase;
import android.util.ArraySet;
import android.util.Log;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsUt;
import com.android.internal.telephony.util.TelephonyUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class MmTelFeature
extends ImsFeature {
    private static final String LOG_TAG = "MmTelFeature";
    private Executor mExecutor;
    private final IImsMmTelFeature mImsMMTelBinder = new IImsMmTelFeature.Stub(){

        @Override
        public void setListener(IImsMmTelListener l) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.setListener(l), "setListener");
        }

        @Override
        public int getFeatureState() throws RemoteException {
            return this.executeMethodAsyncForResult(() -> MmTelFeature.this.getFeatureState(), "getFeatureState");
        }

        @Override
        public ImsCallProfile createCallProfile(int callSessionType, int callType) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> MmTelFeature.this.createCallProfile(callSessionType, callType), "createCallProfile");
        }

        @Override
        public void changeOfferedRtpHeaderExtensionTypes(List<RtpHeaderExtensionType> types) throws RemoteException {
            this.executeMethodAsync(() -> MmTelFeature.this.changeOfferedRtpHeaderExtensionTypes(new ArraySet<RtpHeaderExtensionType>(types)), "changeOfferedRtpHeaderExtensionTypes");
        }

        @Override
        public IImsCallSession createCallSession(ImsCallProfile profile) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            IImsCallSession result = this.executeMethodAsyncForResult(() -> {
                try {
                    return MmTelFeature.this.createCallSessionInterface(profile);
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                    return null;
                }
            }, "createCallSession");
            if (exceptionRef.get() != null) {
                throw (RemoteException)exceptionRef.get();
            }
            return result;
        }

        @Override
        public int shouldProcessCall(String[] numbers) {
            Integer result = this.executeMethodAsyncForResultNoException(() -> MmTelFeature.this.shouldProcessCall(numbers), "shouldProcessCall");
            if (result != null) {
                return result;
            }
            return 1;
        }

        @Override
        public IImsUt getUtInterface() throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            IImsUt result = this.executeMethodAsyncForResult(() -> {
                try {
                    return MmTelFeature.this.getUtInterface();
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                    return null;
                }
            }, "getUtInterface");
            if (exceptionRef.get() != null) {
                throw (RemoteException)exceptionRef.get();
            }
            return result;
        }

        @Override
        public IImsEcbm getEcbmInterface() throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            IImsEcbm result = this.executeMethodAsyncForResult(() -> {
                try {
                    return MmTelFeature.this.getEcbmInterface();
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                    return null;
                }
            }, "getEcbmInterface");
            if (exceptionRef.get() != null) {
                throw (RemoteException)exceptionRef.get();
            }
            return result;
        }

        @Override
        public void setUiTtyMode(int uiTtyMode, Message onCompleteMessage) throws RemoteException {
            this.executeMethodAsync(() -> MmTelFeature.this.setUiTtyMode(uiTtyMode, onCompleteMessage), "setUiTtyMode");
        }

        @Override
        public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            IImsMultiEndpoint result = this.executeMethodAsyncForResult(() -> {
                try {
                    return MmTelFeature.this.getMultiEndpointInterface();
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                    return null;
                }
            }, "getMultiEndpointInterface");
            if (exceptionRef.get() != null) {
                throw (RemoteException)exceptionRef.get();
            }
            return result;
        }

        @Override
        public int queryCapabilityStatus() {
            Integer result = this.executeMethodAsyncForResultNoException(() -> MmTelFeature.this.queryCapabilityStatus().mCapabilities, "queryCapabilityStatus");
            if (result != null) {
                return result;
            }
            return 0;
        }

        @Override
        public void addCapabilityCallback(IImsCapabilityCallback c) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.addCapabilityCallback(c), "addCapabilityCallback");
        }

        @Override
        public void removeCapabilityCallback(IImsCapabilityCallback c) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.removeCapabilityCallback(c), "removeCapabilityCallback");
        }

        @Override
        public void changeCapabilitiesConfiguration(CapabilityChangeRequest request, IImsCapabilityCallback c) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.requestChangeEnabledCapabilities(request, c), "changeCapabilitiesConfiguration");
        }

        @Override
        public void queryCapabilityConfiguration(int capability, int radioTech, IImsCapabilityCallback c) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.queryCapabilityConfigurationInternal(capability, radioTech, c), "queryCapabilityConfiguration");
        }

        @Override
        public void setSmsListener(IImsSmsListener l) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.setSmsListener(l), "setSmsListener");
        }

        @Override
        public void sendSms(int token, int messageRef, String format, String smsc, boolean retry, byte[] pdu) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.sendSms(token, messageRef, format, smsc, retry, pdu), "sendSms");
        }

        @Override
        public void acknowledgeSms(int token, int messageRef, int result) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.acknowledgeSms(token, messageRef, result), "acknowledgeSms");
        }

        @Override
        public void acknowledgeSmsReport(int token, int messageRef, int result) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.acknowledgeSmsReport(token, messageRef, result), "acknowledgeSmsReport");
        }

        @Override
        public String getSmsFormat() {
            return this.executeMethodAsyncForResultNoException(() -> MmTelFeature.this.getSmsFormat(), "getSmsFormat");
        }

        @Override
        public void onSmsReady() {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.onSmsReady(), "onSmsReady");
        }

        private void executeMethodAsync(Runnable r, String errorLogName) throws RemoteException {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), MmTelFeature.this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(MmTelFeature.LOG_TAG, "MmTelFeature Binder - " + errorLogName + " exception: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }

        private void executeMethodAsyncNoException(Runnable r, String errorLogName) {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), MmTelFeature.this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(MmTelFeature.LOG_TAG, "MmTelFeature Binder - " + errorLogName + " exception: " + e.getMessage());
            }
        }

        private <T> T executeMethodAsyncForResult(Supplier<T> r, String errorLogName) throws RemoteException {
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), MmTelFeature.this.mExecutor);
            try {
                return (T)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.w(MmTelFeature.LOG_TAG, "MmTelFeature Binder - " + errorLogName + " exception: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }

        private <T> T executeMethodAsyncForResultNoException(Supplier<T> r, String errorLogName) {
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), MmTelFeature.this.mExecutor);
            try {
                return (T)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.w(MmTelFeature.LOG_TAG, "MmTelFeature Binder - " + errorLogName + " exception: " + e.getMessage());
                return null;
            }
        }
    };
    @SystemApi
    public static final int PROCESS_CALL_IMS = 0;
    @SystemApi
    public static final int PROCESS_CALL_CSFB = 1;
    @SystemApi
    public static final String EXTRA_IS_USSD = "android.telephony.ims.feature.extra.IS_USSD";
    @SystemApi
    public static final String EXTRA_IS_UNKNOWN_CALL = "android.telephony.ims.feature.extra.IS_UNKNOWN_CALL";
    private IImsMmTelListener mListener;

    @SystemApi
    public MmTelFeature() {
    }

    @SystemApi
    public MmTelFeature(Executor executor) {
        this.mExecutor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setListener(IImsMmTelListener listener2) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = listener2;
            if (this.mListener != null) {
                this.onFeatureReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImsMmTelListener getListener() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mListener;
        }
    }

    @Override
    @SystemApi
    public MmTelCapabilities queryCapabilityStatus() {
        return new MmTelCapabilities(super.queryCapabilityStatus());
    }

    @SystemApi
    public void notifyCapabilitiesStatusChanged(MmTelCapabilities c) {
        if (c == null) {
            throw new IllegalArgumentException("MmTelCapabilities must be non-null!");
        }
        super.notifyCapabilitiesStatusChanged(c);
    }

    @SystemApi
    public void notifyIncomingCall(ImsCallSessionImplBase c, Bundle extras) {
        if (c == null || extras == null) {
            throw new IllegalArgumentException("ImsCallSessionImplBase and Bundle can not be null.");
        }
        IImsMmTelListener listener2 = this.getListener();
        if (listener2 == null) {
            throw new IllegalStateException("Session is not available.");
        }
        try {
            listener2.onIncomingCall(c.getServiceImpl(), extras);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @SystemApi
    public void notifyRejectedCall(ImsCallProfile callProfile, ImsReasonInfo reason) {
        if (callProfile == null || reason == null) {
            throw new IllegalArgumentException("ImsCallProfile and ImsReasonInfo must not be null.");
        }
        IImsMmTelListener listener2 = this.getListener();
        if (listener2 == null) {
            throw new IllegalStateException("Session is not available.");
        }
        try {
            listener2.onRejectedCall(callProfile, reason);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void notifyIncomingCallSession(IImsCallSession c, Bundle extras) {
        IImsMmTelListener listener2 = this.getListener();
        if (listener2 == null) {
            throw new IllegalStateException("Session is not available.");
        }
        try {
            listener2.onIncomingCall(c, extras);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @SystemApi
    public void notifyVoiceMessageCountUpdate(int count) {
        IImsMmTelListener listener2 = this.getListener();
        if (listener2 == null) {
            throw new IllegalStateException("Session is not available.");
        }
        try {
            listener2.onVoiceMessageCountUpdate(count);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @SystemApi
    public boolean queryCapabilityConfiguration(int capability, int radioTech) {
        return false;
    }

    @Override
    @SystemApi
    public void changeEnabledCapabilities(CapabilityChangeRequest request, ImsFeature.CapabilityCallbackProxy c) {
    }

    @SystemApi
    public ImsCallProfile createCallProfile(int callSessionType, int callType) {
        return null;
    }

    @SystemApi
    public void changeOfferedRtpHeaderExtensionTypes(Set<RtpHeaderExtensionType> extensionTypes) {
    }

    public IImsCallSession createCallSessionInterface(ImsCallProfile profile) throws RemoteException {
        ImsCallSessionImplBase s = this.createCallSession(profile);
        if (s != null) {
            s.setDefaultExecutor(this.mExecutor);
            return s.getServiceImpl();
        }
        return null;
    }

    @SystemApi
    public ImsCallSessionImplBase createCallSession(ImsCallProfile profile) {
        return null;
    }

    @SystemApi
    public int shouldProcessCall(String[] numbers) {
        return 0;
    }

    protected IImsUt getUtInterface() throws RemoteException {
        ImsUtImplBase utImpl = this.getUt();
        if (utImpl != null) {
            utImpl.setDefaultExecutor(this.mExecutor);
            return utImpl.getInterface();
        }
        return null;
    }

    protected IImsEcbm getEcbmInterface() throws RemoteException {
        ImsEcbmImplBase ecbmImpl = this.getEcbm();
        if (ecbmImpl != null) {
            ecbmImpl.setDefaultExecutor(this.mExecutor);
            return ecbmImpl.getImsEcbm();
        }
        return null;
    }

    public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
        ImsMultiEndpointImplBase multiendpointImpl = this.getMultiEndpoint();
        if (multiendpointImpl != null) {
            multiendpointImpl.setDefaultExecutor(this.mExecutor);
            return multiendpointImpl.getIImsMultiEndpoint();
        }
        return null;
    }

    @SystemApi
    public ImsUtImplBase getUt() {
        return new ImsUtImplBase();
    }

    @SystemApi
    public ImsEcbmImplBase getEcbm() {
        return new ImsEcbmImplBase();
    }

    @SystemApi
    public ImsMultiEndpointImplBase getMultiEndpoint() {
        return new ImsMultiEndpointImplBase();
    }

    @SystemApi
    public void setUiTtyMode(int mode, Message onCompleteMessage) {
    }

    private void setSmsListener(IImsSmsListener listener2) {
        this.getSmsImplementation().registerSmsListener(listener2);
    }

    private void sendSms(int token, int messageRef, String format, String smsc, boolean isRetry, byte[] pdu) {
        this.getSmsImplementation().sendSms(token, messageRef, format, smsc, isRetry, pdu);
    }

    private void acknowledgeSms(int token, int messageRef, int result) {
        this.getSmsImplementation().acknowledgeSms(token, messageRef, result);
    }

    private void acknowledgeSmsReport(int token, int messageRef, int result) {
        this.getSmsImplementation().acknowledgeSmsReport(token, messageRef, result);
    }

    private void onSmsReady() {
        this.getSmsImplementation().onReady();
    }

    @SystemApi
    public ImsSmsImplBase getSmsImplementation() {
        return new ImsSmsImplBase();
    }

    private String getSmsFormat() {
        return this.getSmsImplementation().getSmsFormat();
    }

    @Override
    @SystemApi
    public void onFeatureRemoved() {
    }

    @Override
    @SystemApi
    public void onFeatureReady() {
    }

    @Override
    public IImsMmTelFeature getBinder() {
        return this.mImsMMTelBinder;
    }

    public void setDefaultExecutor(Executor executor) {
        if (this.mExecutor == null) {
            this.mExecutor = executor;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProcessCallResult {
    }

    public static class Listener
    extends IImsMmTelListener.Stub {
        @Override
        public void onIncomingCall(IImsCallSession c, Bundle extras) {
        }

        @Override
        public void onRejectedCall(ImsCallProfile callProfile, ImsReasonInfo reason) {
        }

        @Override
        public void onVoiceMessageCountUpdate(int count) {
        }
    }

    public static class MmTelCapabilities
    extends ImsFeature.Capabilities {
        public static final int CAPABILITY_TYPE_NONE = 0;
        public static final int CAPABILITY_TYPE_VOICE = 1;
        public static final int CAPABILITY_TYPE_VIDEO = 2;
        public static final int CAPABILITY_TYPE_UT = 4;
        public static final int CAPABILITY_TYPE_SMS = 8;
        public static final int CAPABILITY_TYPE_CALL_COMPOSER = 16;
        public static final int CAPABILITY_TYPE_MAX = 17;

        @SystemApi
        public MmTelCapabilities() {
        }

        @Deprecated
        @SystemApi
        public MmTelCapabilities(ImsFeature.Capabilities c) {
            this.mCapabilities = c.mCapabilities;
        }

        @SystemApi
        public MmTelCapabilities(int capabilities) {
            super(capabilities);
        }

        @Override
        @SystemApi
        public void addCapabilities(int capabilities) {
            super.addCapabilities(capabilities);
        }

        @Override
        @SystemApi
        public void removeCapabilities(int capability) {
            super.removeCapabilities(capability);
        }

        @Override
        public boolean isCapable(int capabilities) {
            return super.isCapable(capabilities);
        }

        @Override
        public String toString() {
            StringBuilder builder2 = new StringBuilder("MmTel Capabilities - [");
            builder2.append("Voice: ");
            builder2.append(this.isCapable(1));
            builder2.append(" Video: ");
            builder2.append(this.isCapable(2));
            builder2.append(" UT: ");
            builder2.append(this.isCapable(4));
            builder2.append(" SMS: ");
            builder2.append(this.isCapable(8));
            builder2.append(" CALL_COMPOSER: ");
            builder2.append(this.isCapable(16));
            builder2.append("]");
            return builder2.toString();
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface MmTelCapability {
        }
    }
}

