/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.stub;

import android.annotation.SystemApi;
import android.os.RemoteException;
import android.util.Log;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsEcbmListener;
import com.android.internal.telephony.util.TelephonyUtils;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;

@SystemApi
public class ImsEcbmImplBase {
    private static final String TAG = "ImsEcbmImplBase";
    private final Object mLock = new Object();
    private IImsEcbmListener mListener;
    private Executor mExecutor = Runnable::run;
    private final IImsEcbm mImsEcbm = new IImsEcbm.Stub(){

        @Override
        public void setListener(IImsEcbmListener listener2) {
            this.executeMethodAsync(() -> {
                if (ImsEcbmImplBase.this.mListener != null && !ImsEcbmImplBase.this.mListener.asBinder().isBinderAlive()) {
                    Log.w(ImsEcbmImplBase.TAG, "setListener: discarding dead Binder");
                    ImsEcbmImplBase.this.mListener = null;
                }
                if (ImsEcbmImplBase.this.mListener != null && listener2 != null && Objects.equals(ImsEcbmImplBase.this.mListener.asBinder(), listener2.asBinder())) {
                    return;
                }
                if (listener2 == null) {
                    ImsEcbmImplBase.this.mListener = null;
                } else if (listener2 != null && ImsEcbmImplBase.this.mListener == null) {
                    ImsEcbmImplBase.this.mListener = listener2;
                } else {
                    Log.w(ImsEcbmImplBase.TAG, "setListener is being called when there is already an active listener");
                    ImsEcbmImplBase.this.mListener = listener2;
                }
            }, "setListener");
        }

        @Override
        public void exitEmergencyCallbackMode() {
            this.executeMethodAsync(() -> ImsEcbmImplBase.this.exitEmergencyCallbackMode(), "exitEmergencyCallbackMode");
        }

        private void executeMethodAsync(Runnable r, String errorLogName) {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), ImsEcbmImplBase.this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(ImsEcbmImplBase.TAG, "ImsEcbmImplBase Binder - " + errorLogName + " exception: " + e.getMessage());
            }
        }
    };

    public IImsEcbm getImsEcbm() {
        return this.mImsEcbm;
    }

    public void exitEmergencyCallbackMode() {
        Log.d(TAG, "exitEmergencyCallbackMode() not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteredEcbm() {
        IImsEcbmListener listener2;
        Log.d(TAG, "Entered ECBM.");
        Object object = this.mLock;
        synchronized (object) {
            listener2 = this.mListener;
        }
        if (listener2 != null) {
            try {
                listener2.enteredECBM();
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitedEcbm() {
        IImsEcbmListener listener2;
        Log.d(TAG, "Exited ECBM.");
        Object object = this.mLock;
        synchronized (object) {
            listener2 = this.mListener;
        }
        if (listener2 != null) {
            try {
                listener2.exitedECBM();
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setDefaultExecutor(Executor executor) {
        this.mExecutor = executor;
    }
}

