/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.stub;

import android.annotation.SystemApi;
import android.os.RemoteException;
import android.telephony.ims.ImsExternalCallState;
import android.util.Log;
import com.android.ims.internal.IImsExternalCallStateListener;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.internal.telephony.util.TelephonyUtils;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;

@SystemApi
public class ImsMultiEndpointImplBase {
    private static final String TAG = "MultiEndpointImplBase";
    private IImsExternalCallStateListener mListener;
    private final Object mLock = new Object();
    private Executor mExecutor = Runnable::run;
    private final IImsMultiEndpoint mImsMultiEndpoint = new IImsMultiEndpoint.Stub(){

        @Override
        public void setListener(IImsExternalCallStateListener listener2) throws RemoteException {
            this.executeMethodAsync(() -> {
                if (ImsMultiEndpointImplBase.this.mListener != null && !ImsMultiEndpointImplBase.this.mListener.asBinder().isBinderAlive()) {
                    Log.w(ImsMultiEndpointImplBase.TAG, "setListener: discarding dead Binder");
                    ImsMultiEndpointImplBase.this.mListener = null;
                }
                if (ImsMultiEndpointImplBase.this.mListener != null && listener2 != null && Objects.equals(ImsMultiEndpointImplBase.this.mListener.asBinder(), listener2.asBinder())) {
                    return;
                }
                if (listener2 == null) {
                    ImsMultiEndpointImplBase.this.mListener = null;
                } else if (listener2 != null && ImsMultiEndpointImplBase.this.mListener == null) {
                    ImsMultiEndpointImplBase.this.mListener = listener2;
                } else {
                    Log.w(ImsMultiEndpointImplBase.TAG, "setListener is being called when there is already an active listener");
                    ImsMultiEndpointImplBase.this.mListener = listener2;
                }
            }, "setListener");
        }

        @Override
        public void requestImsExternalCallStateInfo() throws RemoteException {
            this.executeMethodAsync(() -> ImsMultiEndpointImplBase.this.requestImsExternalCallStateInfo(), "requestImsExternalCallStateInfo");
        }

        private void executeMethodAsync(Runnable r, String errorLogName) {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), ImsMultiEndpointImplBase.this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(ImsMultiEndpointImplBase.TAG, "ImsMultiEndpointImplBase Binder - " + errorLogName + " exception: " + e.getMessage());
            }
        }
    };

    public IImsMultiEndpoint getIImsMultiEndpoint() {
        return this.mImsMultiEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onImsExternalCallStateUpdate(List<ImsExternalCallState> externalCallDialogs) {
        IImsExternalCallStateListener listener2;
        Log.d(TAG, "ims external call state update triggered.");
        Object object = this.mLock;
        synchronized (object) {
            listener2 = this.mListener;
        }
        if (listener2 != null) {
            try {
                listener2.onImsExternalCallStateUpdate(externalCallDialogs);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void requestImsExternalCallStateInfo() {
        Log.d(TAG, "requestImsExternalCallStateInfo() not implemented");
    }

    public void setDefaultExecutor(Executor executor) {
        this.mExecutor = executor;
    }
}

