/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.stub;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.ims.DelegateMessageCallback;
import android.telephony.ims.DelegateRequest;
import android.telephony.ims.DelegateStateCallback;
import android.telephony.ims.aidl.ISipDelegate;
import android.telephony.ims.aidl.ISipDelegateMessageCallback;
import android.telephony.ims.aidl.ISipDelegateStateCallback;
import android.telephony.ims.aidl.ISipTransport;
import android.telephony.ims.aidl.SipDelegateAidlWrapper;
import android.telephony.ims.stub.SipDelegate;
import android.util.Log;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class SipTransportImplBase {
    private static final String LOG_TAG = "SipTransportIB";
    private final IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        @Override
        public void binderDied() {
            SipTransportImplBase.this.mBinderExecutor.execute(() -> SipTransportImplBase.this.binderDiedInternal(null));
        }

        @Override
        public void binderDied(IBinder who) {
            SipTransportImplBase.this.mBinderExecutor.execute(() -> SipTransportImplBase.this.binderDiedInternal(who));
        }
    };
    private final ISipTransport.Stub mSipTransportImpl = new ISipTransport.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void createSipDelegate(int subId, DelegateRequest request, ISipDelegateStateCallback dc, ISipDelegateMessageCallback mc) {
            long token = Binder.clearCallingIdentity();
            try {
                SipTransportImplBase.this.mBinderExecutor.execute(() -> SipTransportImplBase.this.createSipDelegateInternal(subId, request, dc, mc));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroySipDelegate(ISipDelegate delegate, int reason) {
            long token = Binder.clearCallingIdentity();
            try {
                SipTransportImplBase.this.mBinderExecutor.execute(() -> SipTransportImplBase.this.destroySipDelegateInternal(delegate, reason));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    };
    private Executor mBinderExecutor;
    private final ArrayList<SipDelegateAidlWrapper> mDelegates = new ArrayList();

    public SipTransportImplBase() {
    }

    public SipTransportImplBase(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        this.mBinderExecutor = executor;
    }

    @SuppressLint(value={"ExecutorRegistration"})
    public void createSipDelegate(int subscriptionId, DelegateRequest request, DelegateStateCallback dc, DelegateMessageCallback mc) {
        throw new UnsupportedOperationException("createSipDelegate not implemented!");
    }

    public void destroySipDelegate(SipDelegate delegate, int reason) {
        throw new UnsupportedOperationException("destroySipDelegate not implemented!");
    }

    private void createSipDelegateInternal(int subId, DelegateRequest r, ISipDelegateStateCallback cb, ISipDelegateMessageCallback mc) {
        SipDelegateAidlWrapper wrapper = new SipDelegateAidlWrapper(this.mBinderExecutor, cb, mc);
        this.mDelegates.add(wrapper);
        this.linkDeathRecipient(wrapper);
        this.createSipDelegate(subId, r, wrapper, wrapper);
    }

    private void destroySipDelegateInternal(ISipDelegate d, int reason) {
        SipDelegateAidlWrapper result = null;
        for (SipDelegateAidlWrapper w : this.mDelegates) {
            if (!Objects.equals(d, w.getDelegateBinder())) continue;
            result = w;
            break;
        }
        if (result != null) {
            this.unlinkDeathRecipient(result);
            this.mDelegates.remove(result);
            this.destroySipDelegate(result.getDelegate(), reason);
        } else {
            Log.w(LOG_TAG, "destroySipDelegateInternal, could not findSipDelegate corresponding to " + d);
        }
    }

    private void linkDeathRecipient(SipDelegateAidlWrapper w) {
        try {
            w.getStateCallbackBinder().asBinder().linkToDeath(this.mDeathRecipient, 0);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "linkDeathRecipient, remote process already died, cleaning up.");
            this.mDeathRecipient.binderDied(w.getStateCallbackBinder().asBinder());
        }
    }

    private void unlinkDeathRecipient(SipDelegateAidlWrapper w) {
        try {
            w.getStateCallbackBinder().asBinder().unlinkToDeath(this.mDeathRecipient, 0);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void binderDiedInternal(IBinder who) {
        for (SipDelegateAidlWrapper w : this.mDelegates) {
            if (who != null && !w.getStateCallbackBinder().asBinder().equals(who)) continue;
            Log.w(LOG_TAG, "Binder death detected for " + w + ", calling destroy and removing.");
            this.mDelegates.remove(w);
            this.destroySipDelegate(w.getDelegate(), 1);
            return;
        }
        Log.w(LOG_TAG, "Binder death detected for IBinder " + who + ", but couldn't find matching SipDelegate");
    }

    public ISipTransport getBinder() {
        return this.mSipTransportImpl;
    }

    public void setDefaultExecutor(Executor executor) {
        if (this.mBinderExecutor == null) {
            this.mBinderExecutor = executor;
        }
    }
}

