/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.view.View;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParserException;

public class AutoText {
    private static final int TRIE_C = 0;
    private static final int TRIE_OFF = 1;
    private static final int TRIE_CHILD = 2;
    private static final int TRIE_NEXT = 3;
    private static final int TRIE_SIZEOF = 4;
    private static final char TRIE_NULL = '\uffff';
    private static final int TRIE_ROOT = 0;
    private static final int INCREMENT = 1024;
    private static final int DEFAULT = 14337;
    private static final int RIGHT = 9300;
    private static AutoText sInstance = new AutoText(Resources.getSystem());
    private static Object sLock = new Object();
    private char[] mTrie;
    private char mTrieUsed;
    private String mText;
    private Locale mLocale;
    private int mSize;

    private AutoText(Resources resources) {
        this.mLocale = resources.getConfiguration().locale;
        this.init(resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AutoText getInstance(View view2) {
        AutoText instance2;
        Resources res = view2.getContext().getResources();
        Locale locale = res.getConfiguration().locale;
        Object object = sLock;
        synchronized (object) {
            instance2 = sInstance;
            if (!locale.equals(instance2.mLocale)) {
                sInstance = instance2 = new AutoText(res);
            }
        }
        return instance2;
    }

    public static String get(CharSequence src, int start, int end, View view2) {
        return AutoText.getInstance(view2).lookup(src, start, end);
    }

    public static int getSize(View view2) {
        return AutoText.getInstance(view2).getSize();
    }

    private int getSize() {
        return this.mSize;
    }

    private String lookup(CharSequence src, int start, int end) {
        char here = this.mTrie[0];
        for (int i = start; i < end; ++i) {
            char c = src.charAt(i);
            while (here != '\uffff') {
                if (c == this.mTrie[here + '\u0000']) {
                    if (i == end - 1 && this.mTrie[here + '\u0001'] != '\uffff') {
                        char off = this.mTrie[here + '\u0001'];
                        char len = this.mText.charAt(off);
                        return this.mText.substring(off + '\u0001', off + '\u0001' + len);
                    }
                    here = this.mTrie[here + 2];
                    break;
                }
                here = this.mTrie[here + 3];
            }
            if (here != '\uffff') continue;
            return null;
        }
        return null;
    }

    private void init(Resources r) {
        XmlResourceParser parser = r.getXml(18284547);
        StringBuilder right2 = new StringBuilder(9300);
        this.mTrie = new char[14337];
        this.mTrie[0] = 65535;
        this.mTrieUsed = '\u0001';
        try {
            XmlUtils.beginDocument(parser, "words");
            String odest = "";
            char ooff = '\u0000';
            while (true) {
                char off;
                XmlUtils.nextElement(parser);
                String element = parser.getName();
                if (element == null || !element.equals("word")) break;
                String src = parser.getAttributeValue(null, "src");
                if (parser.next() != 4) continue;
                String dest = parser.getText();
                if (dest.equals(odest)) {
                    off = ooff;
                } else {
                    off = (char)right2.length();
                    right2.append((char)dest.length());
                    right2.append(dest);
                }
                this.add(src, off);
            }
            r.flushLayoutCache();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            parser.close();
        }
        this.mText = right2.toString();
    }

    private void add(String src, char off) {
        int slen = src.length();
        int herep = 0;
        ++this.mSize;
        for (int i = 0; i < slen; ++i) {
            char node;
            char c = src.charAt(i);
            boolean found = false;
            while (this.mTrie[herep] != '\uffff') {
                if (c == this.mTrie[this.mTrie[herep] + '\u0000']) {
                    if (i == slen - 1) {
                        this.mTrie[this.mTrie[herep] + '\u0001'] = off;
                        return;
                    }
                    herep = this.mTrie[herep] + 2;
                    found = true;
                    break;
                }
                herep = this.mTrie[herep] + 3;
            }
            if (found) continue;
            this.mTrie[herep] = node = this.newTrieNode();
            this.mTrie[this.mTrie[herep] + '\u0000'] = c;
            this.mTrie[this.mTrie[herep] + '\u0001'] = 65535;
            this.mTrie[this.mTrie[herep] + 3] = 65535;
            this.mTrie[this.mTrie[herep] + 2] = 65535;
            if (i == slen - 1) {
                this.mTrie[this.mTrie[herep] + '\u0001'] = off;
                return;
            }
            herep = this.mTrie[herep] + 2;
        }
    }

    private char newTrieNode() {
        if (this.mTrieUsed + 4 > this.mTrie.length) {
            char[] copy = new char[this.mTrie.length + 1024];
            System.arraycopy(this.mTrie, 0, copy, 0, this.mTrie.length);
            this.mTrie = copy;
        }
        char ret = this.mTrieUsed;
        this.mTrieUsed = (char)(this.mTrieUsed + 4);
        return ret;
    }
}

