/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.app.ActivityThread;
import android.app.Application;
import android.app.Application_Delegate;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Html;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class HtmlToSpannedConverter
implements ContentHandler {
    private static final float[] HEADING_SIZES = new float[]{1.5f, 1.4f, 1.3f, 1.2f, 1.1f, 1.0f};
    private String mSource;
    private XMLReader mReader;
    private SpannableStringBuilder mSpannableStringBuilder;
    private Html.ImageGetter mImageGetter;
    private Html.TagHandler mTagHandler;
    private int mFlags;
    private static Pattern sTextAlignPattern;
    private static Pattern sForegroundColorPattern;
    private static Pattern sBackgroundColorPattern;
    private static Pattern sTextDecorationPattern;
    private static final Map<String, Integer> sColorMap;

    private static Pattern getTextAlignPattern() {
        if (sTextAlignPattern == null) {
            sTextAlignPattern = Pattern.compile("(?:\\s+|\\A)text-align\\s*:\\s*(\\S*)\\b");
        }
        return sTextAlignPattern;
    }

    private static Pattern getForegroundColorPattern() {
        if (sForegroundColorPattern == null) {
            sForegroundColorPattern = Pattern.compile("(?:\\s+|\\A)color\\s*:\\s*(\\S*)\\b");
        }
        return sForegroundColorPattern;
    }

    private static Pattern getBackgroundColorPattern() {
        if (sBackgroundColorPattern == null) {
            sBackgroundColorPattern = Pattern.compile("(?:\\s+|\\A)background(?:-color)?\\s*:\\s*(\\S*)\\b");
        }
        return sBackgroundColorPattern;
    }

    private static Pattern getTextDecorationPattern() {
        if (sTextDecorationPattern == null) {
            sTextDecorationPattern = Pattern.compile("(?:\\s+|\\A)text-decoration\\s*:\\s*(\\S*)\\b");
        }
        return sTextDecorationPattern;
    }

    public HtmlToSpannedConverter(String source, Html.ImageGetter imageGetter, Html.TagHandler tagHandler, Parser parser, int flags) {
        this.mSource = source;
        this.mSpannableStringBuilder = new SpannableStringBuilder();
        this.mImageGetter = imageGetter;
        this.mTagHandler = tagHandler;
        this.mReader = parser;
        this.mFlags = flags;
    }

    public Spanned convert() {
        this.mReader.setContentHandler(this);
        try {
            this.mReader.parse(new InputSource(new StringReader(this.mSource)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        ParagraphStyle[] obj = this.mSpannableStringBuilder.getSpans(0, this.mSpannableStringBuilder.length(), ParagraphStyle.class);
        for (int i = 0; i < obj.length; ++i) {
            int start = this.mSpannableStringBuilder.getSpanStart(obj[i]);
            int end = this.mSpannableStringBuilder.getSpanEnd(obj[i]);
            if (end - 2 >= 0 && this.mSpannableStringBuilder.charAt(end - 1) == '\n' && this.mSpannableStringBuilder.charAt(end - 2) == '\n') {
                --end;
            }
            if (end == start) {
                this.mSpannableStringBuilder.removeSpan(obj[i]);
                continue;
            }
            this.mSpannableStringBuilder.setSpan(obj[i], start, end, 51);
        }
        return this.mSpannableStringBuilder;
    }

    private void handleStartTag(String tag2, Attributes attributes) {
        if (!tag2.equalsIgnoreCase("br")) {
            if (tag2.equalsIgnoreCase("p")) {
                HtmlToSpannedConverter.startBlockElement(this.mSpannableStringBuilder, attributes, this.getMarginParagraph());
                this.startCssStyle(this.mSpannableStringBuilder, attributes);
            } else if (tag2.equalsIgnoreCase("ul")) {
                HtmlToSpannedConverter.startBlockElement(this.mSpannableStringBuilder, attributes, this.getMarginList());
            } else if (tag2.equalsIgnoreCase("li")) {
                this.startLi(this.mSpannableStringBuilder, attributes);
            } else if (tag2.equalsIgnoreCase("div")) {
                HtmlToSpannedConverter.startBlockElement(this.mSpannableStringBuilder, attributes, this.getMarginDiv());
            } else if (tag2.equalsIgnoreCase("span")) {
                this.startCssStyle(this.mSpannableStringBuilder, attributes);
            } else if (tag2.equalsIgnoreCase("strong")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Bold());
            } else if (tag2.equalsIgnoreCase("b")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Bold());
            } else if (tag2.equalsIgnoreCase("em")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic());
            } else if (tag2.equalsIgnoreCase("cite")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic());
            } else if (tag2.equalsIgnoreCase("dfn")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic());
            } else if (tag2.equalsIgnoreCase("i")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic());
            } else if (tag2.equalsIgnoreCase("big")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Big());
            } else if (tag2.equalsIgnoreCase("small")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Small());
            } else if (tag2.equalsIgnoreCase("font")) {
                this.startFont(this.mSpannableStringBuilder, attributes);
            } else if (tag2.equalsIgnoreCase("blockquote")) {
                this.startBlockquote(this.mSpannableStringBuilder, attributes);
            } else if (tag2.equalsIgnoreCase("tt")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Monospace());
            } else if (tag2.equalsIgnoreCase("a")) {
                HtmlToSpannedConverter.startA(this.mSpannableStringBuilder, attributes);
            } else if (tag2.equalsIgnoreCase("u")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Underline());
            } else if (tag2.equalsIgnoreCase("del")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Strikethrough());
            } else if (tag2.equalsIgnoreCase("s")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Strikethrough());
            } else if (tag2.equalsIgnoreCase("strike")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Strikethrough());
            } else if (tag2.equalsIgnoreCase("sup")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Super());
            } else if (tag2.equalsIgnoreCase("sub")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Sub());
            } else if (tag2.length() == 2 && Character.toLowerCase(tag2.charAt(0)) == 'h' && tag2.charAt(1) >= '1' && tag2.charAt(1) <= '6') {
                this.startHeading(this.mSpannableStringBuilder, attributes, tag2.charAt(1) - 49);
            } else if (tag2.equalsIgnoreCase("img")) {
                HtmlToSpannedConverter.startImg(this.mSpannableStringBuilder, attributes, this.mImageGetter);
            } else if (this.mTagHandler != null) {
                this.mTagHandler.handleTag(true, tag2, this.mSpannableStringBuilder, this.mReader);
            }
        }
    }

    private void handleEndTag(String tag2) {
        if (tag2.equalsIgnoreCase("br")) {
            HtmlToSpannedConverter.handleBr(this.mSpannableStringBuilder);
        } else if (tag2.equalsIgnoreCase("p")) {
            HtmlToSpannedConverter.endCssStyle(this.mSpannableStringBuilder);
            HtmlToSpannedConverter.endBlockElement(this.mSpannableStringBuilder);
        } else if (tag2.equalsIgnoreCase("ul")) {
            HtmlToSpannedConverter.endBlockElement(this.mSpannableStringBuilder);
        } else if (tag2.equalsIgnoreCase("li")) {
            HtmlToSpannedConverter.endLi(this.mSpannableStringBuilder);
        } else if (tag2.equalsIgnoreCase("div")) {
            HtmlToSpannedConverter.endBlockElement(this.mSpannableStringBuilder);
        } else if (tag2.equalsIgnoreCase("span")) {
            HtmlToSpannedConverter.endCssStyle(this.mSpannableStringBuilder);
        } else if (tag2.equalsIgnoreCase("strong")) {
            Application application = ActivityThread.currentApplication();
            int fontWeightAdjustment = Application_Delegate.getResources((Application)application).getConfiguration().fontWeightAdjustment;
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Bold.class, new StyleSpan(1, fontWeightAdjustment));
        } else if (tag2.equalsIgnoreCase("b")) {
            Application application = ActivityThread.currentApplication();
            int fontWeightAdjustment = Application_Delegate.getResources((Application)application).getConfiguration().fontWeightAdjustment;
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Bold.class, new StyleSpan(1, fontWeightAdjustment));
        } else if (tag2.equalsIgnoreCase("em")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag2.equalsIgnoreCase("cite")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag2.equalsIgnoreCase("dfn")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag2.equalsIgnoreCase("i")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag2.equalsIgnoreCase("big")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Big.class, new RelativeSizeSpan(1.25f));
        } else if (tag2.equalsIgnoreCase("small")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Small.class, new RelativeSizeSpan(0.8f));
        } else if (tag2.equalsIgnoreCase("font")) {
            HtmlToSpannedConverter.endFont(this.mSpannableStringBuilder);
        } else if (tag2.equalsIgnoreCase("blockquote")) {
            HtmlToSpannedConverter.endBlockquote(this.mSpannableStringBuilder);
        } else if (tag2.equalsIgnoreCase("tt")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Monospace.class, new TypefaceSpan("monospace"));
        } else if (tag2.equalsIgnoreCase("a")) {
            HtmlToSpannedConverter.endA(this.mSpannableStringBuilder);
        } else if (tag2.equalsIgnoreCase("u")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Underline.class, new UnderlineSpan());
        } else if (tag2.equalsIgnoreCase("del")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Strikethrough.class, new StrikethroughSpan());
        } else if (tag2.equalsIgnoreCase("s")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Strikethrough.class, new StrikethroughSpan());
        } else if (tag2.equalsIgnoreCase("strike")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Strikethrough.class, new StrikethroughSpan());
        } else if (tag2.equalsIgnoreCase("sup")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Super.class, new SuperscriptSpan());
        } else if (tag2.equalsIgnoreCase("sub")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Sub.class, new SubscriptSpan());
        } else if (tag2.length() == 2 && Character.toLowerCase(tag2.charAt(0)) == 'h' && tag2.charAt(1) >= '1' && tag2.charAt(1) <= '6') {
            HtmlToSpannedConverter.endHeading(this.mSpannableStringBuilder);
        } else if (this.mTagHandler != null) {
            this.mTagHandler.handleTag(false, tag2, this.mSpannableStringBuilder, this.mReader);
        }
    }

    private int getMarginParagraph() {
        return this.getMargin(1);
    }

    private int getMarginHeading() {
        return this.getMargin(2);
    }

    private int getMarginListItem() {
        return this.getMargin(4);
    }

    private int getMarginList() {
        return this.getMargin(8);
    }

    private int getMarginDiv() {
        return this.getMargin(16);
    }

    private int getMarginBlockquote() {
        return this.getMargin(32);
    }

    private int getMargin(int flag) {
        if ((flag & this.mFlags) != 0) {
            return 1;
        }
        return 2;
    }

    private static void appendNewlines(Editable text, int minNewline) {
        int len = text.length();
        if (len == 0) {
            return;
        }
        int existingNewlines = 0;
        for (int i = len - 1; i >= 0 && text.charAt(i) == '\n'; --i) {
            ++existingNewlines;
        }
        for (int j = existingNewlines; j < minNewline; ++j) {
            text.append("\n");
        }
    }

    private static void startBlockElement(Editable text, Attributes attributes, int margin) {
        Matcher m;
        String style2;
        int len = text.length();
        if (margin > 0) {
            HtmlToSpannedConverter.appendNewlines(text, margin);
            HtmlToSpannedConverter.start(text, new Newline(margin));
        }
        if ((style2 = attributes.getValue("", "style")) != null && (m = HtmlToSpannedConverter.getTextAlignPattern().matcher(style2)).find()) {
            String alignment = m.group(1);
            if (alignment.equalsIgnoreCase("start")) {
                HtmlToSpannedConverter.start(text, new Alignment(Layout.Alignment.ALIGN_NORMAL));
            } else if (alignment.equalsIgnoreCase("center")) {
                HtmlToSpannedConverter.start(text, new Alignment(Layout.Alignment.ALIGN_CENTER));
            } else if (alignment.equalsIgnoreCase("end")) {
                HtmlToSpannedConverter.start(text, new Alignment(Layout.Alignment.ALIGN_OPPOSITE));
            }
        }
    }

    private static void endBlockElement(Editable text) {
        Alignment a;
        Newline n = HtmlToSpannedConverter.getLast(text, Newline.class);
        if (n != null) {
            HtmlToSpannedConverter.appendNewlines(text, n.mNumNewlines);
            text.removeSpan(n);
        }
        if ((a = HtmlToSpannedConverter.getLast(text, Alignment.class)) != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, a, new AlignmentSpan.Standard(a.mAlignment));
        }
    }

    private static void handleBr(Editable text) {
        text.append('\n');
    }

    private void startLi(Editable text, Attributes attributes) {
        HtmlToSpannedConverter.startBlockElement(text, attributes, this.getMarginListItem());
        HtmlToSpannedConverter.start(text, new Bullet());
        this.startCssStyle(text, attributes);
    }

    private static void endLi(Editable text) {
        HtmlToSpannedConverter.endCssStyle(text);
        HtmlToSpannedConverter.endBlockElement(text);
        HtmlToSpannedConverter.end(text, Bullet.class, new BulletSpan());
    }

    private void startBlockquote(Editable text, Attributes attributes) {
        HtmlToSpannedConverter.startBlockElement(text, attributes, this.getMarginBlockquote());
        HtmlToSpannedConverter.start(text, new Blockquote());
    }

    private static void endBlockquote(Editable text) {
        HtmlToSpannedConverter.endBlockElement(text);
        HtmlToSpannedConverter.end(text, Blockquote.class, new QuoteSpan());
    }

    private void startHeading(Editable text, Attributes attributes, int level) {
        HtmlToSpannedConverter.startBlockElement(text, attributes, this.getMarginHeading());
        HtmlToSpannedConverter.start(text, new Heading(level));
    }

    private static void endHeading(Editable text) {
        Heading h = HtmlToSpannedConverter.getLast(text, Heading.class);
        if (h != null) {
            Application application = ActivityThread.currentApplication();
            int fontWeightAdjustment = Application_Delegate.getResources((Application)application).getConfiguration().fontWeightAdjustment;
            HtmlToSpannedConverter.setSpanFromMark(text, h, new RelativeSizeSpan(HEADING_SIZES[h.mLevel]), new StyleSpan(1, fontWeightAdjustment));
        }
        HtmlToSpannedConverter.endBlockElement(text);
    }

    private static <T> T getLast(Spanned text, Class<T> kind) {
        T[] objs = text.getSpans(0, text.length(), kind);
        if (objs.length == 0) {
            return null;
        }
        return objs[objs.length - 1];
    }

    private static void setSpanFromMark(Spannable text, Object mark, Object ... spans) {
        int where = text.getSpanStart(mark);
        text.removeSpan(mark);
        int len = text.length();
        if (where != len) {
            for (Object span : spans) {
                text.setSpan(span, where, len, 33);
            }
        }
    }

    private static void start(Editable text, Object mark) {
        int len = text.length();
        text.setSpan(mark, len, len, 17);
    }

    private static void end(Editable text, Class kind, Object repl) {
        int len = text.length();
        Object obj = HtmlToSpannedConverter.getLast(text, kind);
        if (obj != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, obj, repl);
        }
    }

    private void startCssStyle(Editable text, Attributes attributes) {
        String style2 = attributes.getValue("", "style");
        if (style2 != null) {
            String textDecoration;
            int c;
            Matcher m = HtmlToSpannedConverter.getForegroundColorPattern().matcher(style2);
            if (m.find() && (c = this.getHtmlColor(m.group(1))) != -1) {
                HtmlToSpannedConverter.start(text, new Foreground(c | 0xFF000000));
            }
            if ((m = HtmlToSpannedConverter.getBackgroundColorPattern().matcher(style2)).find() && (c = this.getHtmlColor(m.group(1))) != -1) {
                HtmlToSpannedConverter.start(text, new Background(c | 0xFF000000));
            }
            if ((m = HtmlToSpannedConverter.getTextDecorationPattern().matcher(style2)).find() && (textDecoration = m.group(1)).equalsIgnoreCase("line-through")) {
                HtmlToSpannedConverter.start(text, new Strikethrough());
            }
        }
    }

    private static void endCssStyle(Editable text) {
        Foreground f;
        Background b;
        Strikethrough s = HtmlToSpannedConverter.getLast(text, Strikethrough.class);
        if (s != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, s, new StrikethroughSpan());
        }
        if ((b = HtmlToSpannedConverter.getLast(text, Background.class)) != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, b, new BackgroundColorSpan(b.mBackgroundColor));
        }
        if ((f = HtmlToSpannedConverter.getLast(text, Foreground.class)) != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, f, new ForegroundColorSpan(f.mForegroundColor));
        }
    }

    private static void startImg(Editable text, Attributes attributes, Html.ImageGetter img) {
        String src = attributes.getValue("", "src");
        Drawable d = null;
        if (img != null) {
            d = img.getDrawable(src);
        }
        if (d == null) {
            d = Resources.getSystem().getDrawable(17303823);
            d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
        }
        int len = text.length();
        text.append("\ufffc");
        text.setSpan(new ImageSpan(d, src), len, text.length(), 33);
    }

    private void startFont(Editable text, Attributes attributes) {
        int c;
        String color2 = attributes.getValue("", "color");
        String face = attributes.getValue("", "face");
        if (!TextUtils.isEmpty(color2) && (c = this.getHtmlColor(color2)) != -1) {
            HtmlToSpannedConverter.start(text, new Foreground(c | 0xFF000000));
        }
        if (!TextUtils.isEmpty(face)) {
            HtmlToSpannedConverter.start(text, new Font(face));
        }
    }

    private static void endFont(Editable text) {
        Foreground foreground;
        Font font = HtmlToSpannedConverter.getLast(text, Font.class);
        if (font != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, font, new TypefaceSpan(font.mFace));
        }
        if ((foreground = HtmlToSpannedConverter.getLast(text, Foreground.class)) != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, foreground, new ForegroundColorSpan(foreground.mForegroundColor));
        }
    }

    private static void startA(Editable text, Attributes attributes) {
        String href = attributes.getValue("", "href");
        HtmlToSpannedConverter.start(text, new Href(href));
    }

    private static void endA(Editable text) {
        Href h = HtmlToSpannedConverter.getLast(text, Href.class);
        if (h != null && h.mHref != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, h, new URLSpan(h.mHref));
        }
    }

    private int getHtmlColor(String color2) {
        Integer i;
        if ((this.mFlags & 0x100) == 256 && (i = sColorMap.get(color2.toLowerCase(Locale.US))) != null) {
            return i;
        }
        if (Character.isLetter(color2.charAt(0))) {
            try {
                return Color.parseColor(color2);
            }
            catch (IllegalArgumentException e) {
                return -1;
            }
        }
        try {
            return XmlUtils.convertValueToInt(color2, -1);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.handleStartTag(localName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.handleEndTag(localName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = ch[i + start];
            if (c == ' ' || c == '\n') {
                int len = sb.length();
                int pred = len == 0 ? ((len = this.mSpannableStringBuilder.length()) == 0 ? 10 : (int)this.mSpannableStringBuilder.charAt(len - 1)) : sb.charAt(len - 1);
                if (pred == 32 || pred == 10) continue;
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        this.mSpannableStringBuilder.append(sb);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    static {
        sColorMap = new HashMap<String, Integer>();
        sColorMap.put("darkgray", -5658199);
        sColorMap.put("gray", -8355712);
        sColorMap.put("lightgray", -2894893);
        sColorMap.put("darkgrey", -5658199);
        sColorMap.put("grey", -8355712);
        sColorMap.put("lightgrey", -2894893);
        sColorMap.put("green", -16744448);
    }

    private static class Alignment {
        private Layout.Alignment mAlignment;

        public Alignment(Layout.Alignment alignment) {
            this.mAlignment = alignment;
        }
    }

    private static class Newline {
        private int mNumNewlines;

        public Newline(int numNewlines) {
            this.mNumNewlines = numNewlines;
        }
    }

    private static class Heading {
        private int mLevel;

        public Heading(int level) {
            this.mLevel = level;
        }
    }

    private static class Background {
        private int mBackgroundColor;

        public Background(int backgroundColor) {
            this.mBackgroundColor = backgroundColor;
        }
    }

    private static class Foreground {
        private int mForegroundColor;

        public Foreground(int foregroundColor) {
            this.mForegroundColor = foregroundColor;
        }
    }

    private static class Href {
        public String mHref;

        public Href(String href) {
            this.mHref = href;
        }
    }

    private static class Font {
        public String mFace;

        public Font(String face) {
            this.mFace = face;
        }
    }

    private static class Bullet {
        private Bullet() {
        }
    }

    private static class Sub {
        private Sub() {
        }
    }

    private static class Super {
        private Super() {
        }
    }

    private static class Blockquote {
        private Blockquote() {
        }
    }

    private static class Monospace {
        private Monospace() {
        }
    }

    private static class Small {
        private Small() {
        }
    }

    private static class Big {
        private Big() {
        }
    }

    private static class Strikethrough {
        private Strikethrough() {
        }
    }

    private static class Underline {
        private Underline() {
        }
    }

    private static class Italic {
        private Italic() {
        }
    }

    private static class Bold {
        private Bold() {
        }
    }
}

