/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.icu.text.DateFormatSymbols;
import android.icu.text.MeasureFormat;
import android.icu.util.Measure;
import android.icu.util.MeasureUnit;
import android.text.format.DateFormat;
import android.text.format.DateIntervalFormat;
import android.text.format.RelativeDateTimeFormatter;
import android.text.format.Time;
import com.android.internal.lang.System_Delegate;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateUtils {
    private static final Object sLock = new Object();
    private static Configuration sLastConfig;
    private static String sElapsedFormatMMSS;
    private static String sElapsedFormatHMMSS;
    public static final long SECOND_IN_MILLIS = 1000L;
    public static final long MINUTE_IN_MILLIS = 60000L;
    public static final long HOUR_IN_MILLIS = 3600000L;
    public static final long DAY_IN_MILLIS = 86400000L;
    public static final long WEEK_IN_MILLIS = 604800000L;
    @Deprecated
    public static final long YEAR_IN_MILLIS = 31449600000L;
    public static final int FORMAT_SHOW_TIME = 1;
    public static final int FORMAT_SHOW_WEEKDAY = 2;
    public static final int FORMAT_SHOW_YEAR = 4;
    public static final int FORMAT_NO_YEAR = 8;
    public static final int FORMAT_SHOW_DATE = 16;
    public static final int FORMAT_NO_MONTH_DAY = 32;
    @Deprecated
    public static final int FORMAT_12HOUR = 64;
    @Deprecated
    public static final int FORMAT_24HOUR = 128;
    @Deprecated
    public static final int FORMAT_CAP_AMPM = 256;
    public static final int FORMAT_NO_NOON = 512;
    @Deprecated
    public static final int FORMAT_CAP_NOON = 1024;
    public static final int FORMAT_NO_MIDNIGHT = 2048;
    @Deprecated
    public static final int FORMAT_CAP_MIDNIGHT = 4096;
    @Deprecated
    public static final int FORMAT_UTC = 8192;
    public static final int FORMAT_ABBREV_TIME = 16384;
    public static final int FORMAT_ABBREV_WEEKDAY = 32768;
    public static final int FORMAT_ABBREV_MONTH = 65536;
    public static final int FORMAT_NUMERIC_DATE = 131072;
    public static final int FORMAT_ABBREV_RELATIVE = 262144;
    public static final int FORMAT_ABBREV_ALL = 524288;
    @Deprecated
    public static final int FORMAT_CAP_NOON_MIDNIGHT = 5120;
    @Deprecated
    public static final int FORMAT_NO_NOON_MIDNIGHT = 2560;
    @Deprecated
    public static final String HOUR_MINUTE_24 = "%H:%M";
    public static final String MONTH_FORMAT = "%B";
    @Deprecated
    public static final String ABBREV_MONTH_FORMAT = "%b";
    public static final String NUMERIC_MONTH_FORMAT = "%m";
    public static final String MONTH_DAY_FORMAT = "%-d";
    public static final String YEAR_FORMAT = "%Y";
    public static final String YEAR_FORMAT_TWO_DIGITS = "%g";
    public static final String WEEKDAY_FORMAT = "%A";
    public static final String ABBREV_WEEKDAY_FORMAT = "%a";
    @Deprecated
    public static final int[] sameYearTable;
    @Deprecated
    public static final int[] sameMonthTable;
    @Deprecated
    public static final int LENGTH_LONG = 10;
    @Deprecated
    public static final int LENGTH_MEDIUM = 20;
    @Deprecated
    public static final int LENGTH_SHORT = 30;
    @Deprecated
    public static final int LENGTH_SHORTER = 40;
    @Deprecated
    public static final int LENGTH_SHORTEST = 50;
    private static Time sNowTime;
    private static Time sThenTime;

    @Deprecated
    public static String getDayOfWeekString(int dayOfWeek, int abbrev) {
        int width2;
        DateFormatSymbols dfs = DateFormatSymbols.getInstance();
        switch (abbrev) {
            case 10: {
                width2 = 1;
                break;
            }
            case 50: {
                width2 = 2;
                break;
            }
            default: {
                width2 = 0;
            }
        }
        return dfs.getWeekdays(0, width2)[dayOfWeek];
    }

    @Deprecated
    public static String getAMPMString(int ampm) {
        String[] amPm = DateFormat.getIcuDateFormatSymbols(AndroidLocale.getDefault()).getAmPmStrings();
        return amPm[ampm - 0];
    }

    @Deprecated
    public static String getMonthString(int month, int abbrev) {
        int width2;
        DateFormatSymbols dfs = DateFormat.getIcuDateFormatSymbols(AndroidLocale.getDefault());
        switch (abbrev) {
            case 10: {
                width2 = 1;
                break;
            }
            case 50: {
                width2 = 2;
                break;
            }
            default: {
                width2 = 0;
            }
        }
        return dfs.getMonths(0, width2)[month];
    }

    public static CharSequence getRelativeTimeSpanString(long startTime) {
        return DateUtils.getRelativeTimeSpanString(startTime, System_Delegate.currentTimeMillis(), 60000L);
    }

    public static CharSequence getRelativeTimeSpanString(long time, long now, long minResolution) {
        int flags = 65556;
        return DateUtils.getRelativeTimeSpanString(time, now, minResolution, flags);
    }

    public static CharSequence getRelativeTimeSpanString(long time, long now, long minResolution, int flags) {
        return RelativeDateTimeFormatter.getRelativeTimeSpanString(AndroidLocale.getDefault(), TimeZone.getDefault(), time, now, minResolution, flags);
    }

    public static CharSequence getRelativeDateTimeString(Context c, long time, long minResolution, long transitionResolution, int flags) {
        if ((flags & 0xC1) == 1) {
            flags |= DateFormat.is24HourFormat(c) ? 128 : 64;
        }
        return RelativeDateTimeFormatter.getRelativeDateTimeString(AndroidLocale.getDefault(), TimeZone.getDefault(), time, System_Delegate.currentTimeMillis(), minResolution, transitionResolution, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initFormatStrings() {
        Object object = sLock;
        synchronized (object) {
            DateUtils.initFormatStringsLocked();
        }
    }

    private static void initFormatStringsLocked() {
        Resources r = Resources.getSystem();
        Configuration cfg = r.getConfiguration();
        if (sLastConfig == null || !sLastConfig.equals(cfg)) {
            sLastConfig = cfg;
            sElapsedFormatMMSS = r.getString(17040198);
            sElapsedFormatHMMSS = r.getString(17040197);
        }
    }

    @UnsupportedAppUsage
    public static CharSequence formatDuration(long millis) {
        return DateUtils.formatDuration(millis, 10);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static CharSequence formatDuration(long millis, int abbrev) {
        MeasureFormat.FormatWidth width2;
        switch (abbrev) {
            case 10: {
                width2 = MeasureFormat.FormatWidth.WIDE;
                break;
            }
            case 20: 
            case 30: 
            case 40: {
                width2 = MeasureFormat.FormatWidth.SHORT;
                break;
            }
            case 50: {
                width2 = MeasureFormat.FormatWidth.NARROW;
                break;
            }
            default: {
                width2 = MeasureFormat.FormatWidth.WIDE;
            }
        }
        MeasureFormat formatter = MeasureFormat.getInstance(AndroidLocale.getDefault(), width2);
        if (millis >= 3600000L) {
            int hours = (int)((millis + 1800000L) / 3600000L);
            return formatter.format(new Measure(hours, MeasureUnit.HOUR));
        }
        if (millis >= 60000L) {
            int minutes = (int)((millis + 30000L) / 60000L);
            return formatter.format(new Measure(minutes, MeasureUnit.MINUTE));
        }
        int seconds = (int)((millis + 500L) / 1000L);
        return formatter.format(new Measure(seconds, MeasureUnit.SECOND));
    }

    public static String formatElapsedTime(long elapsedSeconds) {
        return DateUtils.formatElapsedTime(null, elapsedSeconds);
    }

    public static String formatElapsedTime(StringBuilder recycle, long elapsedSeconds) {
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        if (elapsedSeconds >= 3600L) {
            hours = elapsedSeconds / 3600L;
            elapsedSeconds -= hours * 3600L;
        }
        if (elapsedSeconds >= 60L) {
            minutes = elapsedSeconds / 60L;
            elapsedSeconds -= minutes * 60L;
        }
        seconds = elapsedSeconds;
        StringBuilder sb = recycle;
        if (sb == null) {
            sb = new StringBuilder(8);
        } else {
            sb.setLength(0);
        }
        Formatter f = new Formatter(sb, AndroidLocale.getDefault());
        DateUtils.initFormatStrings();
        if (hours > 0L) {
            return f.format(sElapsedFormatHMMSS, hours, minutes, seconds).toString();
        }
        return f.format(sElapsedFormatMMSS, minutes, seconds).toString();
    }

    public static CharSequence formatSameDayTime(long then, long now, int dateStyle, int timeStyle) {
        GregorianCalendar thenCal = new GregorianCalendar();
        thenCal.setTimeInMillis(then);
        Date thenDate = thenCal.getTime();
        GregorianCalendar nowCal = new GregorianCalendar();
        nowCal.setTimeInMillis(now);
        java.text.DateFormat f = thenCal.get(1) == nowCal.get(1) && thenCal.get(2) == nowCal.get(2) && thenCal.get(5) == nowCal.get(5) ? java.text.DateFormat.getTimeInstance(timeStyle) : java.text.DateFormat.getDateInstance(dateStyle);
        return f.format(thenDate);
    }

    public static boolean isToday(long when) {
        return DateUtils.isSameDate(when, System_Delegate.currentTimeMillis());
    }

    private static boolean isSameDate(long oneMillis, long twoMillis) {
        ZoneId zoneId = ZoneId.systemDefault();
        Instant oneInstant = Instant.ofEpochMilli(oneMillis);
        LocalDateTime oneLocalDateTime = LocalDateTime.ofInstant(oneInstant, zoneId);
        Instant twoInstant = Instant.ofEpochMilli(twoMillis);
        LocalDateTime twoLocalDateTime = LocalDateTime.ofInstant(twoInstant, zoneId);
        return oneLocalDateTime.getYear() == twoLocalDateTime.getYear() && oneLocalDateTime.getMonthValue() == twoLocalDateTime.getMonthValue() && oneLocalDateTime.getDayOfMonth() == twoLocalDateTime.getDayOfMonth();
    }

    public static String formatDateRange(Context context, long startMillis, long endMillis, int flags) {
        Formatter f = new Formatter(new StringBuilder(50), AndroidLocale.getDefault());
        return DateUtils.formatDateRange(context, f, startMillis, endMillis, flags).toString();
    }

    public static Formatter formatDateRange(Context context, Formatter formatter, long startMillis, long endMillis, int flags) {
        return DateUtils.formatDateRange(context, formatter, startMillis, endMillis, flags, null);
    }

    public static Formatter formatDateRange(Context context, Formatter formatter, long startMillis, long endMillis, int flags, String timeZone) {
        if ((flags & 0xC1) == 1) {
            flags |= DateFormat.is24HourFormat(context) ? 128 : 64;
        }
        String range = DateIntervalFormat.formatDateRange(startMillis, endMillis, flags, timeZone);
        try {
            formatter.out().append(range);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return formatter;
    }

    public static String formatDateTime(Context context, long millis, int flags) {
        return DateUtils.formatDateRange(context, millis, millis, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence getRelativeTimeSpanString(Context c, long millis, boolean withPreposition) {
        long now = System_Delegate.currentTimeMillis();
        long span = Math.abs(now - millis);
        Class<DateUtils> clazz = DateUtils.class;
        synchronized (DateUtils.class) {
            int prepositionId;
            String result;
            int flags;
            if (sNowTime == null) {
                sNowTime = new Time();
            }
            if (sThenTime == null) {
                sThenTime = new Time();
            }
            sNowTime.set(now);
            sThenTime.set(millis);
            if (span < 86400000L && DateUtils.sNowTime.weekDay == DateUtils.sThenTime.weekDay) {
                flags = 1;
                result = DateUtils.formatDateRange(c, millis, millis, flags);
                prepositionId = 17041346;
            } else if (DateUtils.sNowTime.year != DateUtils.sThenTime.year) {
                flags = 131092;
                result = DateUtils.formatDateRange(c, millis, millis, flags);
                prepositionId = 17041345;
            } else {
                flags = 65552;
                result = DateUtils.formatDateRange(c, millis, millis, flags);
                prepositionId = 17041345;
            }
            if (withPreposition) {
                Resources res = c.getResources();
                result = res.getString(prepositionId, result);
            }
            // ** MonitorExit[var9_5] (shouldn't be in output)
            return result;
        }
    }

    public static CharSequence getRelativeTimeSpanString(Context c, long millis) {
        return DateUtils.getRelativeTimeSpanString(c, millis, false);
    }

    static {
        sameYearTable = null;
        sameMonthTable = null;
    }
}

