/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.icu.text.DisplayContext;
import android.icu.text.RelativeDateTimeFormatter;
import android.icu.util.Calendar;
import android.icu.util.ULocale;
import android.text.format.DateTimeFormat;
import android.text.format.DateUtilsBridge;
import android.util.LruCache;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Locale;
import java.util.TimeZone;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class RelativeDateTimeFormatter {
    public static final long SECOND_IN_MILLIS = 1000L;
    public static final long MINUTE_IN_MILLIS = 60000L;
    public static final long HOUR_IN_MILLIS = 3600000L;
    public static final long DAY_IN_MILLIS = 86400000L;
    public static final long WEEK_IN_MILLIS = 604800000L;
    public static final long YEAR_IN_MILLIS = 31449600000L;
    private static final int DAY_IN_MS = 86400000;
    private static final int EPOCH_JULIAN_DAY = 2440588;
    private static final FormatterCache CACHED_FORMATTERS = new FormatterCache();

    private RelativeDateTimeFormatter() {
    }

    public static String getRelativeTimeSpanString(Locale locale, TimeZone tz, long time, long now, long minResolution, int flags) {
        DisplayContext displayContext = DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE;
        return RelativeDateTimeFormatter.getRelativeTimeSpanString(locale, tz, time, now, minResolution, flags, displayContext);
    }

    public static String getRelativeTimeSpanString(Locale locale, TimeZone tz, long time, long now, long minResolution, int flags, DisplayContext displayContext) {
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        if (tz == null) {
            throw new NullPointerException("tz == null");
        }
        ULocale icuLocale = ULocale.forLocale(locale);
        android.icu.util.TimeZone icuTimeZone = DateUtilsBridge.icuTimeZone(tz);
        return RelativeDateTimeFormatter.getRelativeTimeSpanString(icuLocale, icuTimeZone, time, now, minResolution, flags, displayContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRelativeTimeSpanString(ULocale icuLocale, android.icu.util.TimeZone icuTimeZone, long time, long now, long minResolution, int flags, DisplayContext displayContext) {
        RelativeDateTimeFormatter.RelativeUnit unit2;
        int count;
        long duration = Math.abs(now - time);
        boolean past = now >= time;
        RelativeDateTimeFormatter.Style style2 = (flags & 0xC0000) != 0 ? RelativeDateTimeFormatter.Style.SHORT : RelativeDateTimeFormatter.Style.LONG;
        RelativeDateTimeFormatter.Direction direction = past ? RelativeDateTimeFormatter.Direction.LAST : RelativeDateTimeFormatter.Direction.NEXT;
        boolean relative = true;
        RelativeDateTimeFormatter.AbsoluteUnit aunit = null;
        if (duration < 60000L && minResolution < 60000L) {
            count = (int)(duration / 1000L);
            unit2 = RelativeDateTimeFormatter.RelativeUnit.SECONDS;
        } else if (duration < 3600000L && minResolution < 3600000L) {
            count = (int)(duration / 60000L);
            unit2 = RelativeDateTimeFormatter.RelativeUnit.MINUTES;
        } else if (duration < 86400000L && minResolution < 86400000L) {
            count = (int)(duration / 3600000L);
            unit2 = RelativeDateTimeFormatter.RelativeUnit.HOURS;
        } else if (duration < 604800000L && minResolution < 604800000L) {
            count = Math.abs(RelativeDateTimeFormatter.dayDistance(icuTimeZone, time, now));
            unit2 = RelativeDateTimeFormatter.RelativeUnit.DAYS;
            if (count == 2) {
                String str;
                FormatterCache formatterCache;
                if (past) {
                    formatterCache = CACHED_FORMATTERS;
                    synchronized (formatterCache) {
                        str = RelativeDateTimeFormatter.getFormatter(icuLocale, style2, displayContext).format(RelativeDateTimeFormatter.Direction.LAST_2, RelativeDateTimeFormatter.AbsoluteUnit.DAY);
                    }
                }
                formatterCache = CACHED_FORMATTERS;
                synchronized (formatterCache) {
                    str = RelativeDateTimeFormatter.getFormatter(icuLocale, style2, displayContext).format(RelativeDateTimeFormatter.Direction.NEXT_2, RelativeDateTimeFormatter.AbsoluteUnit.DAY);
                }
                if (str != null && !str.isEmpty()) {
                    return str;
                }
            } else if (count == 1) {
                aunit = RelativeDateTimeFormatter.AbsoluteUnit.DAY;
                relative = false;
            } else if (count == 0) {
                aunit = RelativeDateTimeFormatter.AbsoluteUnit.DAY;
                direction = RelativeDateTimeFormatter.Direction.THIS;
                relative = false;
            }
        } else if (minResolution == 604800000L) {
            count = (int)(duration / 604800000L);
            unit2 = RelativeDateTimeFormatter.RelativeUnit.WEEKS;
        } else {
            Calendar timeCalendar = DateUtilsBridge.createIcuCalendar(icuTimeZone, icuLocale, time);
            if ((flags & 0xC) == 0) {
                Calendar nowCalendar = DateUtilsBridge.createIcuCalendar(icuTimeZone, icuLocale, now);
                flags = timeCalendar.get(1) != nowCalendar.get(1) ? (flags |= 4) : (flags |= 8);
            }
            return DateTimeFormat.format(icuLocale, timeCalendar, flags, displayContext);
        }
        FormatterCache formatterCache = CACHED_FORMATTERS;
        synchronized (formatterCache) {
            android.icu.text.RelativeDateTimeFormatter formatter = RelativeDateTimeFormatter.getFormatter(icuLocale, style2, displayContext);
            if (relative) {
                return formatter.format(count, direction, unit2);
            }
            return formatter.format(direction, aunit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRelativeDateTimeString(Locale locale, TimeZone tz, long time, long now, long minResolution, long transitionResolution, int flags) {
        String dateClause;
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        if (tz == null) {
            throw new NullPointerException("tz == null");
        }
        ULocale icuLocale = ULocale.forLocale(locale);
        android.icu.util.TimeZone icuTimeZone = DateUtilsBridge.icuTimeZone(tz);
        long duration = Math.abs(now - time);
        if (transitionResolution > 604800000L) {
            transitionResolution = 604800000L;
        }
        RelativeDateTimeFormatter.Style style2 = (flags & 0xC0000) != 0 ? RelativeDateTimeFormatter.Style.SHORT : RelativeDateTimeFormatter.Style.LONG;
        Calendar timeCalendar = DateUtilsBridge.createIcuCalendar(icuTimeZone, icuLocale, time);
        Calendar nowCalendar = DateUtilsBridge.createIcuCalendar(icuTimeZone, icuLocale, now);
        int days = Math.abs(DateUtilsBridge.dayDistance(timeCalendar, nowCalendar));
        if (duration < transitionResolution) {
            if (days > 0 && minResolution < 86400000L) {
                minResolution = 86400000L;
            }
            dateClause = RelativeDateTimeFormatter.getRelativeTimeSpanString(icuLocale, icuTimeZone, time, now, minResolution, flags, DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE);
        } else {
            flags = timeCalendar.get(1) != nowCalendar.get(1) ? 131092 : 65560;
            dateClause = DateTimeFormat.format(icuLocale, timeCalendar, flags, DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE);
        }
        String timeClause = DateTimeFormat.format(icuLocale, timeCalendar, 1, DisplayContext.CAPITALIZATION_NONE);
        DisplayContext capitalizationContext = DisplayContext.CAPITALIZATION_NONE;
        FormatterCache formatterCache = CACHED_FORMATTERS;
        synchronized (formatterCache) {
            return RelativeDateTimeFormatter.getFormatter(icuLocale, style2, capitalizationContext).combineDateAndTime(dateClause, timeClause);
        }
    }

    private static android.icu.text.RelativeDateTimeFormatter getFormatter(ULocale locale, RelativeDateTimeFormatter.Style style2, DisplayContext displayContext) {
        String key = locale + "\t" + (Object)((Object)style2) + "\t" + (Object)((Object)displayContext);
        android.icu.text.RelativeDateTimeFormatter formatter = (android.icu.text.RelativeDateTimeFormatter)CACHED_FORMATTERS.get(key);
        if (formatter == null) {
            formatter = android.icu.text.RelativeDateTimeFormatter.getInstance(locale, null, style2, displayContext);
            CACHED_FORMATTERS.put(key, formatter);
        }
        return formatter;
    }

    private static int dayDistance(android.icu.util.TimeZone icuTimeZone, long startTime, long endTime) {
        return RelativeDateTimeFormatter.julianDay(icuTimeZone, endTime) - RelativeDateTimeFormatter.julianDay(icuTimeZone, startTime);
    }

    private static int julianDay(android.icu.util.TimeZone icuTimeZone, long time) {
        long utcMs = time + (long)icuTimeZone.getOffset(time);
        return (int)(utcMs / 86400000L) + 2440588;
    }

    static class FormatterCache
    extends LruCache<String, android.icu.text.RelativeDateTimeFormatter> {
        FormatterCache() {
            super(8);
        }
    }
}

