/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.graphics.Rect;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.BaseMovementMethod;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.text.method.WordIterator;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.TextView;

public class ArrowKeyMovementMethod
extends BaseMovementMethod
implements MovementMethod {
    private static final Object LAST_TAP_DOWN = new Object();
    private static ArrowKeyMovementMethod sInstance;

    private static boolean isSelecting(Spannable buffer) {
        return MetaKeyKeyListener.getMetaState((CharSequence)buffer, 1) == 1 || MetaKeyKeyListener.getMetaState((CharSequence)buffer, 2048) != 0;
    }

    private static int getCurrentLineTop(Spannable buffer, Layout layout2) {
        return layout2.getLineTop(layout2.getLineForOffset(Selection.getSelectionEnd(buffer)));
    }

    private static int getPageHeight(TextView widget) {
        Rect rect = new Rect();
        return widget.getGlobalVisibleRect(rect) ? rect.height() : 0;
    }

    @Override
    protected boolean handleMovementKey(TextView widget, Spannable buffer, int keyCode, int movementMetaState, KeyEvent event) {
        switch (keyCode) {
            case 23: {
                if (!KeyEvent.metaStateHasNoModifiers(movementMetaState) || event.getAction() != 0 || event.getRepeatCount() != 0 || MetaKeyKeyListener.getMetaState(buffer, 2048, event) == 0) break;
                return widget.showContextMenu();
            }
        }
        return super.handleMovementKey(widget, buffer, keyCode, movementMetaState, event);
    }

    @Override
    protected boolean left(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        if (ArrowKeyMovementMethod.isSelecting(buffer)) {
            return Selection.extendLeft(buffer, layout2);
        }
        return Selection.moveLeft(buffer, layout2);
    }

    @Override
    protected boolean right(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        if (ArrowKeyMovementMethod.isSelecting(buffer)) {
            return Selection.extendRight(buffer, layout2);
        }
        return Selection.moveRight(buffer, layout2);
    }

    @Override
    protected boolean up(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        if (ArrowKeyMovementMethod.isSelecting(buffer)) {
            return Selection.extendUp(buffer, layout2);
        }
        return Selection.moveUp(buffer, layout2);
    }

    @Override
    protected boolean down(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        if (ArrowKeyMovementMethod.isSelecting(buffer)) {
            return Selection.extendDown(buffer, layout2);
        }
        return Selection.moveDown(buffer, layout2);
    }

    @Override
    protected boolean pageUp(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        boolean selecting = ArrowKeyMovementMethod.isSelecting(buffer);
        int targetY = ArrowKeyMovementMethod.getCurrentLineTop(buffer, layout2) - ArrowKeyMovementMethod.getPageHeight(widget);
        boolean handled = false;
        do {
            int previousSelectionEnd = Selection.getSelectionEnd(buffer);
            if (selecting) {
                Selection.extendUp(buffer, layout2);
            } else {
                Selection.moveUp(buffer, layout2);
            }
            if (Selection.getSelectionEnd(buffer) == previousSelectionEnd) break;
            handled = true;
        } while (ArrowKeyMovementMethod.getCurrentLineTop(buffer, layout2) > targetY);
        return handled;
    }

    @Override
    protected boolean pageDown(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        boolean selecting = ArrowKeyMovementMethod.isSelecting(buffer);
        int targetY = ArrowKeyMovementMethod.getCurrentLineTop(buffer, layout2) + ArrowKeyMovementMethod.getPageHeight(widget);
        boolean handled = false;
        do {
            int previousSelectionEnd = Selection.getSelectionEnd(buffer);
            if (selecting) {
                Selection.extendDown(buffer, layout2);
            } else {
                Selection.moveDown(buffer, layout2);
            }
            if (Selection.getSelectionEnd(buffer) == previousSelectionEnd) break;
            handled = true;
        } while (ArrowKeyMovementMethod.getCurrentLineTop(buffer, layout2) < targetY);
        return handled;
    }

    @Override
    protected boolean top(TextView widget, Spannable buffer) {
        if (ArrowKeyMovementMethod.isSelecting(buffer)) {
            Selection.extendSelection(buffer, 0);
        } else {
            Selection.setSelection(buffer, 0);
        }
        return true;
    }

    @Override
    protected boolean bottom(TextView widget, Spannable buffer) {
        if (ArrowKeyMovementMethod.isSelecting(buffer)) {
            Selection.extendSelection(buffer, buffer.length());
        } else {
            Selection.setSelection(buffer, buffer.length());
        }
        return true;
    }

    @Override
    protected boolean lineStart(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        if (ArrowKeyMovementMethod.isSelecting(buffer)) {
            return Selection.extendToLeftEdge(buffer, layout2);
        }
        return Selection.moveToLeftEdge(buffer, layout2);
    }

    @Override
    protected boolean lineEnd(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        if (ArrowKeyMovementMethod.isSelecting(buffer)) {
            return Selection.extendToRightEdge(buffer, layout2);
        }
        return Selection.moveToRightEdge(buffer, layout2);
    }

    @Override
    protected boolean leftWord(TextView widget, Spannable buffer) {
        int selectionEnd = widget.getSelectionEnd();
        WordIterator wordIterator = widget.getWordIterator();
        wordIterator.setCharSequence(buffer, selectionEnd, selectionEnd);
        return Selection.moveToPreceding(buffer, wordIterator, ArrowKeyMovementMethod.isSelecting(buffer));
    }

    @Override
    protected boolean rightWord(TextView widget, Spannable buffer) {
        int selectionEnd = widget.getSelectionEnd();
        WordIterator wordIterator = widget.getWordIterator();
        wordIterator.setCharSequence(buffer, selectionEnd, selectionEnd);
        return Selection.moveToFollowing(buffer, wordIterator, ArrowKeyMovementMethod.isSelecting(buffer));
    }

    @Override
    protected boolean home(TextView widget, Spannable buffer) {
        return this.lineStart(widget, buffer);
    }

    @Override
    protected boolean end(TextView widget, Spannable buffer) {
        return this.lineEnd(widget, buffer);
    }

    @Override
    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        int initialScrollX = -1;
        int initialScrollY = -1;
        int action2 = event.getAction();
        if (action2 == 1) {
            initialScrollX = Touch.getInitialScrollX(widget, buffer);
            initialScrollY = Touch.getInitialScrollY(widget, buffer);
        }
        boolean wasTouchSelecting = ArrowKeyMovementMethod.isSelecting(buffer);
        boolean handled = Touch.onTouchEvent(widget, buffer, event);
        if (widget.didTouchFocusSelect()) {
            return handled;
        }
        if (action2 == 0) {
            if (ArrowKeyMovementMethod.isSelecting(buffer)) {
                if (!widget.isFocused() && !widget.requestFocus()) {
                    return handled;
                }
                int offset2 = widget.getOffsetForPosition(event.getX(), event.getY());
                buffer.setSpan(LAST_TAP_DOWN, offset2, offset2, 34);
                widget.getParent().requestDisallowInterceptTouchEvent(true);
            }
        } else if (widget.isFocused()) {
            if (action2 == 2) {
                if (ArrowKeyMovementMethod.isSelecting(buffer) && handled) {
                    int startOffset = buffer.getSpanStart(LAST_TAP_DOWN);
                    widget.cancelLongPress();
                    int offset3 = widget.getOffsetForPosition(event.getX(), event.getY());
                    Selection.setSelection(buffer, Math.min(startOffset, offset3), Math.max(startOffset, offset3));
                    return true;
                }
            } else if (action2 == 1) {
                if (initialScrollY >= 0 && initialScrollY != widget.getScrollY() || initialScrollX >= 0 && initialScrollX != widget.getScrollX()) {
                    widget.moveCursorToVisibleOffset();
                    return true;
                }
                if (wasTouchSelecting) {
                    int startOffset = buffer.getSpanStart(LAST_TAP_DOWN);
                    int endOffset = widget.getOffsetForPosition(event.getX(), event.getY());
                    Selection.setSelection(buffer, Math.min(startOffset, endOffset), Math.max(startOffset, endOffset));
                    buffer.removeSpan(LAST_TAP_DOWN);
                }
                MetaKeyKeyListener.adjustMetaAfterKeypress(buffer);
                MetaKeyKeyListener.resetLockedMeta(buffer);
                return true;
            }
        }
        return handled;
    }

    @Override
    public boolean canSelectArbitrarily() {
        return true;
    }

    @Override
    public void initialize(TextView widget, Spannable text) {
        Selection.setSelection(text, 0);
    }

    @Override
    public void onTakeFocus(TextView view2, Spannable text, int dir) {
        if ((dir & 0x82) != 0) {
            if (view2.getLayout() == null) {
                Selection.setSelection(text, text.length());
            }
        } else {
            Selection.setSelection(text, text.length());
        }
    }

    public static MovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new ArrowKeyMovementMethod();
        }
        return sInstance;
    }
}

