/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.compat.annotation.UnsupportedAppUsage;
import android.text.Editable;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.text.Spanned;
import android.view.KeyEvent;
import android.view.View;

public abstract class MetaKeyKeyListener {
    public static final int META_SHIFT_ON = 1;
    public static final int META_ALT_ON = 2;
    public static final int META_SYM_ON = 4;
    public static final int META_CAP_LOCKED = 256;
    public static final int META_ALT_LOCKED = 512;
    public static final int META_SYM_LOCKED = 1024;
    public static final int META_SELECTING = 2048;
    private static final long META_CAP_USED = 0x100000000L;
    private static final long META_ALT_USED = 0x200000000L;
    private static final long META_SYM_USED = 0x400000000L;
    private static final long META_CAP_PRESSED = 0x10000000000L;
    private static final long META_ALT_PRESSED = 0x20000000000L;
    private static final long META_SYM_PRESSED = 0x40000000000L;
    private static final long META_CAP_RELEASED = 0x1000000000000L;
    private static final long META_ALT_RELEASED = 0x2000000000000L;
    private static final long META_SYM_RELEASED = 0x4000000000000L;
    private static final long META_SHIFT_MASK = 0x1010100000101L;
    private static final long META_ALT_MASK = 0x2020200000202L;
    private static final long META_SYM_MASK = 0x4040400000404L;
    private static final Object CAP = new NoCopySpan.Concrete();
    private static final Object ALT = new NoCopySpan.Concrete();
    private static final Object SYM = new NoCopySpan.Concrete();
    private static final Object SELECTING = new NoCopySpan.Concrete();
    private static final int PRESSED_RETURN_VALUE = 1;
    private static final int LOCKED_RETURN_VALUE = 2;
    private static final int PRESSED = 0x1000011;
    private static final int RELEASED = 0x2000011;
    private static final int USED = 0x3000011;
    private static final int LOCKED = 0x4000011;

    public static void resetMetaState(Spannable text) {
        text.removeSpan(CAP);
        text.removeSpan(ALT);
        text.removeSpan(SYM);
        text.removeSpan(SELECTING);
    }

    public static int getMetaState(CharSequence text) {
        return MetaKeyKeyListener.getActive(text, CAP, 1, 256) | MetaKeyKeyListener.getActive(text, ALT, 2, 512) | MetaKeyKeyListener.getActive(text, SYM, 4, 1024) | MetaKeyKeyListener.getActive(text, SELECTING, 2048, 2048);
    }

    public static int getMetaState(CharSequence text, KeyEvent event) {
        int metaState = event.getMetaState();
        if (event.getKeyCharacterMap().getModifierBehavior() == 1) {
            metaState |= MetaKeyKeyListener.getMetaState(text);
        }
        return metaState;
    }

    public static int getMetaState(CharSequence text, int meta) {
        switch (meta) {
            case 1: {
                return MetaKeyKeyListener.getActive(text, CAP, 1, 2);
            }
            case 2: {
                return MetaKeyKeyListener.getActive(text, ALT, 1, 2);
            }
            case 4: {
                return MetaKeyKeyListener.getActive(text, SYM, 1, 2);
            }
            case 2048: {
                return MetaKeyKeyListener.getActive(text, SELECTING, 1, 2);
            }
        }
        return 0;
    }

    public static int getMetaState(CharSequence text, int meta, KeyEvent event) {
        int metaState = event.getMetaState();
        if (event.getKeyCharacterMap().getModifierBehavior() == 1) {
            metaState |= MetaKeyKeyListener.getMetaState(text);
        }
        if (2048 == meta) {
            if ((metaState & 0x800) != 0) {
                return 1;
            }
            return 0;
        }
        return MetaKeyKeyListener.getMetaState(metaState, meta);
    }

    private static int getActive(CharSequence text, Object meta, int on, int lock) {
        if (!(text instanceof Spanned)) {
            return 0;
        }
        Spanned sp = (Spanned)text;
        int flag = sp.getSpanFlags(meta);
        if (flag == 0x4000011) {
            return lock;
        }
        if (flag != 0) {
            return on;
        }
        return 0;
    }

    public static void adjustMetaAfterKeypress(Spannable content2) {
        MetaKeyKeyListener.adjust(content2, CAP);
        MetaKeyKeyListener.adjust(content2, ALT);
        MetaKeyKeyListener.adjust(content2, SYM);
    }

    public static boolean isMetaTracker(CharSequence text, Object what) {
        return what == CAP || what == ALT || what == SYM || what == SELECTING;
    }

    public static boolean isSelectingMetaTracker(CharSequence text, Object what) {
        return what == SELECTING;
    }

    private static void adjust(Spannable content2, Object what) {
        int current = content2.getSpanFlags(what);
        if (current == 0x1000011) {
            content2.setSpan(what, 0, 0, 0x3000011);
        } else if (current == 0x2000011) {
            content2.removeSpan(what);
        }
    }

    protected static void resetLockedMeta(Spannable content2) {
        MetaKeyKeyListener.resetLock(content2, CAP);
        MetaKeyKeyListener.resetLock(content2, ALT);
        MetaKeyKeyListener.resetLock(content2, SYM);
        MetaKeyKeyListener.resetLock(content2, SELECTING);
    }

    private static void resetLock(Spannable content2, Object what) {
        int current = content2.getSpanFlags(what);
        if (current == 0x4000011) {
            content2.removeSpan(what);
        }
    }

    public boolean onKeyDown(View view2, Editable content2, int keyCode, KeyEvent event) {
        if (keyCode == 59 || keyCode == 60) {
            this.press(content2, CAP);
            return true;
        }
        if (keyCode == 57 || keyCode == 58 || keyCode == 78) {
            this.press(content2, ALT);
            return true;
        }
        if (keyCode == 63) {
            this.press(content2, SYM);
            return true;
        }
        return false;
    }

    private void press(Editable content2, Object what) {
        int state = content2.getSpanFlags(what);
        if (state != 0x1000011) {
            if (state == 0x2000011) {
                content2.setSpan(what, 0, 0, 0x4000011);
            } else if (state != 0x3000011) {
                if (state == 0x4000011) {
                    content2.removeSpan(what);
                } else {
                    content2.setSpan(what, 0, 0, 0x1000011);
                }
            }
        }
    }

    @UnsupportedAppUsage
    public static void startSelecting(View view2, Spannable content2) {
        content2.setSpan(SELECTING, 0, 0, 0x1000011);
    }

    @UnsupportedAppUsage
    public static void stopSelecting(View view2, Spannable content2) {
        content2.removeSpan(SELECTING);
    }

    public boolean onKeyUp(View view2, Editable content2, int keyCode, KeyEvent event) {
        if (keyCode == 59 || keyCode == 60) {
            this.release(content2, CAP, event);
            return true;
        }
        if (keyCode == 57 || keyCode == 58 || keyCode == 78) {
            this.release(content2, ALT, event);
            return true;
        }
        if (keyCode == 63) {
            this.release(content2, SYM, event);
            return true;
        }
        return false;
    }

    private void release(Editable content2, Object what, KeyEvent event) {
        int current = content2.getSpanFlags(what);
        switch (event.getKeyCharacterMap().getModifierBehavior()) {
            case 1: {
                if (current == 0x3000011) {
                    content2.removeSpan(what);
                    break;
                }
                if (current != 0x1000011) break;
                content2.setSpan(what, 0, 0, 0x2000011);
                break;
            }
            default: {
                content2.removeSpan(what);
            }
        }
    }

    public void clearMetaKeyState(View view2, Editable content2, int states) {
        MetaKeyKeyListener.clearMetaKeyState(content2, states);
    }

    public static void clearMetaKeyState(Editable content2, int states) {
        if ((states & 1) != 0) {
            content2.removeSpan(CAP);
        }
        if ((states & 2) != 0) {
            content2.removeSpan(ALT);
        }
        if ((states & 4) != 0) {
            content2.removeSpan(SYM);
        }
        if ((states & 0x800) != 0) {
            content2.removeSpan(SELECTING);
        }
    }

    public static long resetLockedMeta(long state) {
        if ((state & 0x100L) != 0L) {
            state &= 0xFFFEFEFEFFFFFEFEL;
        }
        if ((state & 0x200L) != 0L) {
            state &= 0xFFFDFDFDFFFFFDFDL;
        }
        if ((state & 0x400L) != 0L) {
            state &= 0xFFFBFBFBFFFFFBFBL;
        }
        return state;
    }

    public static int getMetaState(long state) {
        int result = 0;
        if ((state & 0x100L) != 0L) {
            result |= 0x100;
        } else if ((state & 1L) != 0L) {
            result |= 1;
        }
        if ((state & 0x200L) != 0L) {
            result |= 0x200;
        } else if ((state & 2L) != 0L) {
            result |= 2;
        }
        if ((state & 0x400L) != 0L) {
            result |= 0x400;
        } else if ((state & 4L) != 0L) {
            result |= 4;
        }
        return result;
    }

    public static int getMetaState(long state, int meta) {
        switch (meta) {
            case 1: {
                if ((state & 0x100L) != 0L) {
                    return 2;
                }
                if ((state & 1L) != 0L) {
                    return 1;
                }
                return 0;
            }
            case 2: {
                if ((state & 0x200L) != 0L) {
                    return 2;
                }
                if ((state & 2L) != 0L) {
                    return 1;
                }
                return 0;
            }
            case 4: {
                if ((state & 0x400L) != 0L) {
                    return 2;
                }
                if ((state & 4L) != 0L) {
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    public static long adjustMetaAfterKeypress(long state) {
        if ((state & 0x10000000000L) != 0L) {
            state = state & 0xFFFEFEFEFFFFFEFEL | 1L | 0x100000000L;
        } else if ((state & 0x1000000000000L) != 0L) {
            state &= 0xFFFEFEFEFFFFFEFEL;
        }
        if ((state & 0x20000000000L) != 0L) {
            state = state & 0xFFFDFDFDFFFFFDFDL | 2L | 0x200000000L;
        } else if ((state & 0x2000000000000L) != 0L) {
            state &= 0xFFFDFDFDFFFFFDFDL;
        }
        if ((state & 0x40000000000L) != 0L) {
            state = state & 0xFFFBFBFBFFFFFBFBL | 4L | 0x400000000L;
        } else if ((state & 0x4000000000000L) != 0L) {
            state &= 0xFFFBFBFBFFFFFBFBL;
        }
        return state;
    }

    public static long handleKeyDown(long state, int keyCode, KeyEvent event) {
        if (keyCode == 59 || keyCode == 60) {
            return MetaKeyKeyListener.press(state, 1, 0x1010100000101L, 256L, 0x10000000000L, 0x1000000000000L, 0x100000000L);
        }
        if (keyCode == 57 || keyCode == 58 || keyCode == 78) {
            return MetaKeyKeyListener.press(state, 2, 0x2020200000202L, 512L, 0x20000000000L, 0x2000000000000L, 0x200000000L);
        }
        if (keyCode == 63) {
            return MetaKeyKeyListener.press(state, 4, 0x4040400000404L, 1024L, 0x40000000000L, 0x4000000000000L, 0x400000000L);
        }
        return state;
    }

    private static long press(long state, int what, long mask, long locked, long pressed, long released, long used) {
        if ((state & pressed) == 0L) {
            if ((state & released) != 0L) {
                state = state & (mask ^ 0xFFFFFFFFFFFFFFFFL) | (long)what | locked;
            } else if ((state & used) == 0L) {
                state = (state & locked) != 0L ? (state &= mask ^ 0xFFFFFFFFFFFFFFFFL) : (state |= (long)what | pressed);
            }
        }
        return state;
    }

    public static long handleKeyUp(long state, int keyCode, KeyEvent event) {
        if (keyCode == 59 || keyCode == 60) {
            return MetaKeyKeyListener.release(state, 1, 0x1010100000101L, 0x10000000000L, 0x1000000000000L, 0x100000000L, event);
        }
        if (keyCode == 57 || keyCode == 58 || keyCode == 78) {
            return MetaKeyKeyListener.release(state, 2, 0x2020200000202L, 0x20000000000L, 0x2000000000000L, 0x200000000L, event);
        }
        if (keyCode == 63) {
            return MetaKeyKeyListener.release(state, 4, 0x4040400000404L, 0x40000000000L, 0x4000000000000L, 0x400000000L, event);
        }
        return state;
    }

    private static long release(long state, int what, long mask, long pressed, long released, long used, KeyEvent event) {
        switch (event.getKeyCharacterMap().getModifierBehavior()) {
            case 1: {
                if ((state & used) != 0L) {
                    state &= mask ^ 0xFFFFFFFFFFFFFFFFL;
                    break;
                }
                if ((state & pressed) == 0L) break;
                state |= (long)what | released;
                break;
            }
            default: {
                state &= mask ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        return state;
    }

    public long clearMetaKeyState(long state, int which) {
        if ((which & 1) != 0 && (state & 0x100L) != 0L) {
            state &= 0xFFFEFEFEFFFFFEFEL;
        }
        if ((which & 2) != 0 && (state & 0x200L) != 0L) {
            state &= 0xFFFDFDFDFFFFFDFDL;
        }
        if ((which & 4) != 0 && (state & 0x400L) != 0L) {
            state &= 0xFFFBFBFBFFFFFBFBL;
        }
        return state;
    }
}

