/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.compat.annotation.UnsupportedAppUsage;
import android.icu.lang.UCharacter;
import android.icu.text.BreakIterator;
import android.text.CharSequenceCharacterIterator;
import android.text.Selection;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.util.Locale;

public class WordIterator
implements Selection.PositionIterator {
    private static final int WINDOW_WIDTH = 50;
    private int mStart;
    private int mEnd;
    private CharSequence mCharSeq;
    private final BreakIterator mIterator;

    public WordIterator() {
        this(AndroidLocale.getDefault());
    }

    @UnsupportedAppUsage
    public WordIterator(Locale locale) {
        this.mIterator = BreakIterator.getWordInstance(locale);
    }

    @UnsupportedAppUsage
    public void setCharSequence(CharSequence charSequence, int start, int end) {
        if (0 > start || end > charSequence.length()) {
            throw new IndexOutOfBoundsException("input indexes are outside the CharSequence");
        }
        this.mCharSeq = charSequence;
        this.mStart = Math.max(0, start - 50);
        this.mEnd = Math.min(charSequence.length(), end + 50);
        this.mIterator.setText(new CharSequenceCharacterIterator(charSequence, this.mStart, this.mEnd));
    }

    @Override
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int preceding(int offset2) {
        this.checkOffsetIsValid(offset2);
        while ((offset2 = this.mIterator.preceding(offset2)) != -1 && !this.isOnLetterOrDigit(offset2)) {
        }
        return offset2;
    }

    @Override
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int following(int offset2) {
        this.checkOffsetIsValid(offset2);
        while ((offset2 = this.mIterator.following(offset2)) != -1 && !this.isAfterLetterOrDigit(offset2)) {
        }
        return offset2;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isBoundary(int offset2) {
        this.checkOffsetIsValid(offset2);
        return this.mIterator.isBoundary(offset2);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int nextBoundary(int offset2) {
        this.checkOffsetIsValid(offset2);
        return this.mIterator.following(offset2);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int prevBoundary(int offset2) {
        this.checkOffsetIsValid(offset2);
        return this.mIterator.preceding(offset2);
    }

    @UnsupportedAppUsage
    public int getBeginning(int offset2) {
        return this.getBeginning(offset2, false);
    }

    @UnsupportedAppUsage
    public int getEnd(int offset2) {
        return this.getEnd(offset2, false);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getPrevWordBeginningOnTwoWordsBoundary(int offset2) {
        return this.getBeginning(offset2, true);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getNextWordEndOnTwoWordBoundary(int offset2) {
        return this.getEnd(offset2, true);
    }

    private int getBeginning(int offset2, boolean getPrevWordBeginningOnTwoWordsBoundary) {
        this.checkOffsetIsValid(offset2);
        if (this.isOnLetterOrDigit(offset2)) {
            if (!(!this.mIterator.isBoundary(offset2) || this.isAfterLetterOrDigit(offset2) && getPrevWordBeginningOnTwoWordsBoundary)) {
                return offset2;
            }
            return this.mIterator.preceding(offset2);
        }
        if (this.isAfterLetterOrDigit(offset2)) {
            return this.mIterator.preceding(offset2);
        }
        return -1;
    }

    private int getEnd(int offset2, boolean getNextWordEndOnTwoWordBoundary) {
        this.checkOffsetIsValid(offset2);
        if (this.isAfterLetterOrDigit(offset2)) {
            if (!(!this.mIterator.isBoundary(offset2) || this.isOnLetterOrDigit(offset2) && getNextWordEndOnTwoWordBoundary)) {
                return offset2;
            }
            return this.mIterator.following(offset2);
        }
        if (this.isOnLetterOrDigit(offset2)) {
            return this.mIterator.following(offset2);
        }
        return -1;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getPunctuationBeginning(int offset2) {
        this.checkOffsetIsValid(offset2);
        while (offset2 != -1 && !this.isPunctuationStartBoundary(offset2)) {
            offset2 = this.prevBoundary(offset2);
        }
        return offset2;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getPunctuationEnd(int offset2) {
        this.checkOffsetIsValid(offset2);
        while (offset2 != -1 && !this.isPunctuationEndBoundary(offset2)) {
            offset2 = this.nextBoundary(offset2);
        }
        return offset2;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isAfterPunctuation(int offset2) {
        if (this.mStart < offset2 && offset2 <= this.mEnd) {
            int codePoint = Character.codePointBefore(this.mCharSeq, offset2);
            return WordIterator.isPunctuation(codePoint);
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isOnPunctuation(int offset2) {
        if (this.mStart <= offset2 && offset2 < this.mEnd) {
            int codePoint = Character.codePointAt(this.mCharSeq, offset2);
            return WordIterator.isPunctuation(codePoint);
        }
        return false;
    }

    public static boolean isMidWordPunctuation(Locale locale, int codePoint) {
        int wb = UCharacter.getIntPropertyValue(codePoint, 4116);
        return wb == 4 || wb == 11 || wb == 15;
    }

    private boolean isPunctuationStartBoundary(int offset2) {
        return this.isOnPunctuation(offset2) && !this.isAfterPunctuation(offset2);
    }

    private boolean isPunctuationEndBoundary(int offset2) {
        return !this.isOnPunctuation(offset2) && this.isAfterPunctuation(offset2);
    }

    private static boolean isPunctuation(int cp) {
        int type = Character.getType(cp);
        return type == 23 || type == 20 || type == 22 || type == 30 || type == 29 || type == 24 || type == 21;
    }

    private boolean isAfterLetterOrDigit(int offset2) {
        int codePoint;
        return this.mStart < offset2 && offset2 <= this.mEnd && Character.isLetterOrDigit(codePoint = Character.codePointBefore(this.mCharSeq, offset2));
    }

    private boolean isOnLetterOrDigit(int offset2) {
        int codePoint;
        return this.mStart <= offset2 && offset2 < this.mEnd && Character.isLetterOrDigit(codePoint = Character.codePointAt(this.mCharSeq, offset2));
    }

    private void checkOffsetIsValid(int offset2) {
        if (this.mStart > offset2 || offset2 > this.mEnd) {
            throw new IllegalArgumentException("Invalid offset: " + offset2 + ". Valid range is [" + this.mStart + ", " + this.mEnd + "]");
        }
    }
}

