/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;

public class IconMarginSpan
implements LeadingMarginSpan,
LineHeightSpan {
    private final Bitmap mBitmap;
    private final int mPad;

    public IconMarginSpan(Bitmap bitmap) {
        this(bitmap, 0);
    }

    public IconMarginSpan(Bitmap bitmap, int pad) {
        this.mBitmap = bitmap;
        this.mPad = pad;
    }

    @Override
    public int getLeadingMargin(boolean first) {
        return this.mBitmap.getWidth() + this.mPad;
    }

    @Override
    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom2, CharSequence text, int start, int end, boolean first, Layout layout2) {
        int st = ((Spanned)text).getSpanStart(this);
        int itop = layout2.getLineTop(layout2.getLineForOffset(st));
        if (dir < 0) {
            x -= this.mBitmap.getWidth();
        }
        c.drawBitmap(this.mBitmap, x, itop, p);
    }

    @Override
    public void chooseHeight(CharSequence text, int start, int end, int istartv, int v, Paint.FontMetricsInt fm) {
        if (end == ((Spanned)text).getSpanEnd(this)) {
            int ht = this.mBitmap.getHeight();
            int need = ht - (v + fm.descent - fm.ascent - istartv);
            if (need > 0) {
                fm.descent += need;
            }
            if ((need = ht - (v + fm.bottom - fm.top - istartv)) > 0) {
                fm.bottom += need;
            }
        }
    }
}

