/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.style.DynamicDrawableSpan;
import android.util.Log;
import java.io.InputStream;

public class ImageSpan
extends DynamicDrawableSpan {
    @UnsupportedAppUsage
    private Drawable mDrawable;
    private Uri mContentUri;
    private int mResourceId;
    private Context mContext;
    private String mSource;

    @Deprecated
    public ImageSpan(Bitmap b) {
        this(null, b, 0);
    }

    @Deprecated
    public ImageSpan(Bitmap b, int verticalAlignment) {
        this(null, b, verticalAlignment);
    }

    public ImageSpan(Context context, Bitmap bitmap) {
        this(context, bitmap, 0);
    }

    public ImageSpan(Context context, Bitmap bitmap, int verticalAlignment) {
        super(verticalAlignment);
        this.mContext = context;
        this.mDrawable = context != null ? new BitmapDrawable(context.getResources(), bitmap) : new BitmapDrawable(bitmap);
        int width2 = this.mDrawable.getIntrinsicWidth();
        int height2 = this.mDrawable.getIntrinsicHeight();
        this.mDrawable.setBounds(0, 0, width2 > 0 ? width2 : 0, height2 > 0 ? height2 : 0);
    }

    public ImageSpan(Drawable drawable2) {
        this(drawable2, 0);
    }

    public ImageSpan(Drawable drawable2, int verticalAlignment) {
        super(verticalAlignment);
        this.mDrawable = drawable2;
    }

    public ImageSpan(Drawable drawable2, String source) {
        this(drawable2, source, 0);
    }

    public ImageSpan(Drawable drawable2, String source, int verticalAlignment) {
        super(verticalAlignment);
        this.mDrawable = drawable2;
        this.mSource = source;
    }

    public ImageSpan(Context context, Uri uri) {
        this(context, uri, 0);
    }

    public ImageSpan(Context context, Uri uri, int verticalAlignment) {
        super(verticalAlignment);
        this.mContext = context;
        this.mContentUri = uri;
        this.mSource = uri.toString();
    }

    public ImageSpan(Context context, int resourceId) {
        this(context, resourceId, 0);
    }

    public ImageSpan(Context context, int resourceId, int verticalAlignment) {
        super(verticalAlignment);
        this.mContext = context;
        this.mResourceId = resourceId;
    }

    @Override
    public Drawable getDrawable() {
        Drawable drawable2 = null;
        if (this.mDrawable != null) {
            drawable2 = this.mDrawable;
        } else if (this.mContentUri != null) {
            Bitmap bitmap = null;
            try {
                InputStream is = this.mContext.getContentResolver().openInputStream(this.mContentUri);
                bitmap = BitmapFactory.decodeStream(is);
                drawable2 = new BitmapDrawable(this.mContext.getResources(), bitmap);
                drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
                is.close();
            }
            catch (Exception e) {
                Log.e("ImageSpan", "Failed to loaded content " + this.mContentUri, e);
            }
        } else {
            try {
                drawable2 = this.mContext.getDrawable(this.mResourceId);
                drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            }
            catch (Exception e) {
                Log.e("ImageSpan", "Unable to find resource: " + this.mResourceId);
            }
        }
        return drawable2;
    }

    public String getSource() {
        return this.mSource;
    }
}

