/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.RectEvaluator;
import android.animation.TypeEvaluator;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.transition.Transition;
import android.transition.TransitionListenerAdapter;
import android.transition.TransitionUtils;
import android.transition.TransitionValues;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;
import java.util.Map;

public class ChangeBounds
extends Transition {
    private static final String PROPNAME_BOUNDS = "android:changeBounds:bounds";
    private static final String PROPNAME_CLIP = "android:changeBounds:clip";
    private static final String PROPNAME_PARENT = "android:changeBounds:parent";
    private static final String PROPNAME_WINDOW_X = "android:changeBounds:windowX";
    private static final String PROPNAME_WINDOW_Y = "android:changeBounds:windowY";
    private static final String[] sTransitionProperties = new String[]{"android:changeBounds:bounds", "android:changeBounds:clip", "android:changeBounds:parent", "android:changeBounds:windowX", "android:changeBounds:windowY"};
    private static final Property<Drawable, PointF> DRAWABLE_ORIGIN_PROPERTY = new Property<Drawable, PointF>(PointF.class, "boundsOrigin"){
        private Rect mBounds = new Rect();

        @Override
        public void set(Drawable object, PointF value2) {
            object.copyBounds(this.mBounds);
            this.mBounds.offsetTo(Math.round(value2.x), Math.round(value2.y));
            object.setBounds(this.mBounds);
        }

        @Override
        public PointF get(Drawable object) {
            object.copyBounds(this.mBounds);
            return new PointF(this.mBounds.left, this.mBounds.top);
        }
    };
    private static final Property<ViewBounds, PointF> TOP_LEFT_PROPERTY = new Property<ViewBounds, PointF>(PointF.class, "topLeft"){

        @Override
        public void set(ViewBounds viewBounds, PointF topLeft) {
            viewBounds.setTopLeft(topLeft);
        }

        @Override
        public PointF get(ViewBounds viewBounds) {
            return null;
        }
    };
    private static final Property<ViewBounds, PointF> BOTTOM_RIGHT_PROPERTY = new Property<ViewBounds, PointF>(PointF.class, "bottomRight"){

        @Override
        public void set(ViewBounds viewBounds, PointF bottomRight) {
            viewBounds.setBottomRight(bottomRight);
        }

        @Override
        public PointF get(ViewBounds viewBounds) {
            return null;
        }
    };
    @UnsupportedAppUsage(maxTargetSdk=28)
    private static final Property<View, PointF> BOTTOM_RIGHT_ONLY_PROPERTY = new Property<View, PointF>(PointF.class, "bottomRight"){

        @Override
        public void set(View view2, PointF bottomRight) {
            int left = view2.getLeft();
            int top = view2.getTop();
            int right2 = Math.round(bottomRight.x);
            int bottom2 = Math.round(bottomRight.y);
            view2.setLeftTopRightBottom(left, top, right2, bottom2);
        }

        @Override
        public PointF get(View view2) {
            return null;
        }
    };
    private static final Property<View, PointF> TOP_LEFT_ONLY_PROPERTY = new Property<View, PointF>(PointF.class, "topLeft"){

        @Override
        public void set(View view2, PointF topLeft) {
            int left = Math.round(topLeft.x);
            int top = Math.round(topLeft.y);
            int right2 = view2.getRight();
            int bottom2 = view2.getBottom();
            view2.setLeftTopRightBottom(left, top, right2, bottom2);
        }

        @Override
        public PointF get(View view2) {
            return null;
        }
    };
    @UnsupportedAppUsage(maxTargetSdk=28)
    private static final Property<View, PointF> POSITION_PROPERTY = new Property<View, PointF>(PointF.class, "position"){

        @Override
        public void set(View view2, PointF topLeft) {
            int left = Math.round(topLeft.x);
            int top = Math.round(topLeft.y);
            int right2 = left + view2.getWidth();
            int bottom2 = top + view2.getHeight();
            view2.setLeftTopRightBottom(left, top, right2, bottom2);
        }

        @Override
        public PointF get(View view2) {
            return null;
        }
    };
    int[] tempLocation = new int[2];
    boolean mResizeClip = false;
    boolean mReparent = false;
    private static final String LOG_TAG = "ChangeBounds";
    private static RectEvaluator sRectEvaluator = new RectEvaluator();

    public ChangeBounds() {
    }

    public ChangeBounds(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ChangeBounds);
        boolean resizeClip = a.getBoolean(0, false);
        a.recycle();
        this.setResizeClip(resizeClip);
    }

    @Override
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    public void setResizeClip(boolean resizeClip) {
        this.mResizeClip = resizeClip;
    }

    public boolean getResizeClip() {
        return this.mResizeClip;
    }

    @Deprecated
    public void setReparent(boolean reparent) {
        this.mReparent = reparent;
    }

    private void captureValues(TransitionValues values2) {
        View view2 = values2.view;
        if (view2.isLaidOut() || view2.getWidth() != 0 || view2.getHeight() != 0) {
            values2.values.put(PROPNAME_BOUNDS, new Rect(view2.getLeft(), view2.getTop(), view2.getRight(), view2.getBottom()));
            values2.values.put(PROPNAME_PARENT, values2.view.getParent());
            if (this.mReparent) {
                values2.view.getLocationInWindow(this.tempLocation);
                values2.values.put(PROPNAME_WINDOW_X, this.tempLocation[0]);
                values2.values.put(PROPNAME_WINDOW_Y, this.tempLocation[1]);
            }
            if (this.mResizeClip) {
                values2.values.put(PROPNAME_CLIP, view2.getClipBounds());
            }
        }
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    private boolean parentMatches(View startParent, View endParent) {
        boolean parentMatches = true;
        if (this.mReparent) {
            TransitionValues endValues = this.getMatchedTransitionValues(startParent, true);
            parentMatches = endValues == null ? startParent == endParent : endParent == endValues.view;
        }
        return parentMatches;
    }

    @Override
    public Animator createAnimator(final ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null || endValues == null) {
            return null;
        }
        Map<String, Object> startParentVals = startValues.values;
        Map<String, Object> endParentVals = endValues.values;
        ViewGroup startParent = (ViewGroup)startParentVals.get(PROPNAME_PARENT);
        ViewGroup endParent = (ViewGroup)endParentVals.get(PROPNAME_PARENT);
        if (startParent == null || endParent == null) {
            return null;
        }
        final View view2 = endValues.view;
        if (this.parentMatches(startParent, endParent)) {
            Rect startBounds = (Rect)startValues.values.get(PROPNAME_BOUNDS);
            Rect endBounds = (Rect)endValues.values.get(PROPNAME_BOUNDS);
            int startLeft = startBounds.left;
            final int endLeft = endBounds.left;
            int startTop = startBounds.top;
            final int endTop = endBounds.top;
            int startRight = startBounds.right;
            final int endRight = endBounds.right;
            int startBottom = startBounds.bottom;
            final int endBottom = endBounds.bottom;
            int startWidth = startRight - startLeft;
            int startHeight = startBottom - startTop;
            int endWidth = endRight - endLeft;
            int endHeight = endBottom - endTop;
            Rect startClip = (Rect)startValues.values.get(PROPNAME_CLIP);
            Rect endClip = (Rect)endValues.values.get(PROPNAME_CLIP);
            int numChanges = 0;
            if (startWidth != 0 && startHeight != 0 || endWidth != 0 && endHeight != 0) {
                if (startLeft != endLeft || startTop != endTop) {
                    ++numChanges;
                }
                if (startRight != endRight || startBottom != endBottom) {
                    ++numChanges;
                }
            }
            if (startClip != null && !startClip.equals(endClip) || startClip == null && endClip != null) {
                ++numChanges;
            }
            if (numChanges > 0) {
                Animator anim2;
                if (view2.getParent() instanceof ViewGroup) {
                    final ViewGroup parent = (ViewGroup)view2.getParent();
                    parent.suppressLayout(true);
                    TransitionListenerAdapter transitionListener = new TransitionListenerAdapter(){
                        boolean mCanceled = false;

                        @Override
                        public void onTransitionCancel(Transition transition2) {
                            parent.suppressLayout(false);
                            this.mCanceled = true;
                        }

                        @Override
                        public void onTransitionEnd(Transition transition2) {
                            if (!this.mCanceled) {
                                parent.suppressLayout(false);
                            }
                            transition2.removeListener(this);
                        }

                        @Override
                        public void onTransitionPause(Transition transition2) {
                            parent.suppressLayout(false);
                        }

                        @Override
                        public void onTransitionResume(Transition transition2) {
                            parent.suppressLayout(true);
                        }
                    };
                    this.addListener(transitionListener);
                }
                if (!this.mResizeClip) {
                    Path topLeftPath;
                    view2.setLeftTopRightBottom(startLeft, startTop, startRight, startBottom);
                    if (numChanges == 2) {
                        if (startWidth == endWidth && startHeight == endHeight) {
                            topLeftPath = this.getPathMotion().getPath(startLeft, startTop, endLeft, endTop);
                            anim2 = ObjectAnimator.ofObject(view2, POSITION_PROPERTY, null, topLeftPath);
                        } else {
                            final ViewBounds viewBounds = new ViewBounds(view2);
                            Path topLeftPath2 = this.getPathMotion().getPath(startLeft, startTop, endLeft, endTop);
                            ObjectAnimator topLeftAnimator = ObjectAnimator.ofObject(viewBounds, TOP_LEFT_PROPERTY, null, topLeftPath2);
                            Path bottomRightPath = this.getPathMotion().getPath(startRight, startBottom, endRight, endBottom);
                            ObjectAnimator bottomRightAnimator = ObjectAnimator.ofObject(viewBounds, BOTTOM_RIGHT_PROPERTY, null, bottomRightPath);
                            AnimatorSet set = new AnimatorSet();
                            set.playTogether(topLeftAnimator, bottomRightAnimator);
                            anim2 = set;
                            set.addListener(new AnimatorListenerAdapter(){
                                private ViewBounds mViewBounds;
                                {
                                    this.mViewBounds = viewBounds;
                                }
                            });
                        }
                    } else if (startLeft != endLeft || startTop != endTop) {
                        topLeftPath = this.getPathMotion().getPath(startLeft, startTop, endLeft, endTop);
                        anim2 = ObjectAnimator.ofObject(view2, TOP_LEFT_ONLY_PROPERTY, null, topLeftPath);
                    } else {
                        Path bottomRight = this.getPathMotion().getPath(startRight, startBottom, endRight, endBottom);
                        anim2 = ObjectAnimator.ofObject(view2, BOTTOM_RIGHT_ONLY_PROPERTY, null, bottomRight);
                    }
                } else {
                    int maxWidth = Math.max(startWidth, endWidth);
                    int maxHeight = Math.max(startHeight, endHeight);
                    view2.setLeftTopRightBottom(startLeft, startTop, startLeft + maxWidth, startTop + maxHeight);
                    ObjectAnimator positionAnimator = null;
                    if (startLeft != endLeft || startTop != endTop) {
                        Path topLeftPath = this.getPathMotion().getPath(startLeft, startTop, endLeft, endTop);
                        positionAnimator = ObjectAnimator.ofObject(view2, POSITION_PROPERTY, null, topLeftPath);
                    }
                    final Rect finalClip = endClip;
                    if (startClip == null) {
                        startClip = new Rect(0, 0, startWidth, startHeight);
                    }
                    if (endClip == null) {
                        endClip = new Rect(0, 0, endWidth, endHeight);
                    }
                    ObjectAnimator clipAnimator = null;
                    if (!startClip.equals(endClip)) {
                        view2.setClipBounds(startClip);
                        clipAnimator = ObjectAnimator.ofObject((Object)view2, "clipBounds", (TypeEvaluator)sRectEvaluator, startClip, endClip);
                        clipAnimator.addListener(new AnimatorListenerAdapter(){
                            private boolean mIsCanceled;

                            @Override
                            public void onAnimationCancel(Animator animation) {
                                this.mIsCanceled = true;
                            }

                            @Override
                            public void onAnimationEnd(Animator animation) {
                                if (!this.mIsCanceled) {
                                    view2.setClipBounds(finalClip);
                                    view2.setLeftTopRightBottom(endLeft, endTop, endRight, endBottom);
                                }
                            }
                        });
                    }
                    anim2 = TransitionUtils.mergeAnimators(positionAnimator, clipAnimator);
                }
                return anim2;
            }
        } else {
            sceneRoot.getLocationInWindow(this.tempLocation);
            int startX = (Integer)startValues.values.get(PROPNAME_WINDOW_X) - this.tempLocation[0];
            int startY = (Integer)startValues.values.get(PROPNAME_WINDOW_Y) - this.tempLocation[1];
            int endX = (Integer)endValues.values.get(PROPNAME_WINDOW_X) - this.tempLocation[0];
            int endY = (Integer)endValues.values.get(PROPNAME_WINDOW_Y) - this.tempLocation[1];
            if (startX != endX || startY != endY) {
                int width2 = view2.getWidth();
                int height2 = view2.getHeight();
                Bitmap bitmap = Bitmap.createBitmap(width2, height2, Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                view2.draw(canvas);
                final BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
                drawable2.setBounds(startX, startY, startX + width2, startY + height2);
                final float transitionAlpha = view2.getTransitionAlpha();
                view2.setTransitionAlpha(0.0f);
                sceneRoot.getOverlay().add(drawable2);
                Path topLeftPath = this.getPathMotion().getPath(startX, startY, endX, endY);
                PropertyValuesHolder origin = PropertyValuesHolder.ofObject(DRAWABLE_ORIGIN_PROPERTY, null, topLeftPath);
                ObjectAnimator anim3 = ObjectAnimator.ofPropertyValuesHolder(drawable2, origin);
                anim3.addListener(new AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        sceneRoot.getOverlay().remove(drawable2);
                        view2.setTransitionAlpha(transitionAlpha);
                    }
                });
                return anim3;
            }
        }
        return null;
    }

    private static class ViewBounds {
        private int mLeft;
        private int mTop;
        private int mRight;
        private int mBottom;
        private View mView;
        private int mTopLeftCalls;
        private int mBottomRightCalls;

        public ViewBounds(View view2) {
            this.mView = view2;
        }

        public void setTopLeft(PointF topLeft) {
            this.mLeft = Math.round(topLeft.x);
            this.mTop = Math.round(topLeft.y);
            ++this.mTopLeftCalls;
            if (this.mTopLeftCalls == this.mBottomRightCalls) {
                this.setLeftTopRightBottom();
            }
        }

        public void setBottomRight(PointF bottomRight) {
            this.mRight = Math.round(bottomRight.x);
            this.mBottom = Math.round(bottomRight.y);
            ++this.mBottomRightCalls;
            if (this.mTopLeftCalls == this.mBottomRightCalls) {
                this.setLeftTopRightBottom();
            }
        }

        private void setLeftTopRightBottom() {
            this.mView.setLeftTopRightBottom(this.mLeft, this.mTop, this.mRight, this.mBottom);
            this.mTopLeftCalls = 0;
            this.mBottomRightCalls = 0;
        }
    }
}

