/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Rect;
import android.transition.CircularPropagation;
import android.transition.TransitionValues;
import android.transition.TranslationAnimationCreator;
import android.transition.Visibility;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;

public class Explode
extends Visibility {
    private static final TimeInterpolator sDecelerate = new DecelerateInterpolator();
    private static final TimeInterpolator sAccelerate = new AccelerateInterpolator();
    private static final String TAG = "Explode";
    private static final String PROPNAME_SCREEN_BOUNDS = "android:explode:screenBounds";
    private int[] mTempLoc = new int[2];

    public Explode() {
        this.setPropagation(new CircularPropagation());
    }

    public Explode(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setPropagation(new CircularPropagation());
    }

    private void captureValues(TransitionValues transitionValues) {
        View view2 = transitionValues.view;
        view2.getLocationOnScreen(this.mTempLoc);
        int left = this.mTempLoc[0];
        int top = this.mTempLoc[1];
        int right2 = left + view2.getWidth();
        int bottom2 = top + view2.getHeight();
        transitionValues.values.put(PROPNAME_SCREEN_BOUNDS, new Rect(left, top, right2, bottom2));
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        super.captureEndValues(transitionValues);
        this.captureValues(transitionValues);
    }

    @Override
    public Animator onAppear(ViewGroup sceneRoot, View view2, TransitionValues startValues, TransitionValues endValues) {
        if (endValues == null) {
            return null;
        }
        Rect bounds2 = (Rect)endValues.values.get(PROPNAME_SCREEN_BOUNDS);
        float endX = view2.getTranslationX();
        float endY = view2.getTranslationY();
        this.calculateOut(sceneRoot, bounds2, this.mTempLoc);
        float startX = endX + (float)this.mTempLoc[0];
        float startY = endY + (float)this.mTempLoc[1];
        return TranslationAnimationCreator.createAnimation(view2, endValues, bounds2.left, bounds2.top, startX, startY, endX, endY, sDecelerate, this);
    }

    @Override
    public Animator onDisappear(ViewGroup sceneRoot, View view2, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null) {
            return null;
        }
        Rect bounds2 = (Rect)startValues.values.get(PROPNAME_SCREEN_BOUNDS);
        int viewPosX = bounds2.left;
        int viewPosY = bounds2.top;
        float startX = view2.getTranslationX();
        float startY = view2.getTranslationY();
        float endX = startX;
        float endY = startY;
        int[] interruptedPosition = (int[])startValues.view.getTag(16909639);
        if (interruptedPosition != null) {
            endX += (float)(interruptedPosition[0] - bounds2.left);
            endY += (float)(interruptedPosition[1] - bounds2.top);
            bounds2.offsetTo(interruptedPosition[0], interruptedPosition[1]);
        }
        this.calculateOut(sceneRoot, bounds2, this.mTempLoc);
        return TranslationAnimationCreator.createAnimation(view2, startValues, viewPosX, viewPosY, startX, startY, endX += (float)this.mTempLoc[0], endY += (float)this.mTempLoc[1], sAccelerate, this);
    }

    private void calculateOut(View sceneRoot, Rect bounds2, int[] outVector) {
        int focalY;
        int focalX;
        sceneRoot.getLocationOnScreen(this.mTempLoc);
        int sceneRootX = this.mTempLoc[0];
        int sceneRootY = this.mTempLoc[1];
        Rect epicenter = this.getEpicenter();
        if (epicenter == null) {
            focalX = sceneRootX + sceneRoot.getWidth() / 2 + Math.round(sceneRoot.getTranslationX());
            focalY = sceneRootY + sceneRoot.getHeight() / 2 + Math.round(sceneRoot.getTranslationY());
        } else {
            focalX = epicenter.centerX();
            focalY = epicenter.centerY();
        }
        int centerX = bounds2.centerX();
        int centerY = bounds2.centerY();
        double xVector = centerX - focalX;
        double yVector = centerY - focalY;
        if (xVector == 0.0 && yVector == 0.0) {
            xVector = Math.random() * 2.0 - 1.0;
            yVector = Math.random() * 2.0 - 1.0;
        }
        double vectorSize = Math.hypot(xVector, yVector);
        double maxDistance = Explode.calculateMaxDistance(sceneRoot, focalX - sceneRootX, focalY - sceneRootY);
        outVector[0] = (int)Math.round(maxDistance * (xVector /= vectorSize));
        outVector[1] = (int)Math.round(maxDistance * (yVector /= vectorSize));
    }

    private static double calculateMaxDistance(View sceneRoot, int focalX, int focalY) {
        int maxX = Math.max(focalX, sceneRoot.getWidth() - focalX);
        int maxY = Math.max(focalY, sceneRoot.getHeight() - focalY);
        return Math.hypot(maxX, maxY);
    }
}

