/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class Recolor
extends Transition {
    private static final String PROPNAME_BACKGROUND = "android:recolor:background";
    private static final String PROPNAME_TEXT_COLOR = "android:recolor:textColor";

    public Recolor() {
    }

    public Recolor(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    private void captureValues(TransitionValues transitionValues) {
        transitionValues.values.put(PROPNAME_BACKGROUND, transitionValues.view.getBackground());
        if (transitionValues.view instanceof TextView) {
            transitionValues.values.put(PROPNAME_TEXT_COLOR, ((TextView)transitionValues.view).getCurrentTextColor());
        }
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null || endValues == null) {
            return null;
        }
        View view2 = endValues.view;
        Drawable startBackground = (Drawable)startValues.values.get(PROPNAME_BACKGROUND);
        Drawable endBackground = (Drawable)endValues.values.get(PROPNAME_BACKGROUND);
        boolean changed = false;
        if (startBackground instanceof ColorDrawable && endBackground instanceof ColorDrawable) {
            ColorDrawable startColor = (ColorDrawable)startBackground;
            ColorDrawable endColor = (ColorDrawable)endBackground;
            if (startColor.getColor() != endColor.getColor()) {
                endColor.setColor(startColor.getColor());
                changed = true;
                return ObjectAnimator.ofArgb(endBackground, "color", startColor.getColor(), endColor.getColor());
            }
        }
        if (view2 instanceof TextView) {
            int end;
            TextView textView = (TextView)view2;
            int start = (Integer)startValues.values.get(PROPNAME_TEXT_COLOR);
            if (start != (end = ((Integer)endValues.values.get(PROPNAME_TEXT_COLOR)).intValue())) {
                textView.setTextColor(end);
                changed = true;
                return ObjectAnimator.ofArgb(textView, "textColor", start, end);
            }
        }
        return null;
    }
}

