/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.transition.SidePropagation;
import android.transition.TransitionValues;
import android.transition.TranslationAnimationCreator;
import android.transition.Visibility;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.android.internal.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Slide
extends Visibility {
    private static final String TAG = "Slide";
    private static final TimeInterpolator sDecelerate = new DecelerateInterpolator();
    private static final TimeInterpolator sAccelerate = new AccelerateInterpolator();
    private static final String PROPNAME_SCREEN_POSITION = "android:slide:screenPosition";
    private CalculateSlide mSlideCalculator = sCalculateBottom;
    private int mSlideEdge = 80;
    private float mSlideFraction = 1.0f;
    private static final CalculateSlide sCalculateLeft = new CalculateSlideHorizontal(){

        @Override
        public float getGoneX(ViewGroup sceneRoot, View view2, float fraction2) {
            return view2.getTranslationX() - (float)sceneRoot.getWidth() * fraction2;
        }
    };
    private static final CalculateSlide sCalculateStart = new CalculateSlideHorizontal(){

        @Override
        public float getGoneX(ViewGroup sceneRoot, View view2, float fraction2) {
            boolean isRtl = sceneRoot.getLayoutDirection() == 1;
            float x = isRtl ? view2.getTranslationX() + (float)sceneRoot.getWidth() * fraction2 : view2.getTranslationX() - (float)sceneRoot.getWidth() * fraction2;
            return x;
        }
    };
    private static final CalculateSlide sCalculateTop = new CalculateSlideVertical(){

        @Override
        public float getGoneY(ViewGroup sceneRoot, View view2, float fraction2) {
            return view2.getTranslationY() - (float)sceneRoot.getHeight() * fraction2;
        }
    };
    private static final CalculateSlide sCalculateRight = new CalculateSlideHorizontal(){

        @Override
        public float getGoneX(ViewGroup sceneRoot, View view2, float fraction2) {
            return view2.getTranslationX() + (float)sceneRoot.getWidth() * fraction2;
        }
    };
    private static final CalculateSlide sCalculateEnd = new CalculateSlideHorizontal(){

        @Override
        public float getGoneX(ViewGroup sceneRoot, View view2, float fraction2) {
            boolean isRtl = sceneRoot.getLayoutDirection() == 1;
            float x = isRtl ? view2.getTranslationX() - (float)sceneRoot.getWidth() * fraction2 : view2.getTranslationX() + (float)sceneRoot.getWidth() * fraction2;
            return x;
        }
    };
    private static final CalculateSlide sCalculateBottom = new CalculateSlideVertical(){

        @Override
        public float getGoneY(ViewGroup sceneRoot, View view2, float fraction2) {
            return view2.getTranslationY() + (float)sceneRoot.getHeight() * fraction2;
        }
    };

    public Slide() {
        this.setSlideEdge(80);
    }

    public Slide(int slideEdge) {
        this.setSlideEdge(slideEdge);
    }

    public Slide(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Slide);
        int edge = a.getInt(0, 80);
        a.recycle();
        this.setSlideEdge(edge);
    }

    private void captureValues(TransitionValues transitionValues) {
        View view2 = transitionValues.view;
        int[] position = new int[2];
        view2.getLocationOnScreen(position);
        transitionValues.values.put(PROPNAME_SCREEN_POSITION, position);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        super.captureEndValues(transitionValues);
        this.captureValues(transitionValues);
    }

    public void setSlideEdge(int slideEdge) {
        switch (slideEdge) {
            case 3: {
                this.mSlideCalculator = sCalculateLeft;
                break;
            }
            case 48: {
                this.mSlideCalculator = sCalculateTop;
                break;
            }
            case 5: {
                this.mSlideCalculator = sCalculateRight;
                break;
            }
            case 80: {
                this.mSlideCalculator = sCalculateBottom;
                break;
            }
            case 0x800003: {
                this.mSlideCalculator = sCalculateStart;
                break;
            }
            case 0x800005: {
                this.mSlideCalculator = sCalculateEnd;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid slide direction");
            }
        }
        this.mSlideEdge = slideEdge;
        SidePropagation propagation = new SidePropagation();
        propagation.setSide(slideEdge);
        this.setPropagation(propagation);
    }

    public int getSlideEdge() {
        return this.mSlideEdge;
    }

    @Override
    public Animator onAppear(ViewGroup sceneRoot, View view2, TransitionValues startValues, TransitionValues endValues) {
        if (endValues == null) {
            return null;
        }
        int[] position = (int[])endValues.values.get(PROPNAME_SCREEN_POSITION);
        float endX = view2.getTranslationX();
        float endY = view2.getTranslationY();
        float startX = this.mSlideCalculator.getGoneX(sceneRoot, view2, this.mSlideFraction);
        float startY = this.mSlideCalculator.getGoneY(sceneRoot, view2, this.mSlideFraction);
        return TranslationAnimationCreator.createAnimation(view2, endValues, position[0], position[1], startX, startY, endX, endY, sDecelerate, this);
    }

    @Override
    public Animator onDisappear(ViewGroup sceneRoot, View view2, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null) {
            return null;
        }
        int[] position = (int[])startValues.values.get(PROPNAME_SCREEN_POSITION);
        float startX = view2.getTranslationX();
        float startY = view2.getTranslationY();
        float endX = this.mSlideCalculator.getGoneX(sceneRoot, view2, this.mSlideFraction);
        float endY = this.mSlideCalculator.getGoneY(sceneRoot, view2, this.mSlideFraction);
        return TranslationAnimationCreator.createAnimation(view2, startValues, position[0], position[1], startX, startY, endX, endY, sAccelerate, this);
    }

    public void setSlideFraction(float slideFraction) {
        this.mSlideFraction = slideFraction;
    }

    private static abstract class CalculateSlideVertical
    implements CalculateSlide {
        private CalculateSlideVertical() {
        }

        @Override
        public float getGoneX(ViewGroup sceneRoot, View view2, float fraction2) {
            return view2.getTranslationX();
        }
    }

    private static abstract class CalculateSlideHorizontal
    implements CalculateSlide {
        private CalculateSlideHorizontal() {
        }

        @Override
        public float getGoneY(ViewGroup sceneRoot, View view2, float fraction2) {
            return view2.getTranslationY();
        }
    }

    private static interface CalculateSlide {
        public float getGoneX(ViewGroup var1, View var2, float var3);

        public float getGoneY(ViewGroup var1, View var2, float var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GravityFlag {
    }
}

