/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.compat.annotation.UnsupportedAppUsage;
import android.transition.AutoTransition;
import android.transition.Scene;
import android.transition.Transition;
import android.transition.TransitionListenerAdapter;
import android.util.ArrayMap;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class TransitionManager {
    private static String LOG_TAG = "TransitionManager";
    private static Transition sDefaultTransition = new AutoTransition();
    private static final String[] EMPTY_STRINGS = new String[0];
    ArrayMap<Scene, Transition> mSceneTransitions = new ArrayMap();
    ArrayMap<Scene, ArrayMap<Scene, Transition>> mScenePairTransitions = new ArrayMap();
    @UnsupportedAppUsage
    private static ThreadLocal<WeakReference<ArrayMap<ViewGroup, ArrayList<Transition>>>> sRunningTransitions = new ThreadLocal();
    @UnsupportedAppUsage
    private static ArrayList<ViewGroup> sPendingTransitions = new ArrayList();

    public void setDefaultTransition(Transition transition2) {
        sDefaultTransition = transition2;
    }

    public static Transition getDefaultTransition() {
        return sDefaultTransition;
    }

    public void setTransition(Scene scene, Transition transition2) {
        this.mSceneTransitions.put(scene, transition2);
    }

    public void setTransition(Scene fromScene, Scene toScene, Transition transition2) {
        ArrayMap<Scene, Transition> sceneTransitionMap = this.mScenePairTransitions.get(toScene);
        if (sceneTransitionMap == null) {
            sceneTransitionMap = new ArrayMap();
            this.mScenePairTransitions.put(toScene, sceneTransitionMap);
        }
        sceneTransitionMap.put(fromScene, transition2);
    }

    public Transition getTransition(Scene scene) {
        ArrayMap<Scene, Transition> sceneTransitionMap;
        Scene currScene;
        Transition transition2 = null;
        ViewGroup sceneRoot = scene.getSceneRoot();
        if (sceneRoot != null && (currScene = Scene.getCurrentScene(sceneRoot)) != null && (sceneTransitionMap = this.mScenePairTransitions.get(scene)) != null && (transition2 = sceneTransitionMap.get(currScene)) != null) {
            return transition2;
        }
        transition2 = this.mSceneTransitions.get(scene);
        return transition2 != null ? transition2 : sDefaultTransition;
    }

    private static void changeScene(Scene scene, Transition transition2) {
        ViewGroup sceneRoot = scene.getSceneRoot();
        if (!sPendingTransitions.contains(sceneRoot)) {
            Scene oldScene = Scene.getCurrentScene(sceneRoot);
            if (transition2 == null) {
                if (oldScene != null) {
                    oldScene.exit();
                }
                scene.enter();
            } else {
                sPendingTransitions.add(sceneRoot);
                Transition transitionClone = transition2.clone();
                transitionClone.setSceneRoot(sceneRoot);
                if (oldScene != null && oldScene.isCreatedFromLayoutResource()) {
                    transitionClone.setCanRemoveViews(true);
                }
                TransitionManager.sceneChangeSetup(sceneRoot, transitionClone);
                scene.enter();
                TransitionManager.sceneChangeRunTransition(sceneRoot, transitionClone);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static ArrayMap<ViewGroup, ArrayList<Transition>> getRunningTransitions() {
        ArrayMap<ViewGroup, ArrayList<Transition>> transitions2;
        WeakReference<ArrayMap<ViewGroup, ArrayList<Transition>>> runningTransitions = sRunningTransitions.get();
        if (runningTransitions != null && (transitions2 = (ArrayMap<ViewGroup, ArrayList<Transition>>)runningTransitions.get()) != null) {
            return transitions2;
        }
        transitions2 = new ArrayMap<ViewGroup, ArrayList<Transition>>();
        runningTransitions = new WeakReference<ArrayMap<ViewGroup, ArrayList<Transition>>>(transitions2);
        sRunningTransitions.set(runningTransitions);
        return transitions2;
    }

    private static void sceneChangeRunTransition(ViewGroup sceneRoot, Transition transition2) {
        if (transition2 != null && sceneRoot != null) {
            MultiListener listener2 = new MultiListener(transition2, sceneRoot);
            sceneRoot.addOnAttachStateChangeListener(listener2);
            sceneRoot.getViewTreeObserver().addOnPreDrawListener(listener2);
        }
    }

    private static void sceneChangeSetup(ViewGroup sceneRoot, Transition transition2) {
        Scene previousScene;
        ArrayList<Transition> runningTransitions = TransitionManager.getRunningTransitions().get(sceneRoot);
        if (runningTransitions != null && runningTransitions.size() > 0) {
            for (Transition runningTransition : runningTransitions) {
                runningTransition.pause(sceneRoot);
            }
        }
        if (transition2 != null) {
            transition2.captureValues(sceneRoot, true);
        }
        if ((previousScene = Scene.getCurrentScene(sceneRoot)) != null) {
            previousScene.exit();
        }
    }

    public void transitionTo(Scene scene) {
        TransitionManager.changeScene(scene, this.getTransition(scene));
    }

    public static void go(Scene scene) {
        TransitionManager.changeScene(scene, sDefaultTransition);
    }

    public static void go(Scene scene, Transition transition2) {
        TransitionManager.changeScene(scene, transition2);
    }

    public static void beginDelayedTransition(ViewGroup sceneRoot) {
        TransitionManager.beginDelayedTransition(sceneRoot, null);
    }

    public static void beginDelayedTransition(ViewGroup sceneRoot, Transition transition2) {
        if (!sPendingTransitions.contains(sceneRoot) && sceneRoot.isLaidOut()) {
            sPendingTransitions.add(sceneRoot);
            if (transition2 == null) {
                transition2 = sDefaultTransition;
            }
            Transition transitionClone = transition2.clone();
            TransitionManager.sceneChangeSetup(sceneRoot, transitionClone);
            Scene.setCurrentScene(sceneRoot, null);
            TransitionManager.sceneChangeRunTransition(sceneRoot, transitionClone);
        }
    }

    public static void endTransitions(ViewGroup sceneRoot) {
        sPendingTransitions.remove(sceneRoot);
        ArrayList<Transition> runningTransitions = TransitionManager.getRunningTransitions().get(sceneRoot);
        if (runningTransitions != null && !runningTransitions.isEmpty()) {
            ArrayList<Transition> copy = new ArrayList<Transition>(runningTransitions);
            for (int i = copy.size() - 1; i >= 0; --i) {
                Transition transition2 = copy.get(i);
                transition2.forceToEnd(sceneRoot);
            }
        }
    }

    private static class MultiListener
    implements ViewTreeObserver.OnPreDrawListener,
    View.OnAttachStateChangeListener {
        Transition mTransition;
        ViewGroup mSceneRoot;
        final ViewTreeObserver mViewTreeObserver;

        MultiListener(Transition transition2, ViewGroup sceneRoot) {
            this.mTransition = transition2;
            this.mSceneRoot = sceneRoot;
            this.mViewTreeObserver = this.mSceneRoot.getViewTreeObserver();
        }

        private void removeListeners() {
            if (this.mViewTreeObserver.isAlive()) {
                this.mViewTreeObserver.removeOnPreDrawListener(this);
            } else {
                this.mSceneRoot.getViewTreeObserver().removeOnPreDrawListener(this);
            }
            this.mSceneRoot.removeOnAttachStateChangeListener(this);
        }

        @Override
        public void onViewAttachedToWindow(View v) {
        }

        @Override
        public void onViewDetachedFromWindow(View v) {
            this.removeListeners();
            sPendingTransitions.remove(this.mSceneRoot);
            ArrayList<Transition> runningTransitions = TransitionManager.getRunningTransitions().get(this.mSceneRoot);
            if (runningTransitions != null && runningTransitions.size() > 0) {
                for (Transition runningTransition : runningTransitions) {
                    runningTransition.resume(this.mSceneRoot);
                }
            }
            this.mTransition.clearValues(true);
        }

        @Override
        public boolean onPreDraw() {
            this.removeListeners();
            if (!sPendingTransitions.remove(this.mSceneRoot)) {
                return true;
            }
            final ArrayMap<ViewGroup, ArrayList<Transition>> runningTransitions = TransitionManager.getRunningTransitions();
            ArrayList<Transition> currentTransitions = runningTransitions.get(this.mSceneRoot);
            ArrayList<Transition> previousRunningTransitions = null;
            if (currentTransitions == null) {
                currentTransitions = new ArrayList();
                runningTransitions.put(this.mSceneRoot, currentTransitions);
            } else if (currentTransitions.size() > 0) {
                previousRunningTransitions = new ArrayList<Transition>(currentTransitions);
            }
            currentTransitions.add(this.mTransition);
            this.mTransition.addListener(new TransitionListenerAdapter(){

                @Override
                public void onTransitionEnd(Transition transition2) {
                    ArrayList currentTransitions = (ArrayList)runningTransitions.get(mSceneRoot);
                    currentTransitions.remove(transition2);
                    transition2.removeListener(this);
                }
            });
            this.mTransition.captureValues(this.mSceneRoot, false);
            if (previousRunningTransitions != null) {
                for (Transition runningTransition : previousRunningTransitions) {
                    runningTransition.resume(this.mSceneRoot);
                }
            }
            this.mTransition.playTransition(this.mSceneRoot);
            return true;
        }
    }
}

