/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.transition.TransitionPropagation;
import android.transition.TransitionValues;
import android.view.View;

public abstract class VisibilityPropagation
extends TransitionPropagation {
    private static final String PROPNAME_VISIBILITY = "android:visibilityPropagation:visibility";
    private static final String PROPNAME_VIEW_CENTER = "android:visibilityPropagation:center";
    private static final String[] VISIBILITY_PROPAGATION_VALUES = new String[]{"android:visibilityPropagation:visibility", "android:visibilityPropagation:center"};

    @Override
    public void captureValues(TransitionValues values2) {
        View view2 = values2.view;
        Integer visibility = (Integer)values2.values.get("android:visibility:visibility");
        if (visibility == null) {
            visibility = view2.getVisibility();
        }
        values2.values.put(PROPNAME_VISIBILITY, visibility);
        int[] loc = new int[2];
        view2.getLocationOnScreen(loc);
        loc[0] = loc[0] + Math.round(view2.getTranslationX());
        loc[0] = loc[0] + view2.getWidth() / 2;
        loc[1] = loc[1] + Math.round(view2.getTranslationY());
        loc[1] = loc[1] + view2.getHeight() / 2;
        values2.values.put(PROPNAME_VIEW_CENTER, loc);
    }

    @Override
    public String[] getPropagationProperties() {
        return VISIBILITY_PROPAGATION_VALUES;
    }

    public int getViewVisibility(TransitionValues values2) {
        if (values2 == null) {
            return 8;
        }
        Integer visibility = (Integer)values2.values.get(PROPNAME_VISIBILITY);
        if (visibility == null) {
            return 8;
        }
        return visibility;
    }

    public int getViewX(TransitionValues values2) {
        return VisibilityPropagation.getViewCoordinate(values2, 0);
    }

    public int getViewY(TransitionValues values2) {
        return VisibilityPropagation.getViewCoordinate(values2, 1);
    }

    private static int getViewCoordinate(TransitionValues values2, int coordinateIndex) {
        if (values2 == null) {
            return -1;
        }
        int[] coordinates = (int[])values2.values.get(PROPNAME_VIEW_CENTER);
        if (coordinates == null) {
            return -1;
        }
        return coordinates[coordinateIndex];
    }
}

