/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.compat.annotation.UnsupportedAppUsage;
import android.util.ContainerHelpers;
import android.util.MapCollections;
import android.util.Slog;
import android.util.UtilConfig;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import libcore.util.EmptyArray;

public class ArraySet<E>
implements Collection<E>,
Set<E> {
    private static final boolean DEBUG = false;
    private static final String TAG = "ArraySet";
    private static final int BASE_SIZE = 4;
    private static final int CACHE_SIZE = 10;
    static Object[] sBaseCache;
    static int sBaseCacheSize;
    static Object[] sTwiceBaseCache;
    static int sTwiceBaseCacheSize;
    private static final Object sBaseCacheLock;
    private static final Object sTwiceBaseCacheLock;
    private final boolean mIdentityHashCode;
    @UnsupportedAppUsage(maxTargetSdk=28)
    int[] mHashes;
    @UnsupportedAppUsage(maxTargetSdk=28)
    Object[] mArray;
    @UnsupportedAppUsage(maxTargetSdk=28)
    int mSize;
    private MapCollections<E, E> mCollections;

    private int binarySearch(int[] hashes, int hash2) {
        try {
            return ContainerHelpers.binarySearch(hashes, this.mSize, hash2);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ConcurrentModificationException();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    private int indexOf(Object key, int hash2) {
        int end;
        int N = this.mSize;
        if (N == 0) {
            return -1;
        }
        int index = this.binarySearch(this.mHashes, hash2);
        if (index < 0) {
            return index;
        }
        if (key.equals(this.mArray[index])) {
            return index;
        }
        for (end = index + 1; end < N && this.mHashes[end] == hash2; ++end) {
            if (!key.equals(this.mArray[end])) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.mHashes[i] == hash2; --i) {
            if (!key.equals(this.mArray[i])) continue;
            return i;
        }
        return ~end;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    private int indexOfNull() {
        int end;
        int N = this.mSize;
        if (N == 0) {
            return -1;
        }
        int index = this.binarySearch(this.mHashes, 0);
        if (index < 0) {
            return index;
        }
        if (null == this.mArray[index]) {
            return index;
        }
        for (end = index + 1; end < N && this.mHashes[end] == 0; ++end) {
            if (null != this.mArray[end]) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.mHashes[i] == 0; --i) {
            if (null != this.mArray[i]) continue;
            return i;
        }
        return ~end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28)
    private void allocArrays(int size) {
        if (size == 8) {
            Object object = sTwiceBaseCacheLock;
            synchronized (object) {
                if (sTwiceBaseCache != null) {
                    Object[] array2 = sTwiceBaseCache;
                    try {
                        this.mArray = array2;
                        sTwiceBaseCache = (Object[])array2[0];
                        this.mHashes = (int[])array2[1];
                        if (this.mHashes != null) {
                            array2[1] = null;
                            array2[0] = null;
                            --sTwiceBaseCacheSize;
                            return;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    Slog.wtf(TAG, "Found corrupt ArraySet cache: [0]=" + array2[0] + " [1]=" + array2[1]);
                    sTwiceBaseCache = null;
                    sTwiceBaseCacheSize = 0;
                }
            }
        }
        if (size == 4) {
            Object object = sBaseCacheLock;
            synchronized (object) {
                if (sBaseCache != null) {
                    Object[] array3 = sBaseCache;
                    try {
                        this.mArray = array3;
                        sBaseCache = (Object[])array3[0];
                        this.mHashes = (int[])array3[1];
                        if (this.mHashes != null) {
                            array3[1] = null;
                            array3[0] = null;
                            --sBaseCacheSize;
                            return;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    Slog.wtf(TAG, "Found corrupt ArraySet cache: [0]=" + array3[0] + " [1]=" + array3[1]);
                    sBaseCache = null;
                    sBaseCacheSize = 0;
                }
            }
        }
        this.mHashes = new int[size];
        this.mArray = new Object[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28)
    private static void freeArrays(int[] hashes, Object[] array2, int size) {
        if (hashes.length == 8) {
            Object object = sTwiceBaseCacheLock;
            synchronized (object) {
                if (sTwiceBaseCacheSize < 10) {
                    array2[0] = sTwiceBaseCache;
                    array2[1] = hashes;
                    for (int i = size - 1; i >= 2; --i) {
                        array2[i] = null;
                    }
                    sTwiceBaseCache = array2;
                    ++sTwiceBaseCacheSize;
                }
            }
        }
        if (hashes.length == 4) {
            Object object = sBaseCacheLock;
            synchronized (object) {
                if (sBaseCacheSize < 10) {
                    array2[0] = sBaseCache;
                    array2[1] = hashes;
                    for (int i = size - 1; i >= 2; --i) {
                        array2[i] = null;
                    }
                    sBaseCache = array2;
                    ++sBaseCacheSize;
                }
            }
        }
    }

    public ArraySet() {
        this(0, false);
    }

    public ArraySet(int capacity) {
        this(capacity, false);
    }

    public ArraySet(int capacity, boolean identityHashCode) {
        this.mIdentityHashCode = identityHashCode;
        if (capacity == 0) {
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
        } else {
            this.allocArrays(capacity);
        }
        this.mSize = 0;
    }

    public ArraySet(ArraySet<E> set) {
        this();
        if (set != null) {
            this.addAll(set);
        }
    }

    public ArraySet(Collection<? extends E> set) {
        this();
        if (set != null) {
            this.addAll(set);
        }
    }

    public ArraySet(E[] array2) {
        this();
        if (array2 != null) {
            for (E value2 : array2) {
                this.add(value2);
            }
        }
    }

    @Override
    public void clear() {
        if (this.mSize != 0) {
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            int osize = this.mSize;
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
            this.mSize = 0;
            ArraySet.freeArrays(ohashes, oarray, osize);
        }
        if (this.mSize != 0) {
            throw new ConcurrentModificationException();
        }
    }

    public void ensureCapacity(int minimumCapacity) {
        int oSize = this.mSize;
        if (this.mHashes.length < minimumCapacity) {
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.allocArrays(minimumCapacity);
            if (this.mSize > 0) {
                System.arraycopy(ohashes, 0, this.mHashes, 0, this.mSize);
                System.arraycopy(oarray, 0, this.mArray, 0, this.mSize);
            }
            ArraySet.freeArrays(ohashes, oarray, this.mSize);
        }
        if (this.mSize != oSize) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean contains(Object key) {
        return this.indexOf(key) >= 0;
    }

    public int indexOf(Object key) {
        return key == null ? this.indexOfNull() : this.indexOf(key, this.mIdentityHashCode ? System.identityHashCode(key) : key.hashCode());
    }

    public E valueAt(int index) {
        if (index >= this.mSize && UtilConfig.sThrowExceptionForUpperArrayOutOfBounds) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.valueAtUnchecked(index);
    }

    public E valueAtUnchecked(int index) {
        return (E)this.mArray[index];
    }

    @Override
    public boolean isEmpty() {
        return this.mSize <= 0;
    }

    @Override
    public boolean add(E value2) {
        int index;
        int hash2;
        int oSize = this.mSize;
        if (value2 == null) {
            hash2 = 0;
            index = this.indexOfNull();
        } else {
            hash2 = this.mIdentityHashCode ? System.identityHashCode(value2) : value2.hashCode();
            index = this.indexOf(value2, hash2);
        }
        if (index >= 0) {
            return false;
        }
        index ^= 0xFFFFFFFF;
        if (oSize >= this.mHashes.length) {
            int n = oSize >= 8 ? oSize + (oSize >> 1) : (oSize >= 4 ? 8 : 4);
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.allocArrays(n);
            if (oSize != this.mSize) {
                throw new ConcurrentModificationException();
            }
            if (this.mHashes.length > 0) {
                System.arraycopy(ohashes, 0, this.mHashes, 0, ohashes.length);
                System.arraycopy(oarray, 0, this.mArray, 0, oarray.length);
            }
            ArraySet.freeArrays(ohashes, oarray, oSize);
        }
        if (index < oSize) {
            System.arraycopy(this.mHashes, index, this.mHashes, index + 1, oSize - index);
            System.arraycopy(this.mArray, index, this.mArray, index + 1, oSize - index);
        }
        if (oSize != this.mSize || index >= this.mHashes.length) {
            throw new ConcurrentModificationException();
        }
        this.mHashes[index] = hash2;
        this.mArray[index] = value2;
        ++this.mSize;
        return true;
    }

    public void append(E value2) {
        int hash2;
        int oSize = this.mSize;
        int index = this.mSize;
        int n = value2 == null ? 0 : (hash2 = this.mIdentityHashCode ? System.identityHashCode(value2) : value2.hashCode());
        if (index >= this.mHashes.length) {
            throw new IllegalStateException("Array is full");
        }
        if (index > 0 && this.mHashes[index - 1] > hash2) {
            this.add(value2);
            return;
        }
        if (oSize != this.mSize) {
            throw new ConcurrentModificationException();
        }
        this.mSize = index + 1;
        this.mHashes[index] = hash2;
        this.mArray[index] = value2;
    }

    public void addAll(ArraySet<? extends E> array2) {
        int N = array2.mSize;
        this.ensureCapacity(this.mSize + N);
        if (this.mSize == 0) {
            if (N > 0) {
                System.arraycopy(array2.mHashes, 0, this.mHashes, 0, N);
                System.arraycopy(array2.mArray, 0, this.mArray, 0, N);
                if (0 != this.mSize) {
                    throw new ConcurrentModificationException();
                }
                this.mSize = N;
            }
        } else {
            for (int i = 0; i < N; ++i) {
                this.add(array2.valueAt(i));
            }
        }
    }

    @Override
    public boolean remove(Object object) {
        int index = this.indexOf(object);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    private boolean shouldShrink() {
        return this.mHashes.length > 8 && this.mSize < this.mHashes.length / 3;
    }

    private int getNewShrunkenSize() {
        return this.mSize > 8 ? this.mSize + (this.mSize >> 1) : 8;
    }

    public E removeAt(int index) {
        if (index >= this.mSize && UtilConfig.sThrowExceptionForUpperArrayOutOfBounds) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int oSize = this.mSize;
        Object old = this.mArray[index];
        if (oSize <= 1) {
            this.clear();
        } else {
            int nSize = oSize - 1;
            if (this.shouldShrink()) {
                int n = this.getNewShrunkenSize();
                int[] ohashes = this.mHashes;
                Object[] oarray = this.mArray;
                this.allocArrays(n);
                if (index > 0) {
                    System.arraycopy(ohashes, 0, this.mHashes, 0, index);
                    System.arraycopy(oarray, 0, this.mArray, 0, index);
                }
                if (index < nSize) {
                    System.arraycopy(ohashes, index + 1, this.mHashes, index, nSize - index);
                    System.arraycopy(oarray, index + 1, this.mArray, index, nSize - index);
                }
            } else {
                if (index < nSize) {
                    System.arraycopy(this.mHashes, index + 1, this.mHashes, index, nSize - index);
                    System.arraycopy(this.mArray, index + 1, this.mArray, index, nSize - index);
                }
                this.mArray[nSize] = null;
            }
            if (oSize != this.mSize) {
                throw new ConcurrentModificationException();
            }
            this.mSize = nSize;
        }
        return (E)old;
    }

    @Override
    public boolean removeAll(ArraySet<? extends E> array2) {
        int N = array2.mSize;
        int originalSize = this.mSize;
        for (int i = 0; i < N; ++i) {
            this.remove(array2.valueAt(i));
        }
        return originalSize != this.mSize;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter2) {
        int i;
        if (this.mSize == 0) {
            return false;
        }
        int replaceIndex = 0;
        int numRemoved = 0;
        for (i = 0; i < this.mSize; ++i) {
            if (filter2.test(this.mArray[i])) {
                ++numRemoved;
                continue;
            }
            if (replaceIndex != i) {
                this.mArray[replaceIndex] = this.mArray[i];
                this.mHashes[replaceIndex] = this.mHashes[i];
            }
            ++replaceIndex;
        }
        if (numRemoved == 0) {
            return false;
        }
        if (numRemoved == this.mSize) {
            this.clear();
            return true;
        }
        this.mSize -= numRemoved;
        if (this.shouldShrink()) {
            int n = this.getNewShrunkenSize();
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.allocArrays(n);
            System.arraycopy(ohashes, 0, this.mHashes, 0, this.mSize);
            System.arraycopy(oarray, 0, this.mArray, 0, this.mSize);
        } else {
            for (i = this.mSize; i < this.mArray.length; ++i) {
                this.mArray[i] = null;
            }
        }
        return true;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public void forEach(Consumer<? super E> action2) {
        if (action2 == null) {
            throw new NullPointerException("action must not be null");
        }
        for (int i = 0; i < this.mSize; ++i) {
            action2.accept(this.valueAt(i));
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.mSize];
        System.arraycopy(this.mArray, 0, result, 0, this.mSize);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] array2) {
        if (array2.length < this.mSize) {
            Object[] newArray = (Object[])Array.newInstance(array2.getClass().getComponentType(), this.mSize);
            array2 = newArray;
        }
        System.arraycopy(this.mArray, 0, array2, 0, this.mSize);
        if (array2.length > this.mSize) {
            array2[this.mSize] = null;
        }
        return array2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            if (this.size() != set.size()) {
                return false;
            }
            try {
                for (int i = 0; i < this.mSize; ++i) {
                    E mine = this.valueAt(i);
                    if (set.contains(mine)) continue;
                    return false;
                }
            }
            catch (NullPointerException ignored) {
                return false;
            }
            catch (ClassCastException ignored) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int[] hashes = this.mHashes;
        int result = 0;
        int s = this.mSize;
        for (int i = 0; i < s; ++i) {
            result += hashes[i];
        }
        return result;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 14);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            E value2;
            if (i > 0) {
                buffer.append(", ");
            }
            if ((value2 = this.valueAt(i)) != this) {
                buffer.append(value2);
                continue;
            }
            buffer.append("(this Set)");
        }
        buffer.append('}');
        return buffer.toString();
    }

    private MapCollections<E, E> getCollection() {
        if (this.mCollections == null) {
            this.mCollections = new MapCollections<E, E>(){

                @Override
                protected int colGetSize() {
                    return ArraySet.this.mSize;
                }

                @Override
                protected Object colGetEntry(int index, int offset2) {
                    return ArraySet.this.mArray[index];
                }

                @Override
                protected int colIndexOfKey(Object key) {
                    return ArraySet.this.indexOf(key);
                }

                @Override
                protected int colIndexOfValue(Object value2) {
                    return ArraySet.this.indexOf(value2);
                }

                @Override
                protected Map<E, E> colGetMap() {
                    throw new UnsupportedOperationException("not a map");
                }

                @Override
                protected void colPut(E key, E value2) {
                    ArraySet.this.add(key);
                }

                @Override
                protected E colSetValue(int index, E value2) {
                    throw new UnsupportedOperationException("not a map");
                }

                @Override
                protected void colRemoveAt(int index) {
                    ArraySet.this.removeAt(index);
                }

                @Override
                protected void colClear() {
                    ArraySet.this.clear();
                }
            };
        }
        return this.mCollections;
    }

    @Override
    public Iterator<E> iterator() {
        return this.getCollection().getKeySet().iterator();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.ensureCapacity(this.mSize + collection.size());
        boolean added = false;
        for (E value2 : collection) {
            added |= this.add(value2);
        }
        return added;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean removed = false;
        for (Object value2 : collection) {
            removed |= this.remove(value2);
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean removed = false;
        for (int i = this.mSize - 1; i >= 0; --i) {
            if (collection.contains(this.mArray[i])) continue;
            this.removeAt(i);
            removed = true;
        }
        return removed;
    }

    static {
        sBaseCacheLock = new Object();
        sTwiceBaseCacheLock = new Object();
    }
}

