/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.ParcelableException;
import com.android.internal.util.Preconditions;
import java.io.IOException;

public class ExceptionUtils {
    public static RuntimeException wrap(IOException e) {
        throw new ParcelableException(e);
    }

    public static void maybeUnwrapIOException(RuntimeException e) throws IOException {
        if (e instanceof ParcelableException) {
            ((ParcelableException)e).maybeRethrow(IOException.class);
        }
    }

    public static String getCompleteMessage(String msg, Throwable t) {
        StringBuilder builder2 = new StringBuilder();
        if (msg != null) {
            builder2.append(msg).append(": ");
        }
        builder2.append(t.getMessage());
        while ((t = t.getCause()) != null) {
            builder2.append(": ").append(t.getMessage());
        }
        return builder2.toString();
    }

    public static String getCompleteMessage(Throwable t) {
        return ExceptionUtils.getCompleteMessage(null, t);
    }

    public static <E extends Throwable> void propagateIfInstanceOf(Throwable t, Class<E> c) throws E {
        if (t != null && c.isInstance(t)) {
            throw (Throwable)c.cast(t);
        }
    }

    public static <E extends Exception> RuntimeException propagate(Throwable t, Class<E> c) throws E {
        ExceptionUtils.propagateIfInstanceOf(t, c);
        return ExceptionUtils.propagate(t);
    }

    public static RuntimeException propagate(Throwable t) {
        Preconditions.checkNotNull(t);
        ExceptionUtils.propagateIfInstanceOf(t, Error.class);
        ExceptionUtils.propagateIfInstanceOf(t, RuntimeException.class);
        throw new RuntimeException(t);
    }

    public static Throwable getRootCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public static Throwable appendCause(Throwable t, Throwable cause) {
        if (cause != null) {
            ExceptionUtils.getRootCause(t).initCause(cause);
        }
        return t;
    }
}

