/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.app.admin.DevicePolicyManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.LauncherIcons;

public class IconDrawableFactory {
    protected final Context mContext;
    protected final PackageManager mPm;
    protected final UserManager mUm;
    protected final DevicePolicyManager mDpm;
    protected final LauncherIcons mLauncherIcons;
    protected final boolean mEmbedShadow;

    private IconDrawableFactory(Context context, boolean embedShadow) {
        this.mContext = context;
        this.mPm = context.getPackageManager();
        this.mUm = context.getSystemService(UserManager.class);
        this.mDpm = context.getSystemService(DevicePolicyManager.class);
        this.mLauncherIcons = new LauncherIcons(context);
        this.mEmbedShadow = embedShadow;
    }

    protected boolean needsBadging(ApplicationInfo appInfo, int userId) {
        return appInfo.isInstantApp() || this.mUm.hasBadge(userId);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public Drawable getBadgedIcon(ApplicationInfo appInfo) {
        return this.getBadgedIcon(appInfo, UserHandle.getUserId(appInfo.uid));
    }

    public Drawable getBadgedIcon(ApplicationInfo appInfo, int userId) {
        return this.getBadgedIcon(appInfo, appInfo, userId);
    }

    @UnsupportedAppUsage
    public Drawable getBadgedIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo, int userId) {
        Drawable icon2 = this.mPm.loadUnbadgedItemIcon(itemInfo, appInfo);
        if (!this.mEmbedShadow && !this.needsBadging(appInfo, userId)) {
            return icon2;
        }
        icon2 = this.getShadowedIcon(icon2);
        if (appInfo.isInstantApp()) {
            int badgeColor = Resources.getSystem().getColor(17170899, null);
            Drawable badge = this.mContext.getDrawable(17302481);
            icon2 = this.mLauncherIcons.getBadgedDrawable(icon2, badge, badgeColor);
        }
        if (this.mUm.hasBadge(userId)) {
            Drawable badge = this.mDpm.getResources().getDrawable(this.getUpdatableUserIconBadgeId(userId), "SOLID_COLORED", () -> this.getDefaultUserIconBadge(userId));
            icon2 = this.mLauncherIcons.getBadgedDrawable(icon2, badge, this.mUm.getUserBadgeColor(userId));
        }
        return icon2;
    }

    private String getUpdatableUserIconBadgeId(int userId) {
        return this.mUm.isManagedProfile(userId) ? "WORK_PROFILE_ICON_BADGE" : "UNDEFINED";
    }

    private Drawable getDefaultUserIconBadge(int userId) {
        return this.mContext.getResources().getDrawable(this.mUm.getUserIconBadgeResId(userId));
    }

    public Drawable getShadowedIcon(Drawable icon2) {
        return this.mLauncherIcons.wrapIconDrawableWithShadow(icon2);
    }

    @UnsupportedAppUsage
    public static IconDrawableFactory newInstance(Context context) {
        return new IconDrawableFactory(context, true);
    }

    public static IconDrawableFactory newInstance(Context context, boolean embedShadow) {
        return new IconDrawableFactory(context, embedShadow);
    }
}

