/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.proto.ProtoOutputStream;
import java.io.PrintWriter;
import java.time.Duration;
import java.time.format.DateTimeParseException;

public class KeyValueListParser {
    private final ArrayMap<String, String> mValues = new ArrayMap();
    private final TextUtils.StringSplitter mSplitter;

    public KeyValueListParser(char delim) {
        this.mSplitter = new TextUtils.SimpleStringSplitter(delim);
    }

    public void setString(String str) throws IllegalArgumentException {
        this.mValues.clear();
        if (str != null) {
            this.mSplitter.setString(str);
            for (String pair : this.mSplitter) {
                int sep = pair.indexOf(61);
                if (sep < 0) {
                    this.mValues.clear();
                    throw new IllegalArgumentException("'" + pair + "' in '" + str + "' is not a valid key-value pair");
                }
                this.mValues.put(pair.substring(0, sep).trim(), pair.substring(sep + 1).trim());
            }
        }
    }

    public int getInt(String key, int def) {
        String value2 = this.mValues.get(key);
        if (value2 != null) {
            try {
                return Integer.parseInt(value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public long getLong(String key, long def) {
        String value2 = this.mValues.get(key);
        if (value2 != null) {
            try {
                return Long.parseLong(value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public float getFloat(String key, float def) {
        String value2 = this.mValues.get(key);
        if (value2 != null) {
            try {
                return Float.parseFloat(value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public String getString(String key, String def) {
        String value2 = this.mValues.get(key);
        if (value2 != null) {
            return value2;
        }
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        String value2 = this.mValues.get(key);
        if (value2 != null) {
            try {
                return Boolean.parseBoolean(value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public int[] getIntArray(String key, int[] def) {
        String value2 = this.mValues.get(key);
        if (value2 != null) {
            try {
                String[] parts = value2.split(":");
                if (parts.length > 0) {
                    int[] ret = new int[parts.length];
                    for (int i = 0; i < parts.length; ++i) {
                        ret[i] = Integer.parseInt(parts[i]);
                    }
                    return ret;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public int size() {
        return this.mValues.size();
    }

    public String keyAt(int index) {
        return this.mValues.keyAt(index);
    }

    public long getDurationMillis(String key, long def) {
        String value2 = this.mValues.get(key);
        if (value2 != null) {
            try {
                if (value2.startsWith("P") || value2.startsWith("p")) {
                    return Duration.parse(value2).toMillis();
                }
                return Long.parseLong(value2);
            }
            catch (NumberFormatException | DateTimeParseException runtimeException) {
                // empty catch block
            }
        }
        return def;
    }

    public static class FloatValue {
        private final String mKey;
        private final float mDefaultValue;
        private float mValue;

        public FloatValue(String key, float defaultValue) {
            this.mKey = key;
            this.mValue = this.mDefaultValue = defaultValue;
        }

        public void parse(KeyValueListParser parser) {
            this.mValue = parser.getFloat(this.mKey, this.mDefaultValue);
        }

        public String getKey() {
            return this.mKey;
        }

        public float getDefaultValue() {
            return this.mDefaultValue;
        }

        public float getValue() {
            return this.mValue;
        }

        public void setValue(float value2) {
            this.mValue = value2;
        }

        public void dump(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.print(this.mKey);
            pw.print("=");
            pw.print(this.mValue);
            pw.println();
        }

        public void dumpProto(ProtoOutputStream proto, long tag2) {
            proto.write(tag2, this.mValue);
        }
    }

    public static class StringValue {
        private final String mKey;
        private final String mDefaultValue;
        private String mValue;

        public StringValue(String key, String defaultValue) {
            this.mKey = key;
            this.mValue = this.mDefaultValue = defaultValue;
        }

        public void parse(KeyValueListParser parser) {
            this.mValue = parser.getString(this.mKey, this.mDefaultValue);
        }

        public String getKey() {
            return this.mKey;
        }

        public String getDefaultValue() {
            return this.mDefaultValue;
        }

        public String getValue() {
            return this.mValue;
        }

        public void setValue(String value2) {
            this.mValue = value2;
        }

        public void dump(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.print(this.mKey);
            pw.print("=");
            pw.print(this.mValue);
            pw.println();
        }

        public void dumpProto(ProtoOutputStream proto, long tag2) {
            proto.write(tag2, this.mValue);
        }
    }

    public static class LongValue {
        private final String mKey;
        private final long mDefaultValue;
        private long mValue;

        public LongValue(String key, long defaultValue) {
            this.mKey = key;
            this.mValue = this.mDefaultValue = defaultValue;
        }

        public void parse(KeyValueListParser parser) {
            this.mValue = parser.getLong(this.mKey, this.mDefaultValue);
        }

        public String getKey() {
            return this.mKey;
        }

        public long getDefaultValue() {
            return this.mDefaultValue;
        }

        public long getValue() {
            return this.mValue;
        }

        public void setValue(long value2) {
            this.mValue = value2;
        }

        public void dump(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.print(this.mKey);
            pw.print("=");
            pw.print(this.mValue);
            pw.println();
        }

        public void dumpProto(ProtoOutputStream proto, long tag2) {
            proto.write(tag2, this.mValue);
        }
    }

    public static class IntValue {
        private final String mKey;
        private final int mDefaultValue;
        private int mValue;

        public IntValue(String key, int defaultValue) {
            this.mKey = key;
            this.mValue = this.mDefaultValue = defaultValue;
        }

        public void parse(KeyValueListParser parser) {
            this.mValue = parser.getInt(this.mKey, this.mDefaultValue);
        }

        public String getKey() {
            return this.mKey;
        }

        public int getDefaultValue() {
            return this.mDefaultValue;
        }

        public int getValue() {
            return this.mValue;
        }

        public void setValue(int value2) {
            this.mValue = value2;
        }

        public void dump(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.print(this.mKey);
            pw.print("=");
            pw.print(this.mValue);
            pw.println();
        }

        public void dumpProto(ProtoOutputStream proto, long tag2) {
            proto.write(tag2, this.mValue);
        }
    }
}

