/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.compat.annotation.UnsupportedAppUsage;
import android.util.Log;
import java.io.Writer;

public class LogWriter
extends Writer {
    private final int mPriority;
    private final String mTag;
    private final int mBuffer;
    private StringBuilder mBuilder = new StringBuilder(128);

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public LogWriter(int priority, String tag2) {
        this.mPriority = priority;
        this.mTag = tag2;
        this.mBuffer = 0;
    }

    public LogWriter(int priority, String tag2, int buffer) {
        this.mPriority = priority;
        this.mTag = tag2;
        this.mBuffer = buffer;
    }

    @Override
    public void close() {
        this.flushBuilder();
    }

    @Override
    public void flush() {
        this.flushBuilder();
    }

    @Override
    public void write(char[] buf, int offset2, int count) {
        for (int i = 0; i < count; ++i) {
            char c = buf[offset2 + i];
            if (c == '\n') {
                this.flushBuilder();
                continue;
            }
            this.mBuilder.append(c);
        }
    }

    private void flushBuilder() {
        if (this.mBuilder.length() > 0) {
            Log.println_native(this.mBuffer, this.mPriority, this.mTag, this.mBuilder.toString());
            this.mBuilder.delete(0, this.mBuilder.length());
        }
    }
}

