/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.compat.annotation.UnsupportedAppUsage;

public class Pools {
    private Pools() {
    }

    public static class SynchronizedPool<T>
    extends SimplePool<T> {
        private final Object mLock;

        public SynchronizedPool(int maxPoolSize, Object lock) {
            super(maxPoolSize);
            this.mLock = lock;
        }

        @UnsupportedAppUsage
        public SynchronizedPool(int maxPoolSize) {
            this(maxPoolSize, new Object());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @UnsupportedAppUsage
        public T acquire() {
            Object object = this.mLock;
            synchronized (object) {
                return super.acquire();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @UnsupportedAppUsage
        public boolean release(T element) {
            Object object = this.mLock;
            synchronized (object) {
                return super.release(element);
            }
        }
    }

    public static class SimplePool<T>
    implements Pool<T> {
        @UnsupportedAppUsage
        private final Object[] mPool;
        private int mPoolSize;

        @UnsupportedAppUsage
        public SimplePool(int maxPoolSize) {
            if (maxPoolSize <= 0) {
                throw new IllegalArgumentException("The max pool size must be > 0");
            }
            this.mPool = new Object[maxPoolSize];
        }

        @Override
        @UnsupportedAppUsage
        public T acquire() {
            if (this.mPoolSize > 0) {
                int lastPooledIndex = this.mPoolSize - 1;
                Object instance2 = this.mPool[lastPooledIndex];
                this.mPool[lastPooledIndex] = null;
                --this.mPoolSize;
                return (T)instance2;
            }
            return null;
        }

        @Override
        @UnsupportedAppUsage
        public boolean release(T instance2) {
            if (this.isInPool(instance2)) {
                throw new IllegalStateException("Already in the pool!");
            }
            if (this.mPoolSize < this.mPool.length) {
                this.mPool[this.mPoolSize] = instance2;
                ++this.mPoolSize;
                return true;
            }
            return false;
        }

        private boolean isInPool(T instance2) {
            for (int i = 0; i < this.mPoolSize; ++i) {
                if (this.mPool[i] != instance2) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Pool<T> {
        @UnsupportedAppUsage
        public T acquire();

        @UnsupportedAppUsage
        public boolean release(T var1);
    }
}

