/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;

public class SizeF
implements Parcelable {
    private final float mWidth;
    private final float mHeight;
    public static final Parcelable.Creator<SizeF> CREATOR = new Parcelable.Creator<SizeF>(){

        @Override
        public SizeF createFromParcel(Parcel in) {
            float width2 = in.readFloat();
            float height2 = in.readFloat();
            return new SizeF(width2, height2);
        }

        public SizeF[] newArray(int size) {
            return new SizeF[size];
        }
    };

    public SizeF(float width2, float height2) {
        this.mWidth = Preconditions.checkArgumentFinite(width2, "width");
        this.mHeight = Preconditions.checkArgumentFinite(height2, "height");
    }

    public float getWidth() {
        return this.mWidth;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof SizeF) {
            SizeF other = (SizeF)obj;
            return this.mWidth == other.mWidth && this.mHeight == other.mHeight;
        }
        return false;
    }

    public String toString() {
        return this.mWidth + "x" + this.mHeight;
    }

    private static NumberFormatException invalidSizeF(String s) {
        throw new NumberFormatException("Invalid SizeF: \"" + s + "\"");
    }

    public static SizeF parseSizeF(String string2) throws NumberFormatException {
        Preconditions.checkNotNull(string2, "string must not be null");
        int sep_ix = string2.indexOf(42);
        if (sep_ix < 0) {
            sep_ix = string2.indexOf(120);
        }
        if (sep_ix < 0) {
            throw SizeF.invalidSizeF(string2);
        }
        try {
            return new SizeF(Float.parseFloat(string2.substring(0, sep_ix)), Float.parseFloat(string2.substring(sep_ix + 1)));
        }
        catch (NumberFormatException e) {
            throw SizeF.invalidSizeF(string2);
        }
        catch (IllegalArgumentException e) {
            throw SizeF.invalidSizeF(string2);
        }
    }

    public int hashCode() {
        return Float.floatToIntBits(this.mWidth) ^ Float.floatToIntBits(this.mHeight);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeFloat(this.mWidth);
        out.writeFloat(this.mHeight);
    }
}

