/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.SparseLongArray;

public class SparseDoubleArray
implements Cloneable {
    private SparseLongArray mValues;

    public SparseDoubleArray() {
        this(10);
    }

    public SparseDoubleArray(int initialCapacity) {
        this.mValues = new SparseLongArray(initialCapacity);
    }

    public SparseDoubleArray clone() {
        SparseDoubleArray clone = null;
        try {
            clone = (SparseDoubleArray)super.clone();
            clone.mValues = this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public double get(int key) {
        return this.get(key, 0.0);
    }

    public double get(int key, double valueIfKeyNotFound) {
        int index = this.mValues.indexOfKey(key);
        if (index < 0) {
            return valueIfKeyNotFound;
        }
        return this.valueAt(index);
    }

    public void put(int key, double value2) {
        this.mValues.put(key, Double.doubleToRawLongBits(value2));
    }

    public void incrementValue(int key, double summand) {
        double oldValue = this.get(key);
        this.put(key, oldValue + summand);
    }

    public int size() {
        return this.mValues.size();
    }

    public int indexOfKey(int key) {
        return this.mValues.indexOfKey(key);
    }

    public int keyAt(int index) {
        return this.mValues.keyAt(index);
    }

    public double valueAt(int index) {
        return Double.longBitsToDouble(this.mValues.valueAt(index));
    }

    public void setValueAt(int index, double value2) {
        this.mValues.setValueAt(index, Double.doubleToRawLongBits(value2));
    }

    public void removeAt(int index) {
        this.mValues.removeAt(index);
    }

    public void delete(int key) {
        this.mValues.delete(key);
    }

    public void clear() {
        this.mValues.clear();
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.size() * 34);
        buffer.append('{');
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            int key = this.keyAt(i);
            buffer.append(key);
            buffer.append('=');
            double value2 = this.valueAt(i);
            buffer.append(value2);
        }
        buffer.append('}');
        return buffer.toString();
    }
}

