/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.annotation.SystemApi;
import android.os.SystemClock;
import com.android.internal.logging.EventLogTags;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class SystemConfigFileCommitEventLogger {
    private final String mName;
    private long mStartTime;

    public SystemConfigFileCommitEventLogger(String name) {
        this.mName = name;
    }

    public void setStartTime(long startTime) {
        this.mStartTime = startTime;
    }

    void onStartWrite() {
        if (this.mStartTime == 0L) {
            this.mStartTime = SystemClock.uptimeMillis();
        }
    }

    void onFinishWrite() {
        EventLogTags.writeCommitSysConfigFile(this.mName, SystemClock.uptimeMillis() - this.mStartTime);
    }
}

