/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.apk.DataDigester;
import android.util.apk.DataSource;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.DirectByteBuffer;
import java.security.DigestException;

class MemoryMappedFileDataSource
implements DataSource {
    private static final long MEMORY_PAGE_SIZE_BYTES = Os.sysconf(OsConstants._SC_PAGESIZE);
    private final FileDescriptor mFd;
    private final long mFilePosition;
    private final long mSize;

    MemoryMappedFileDataSource(FileDescriptor fd, long position, long size) {
        this.mFd = fd;
        this.mFilePosition = position;
        this.mSize = size;
    }

    @Override
    public long size() {
        return this.mSize;
    }

    @Override
    public void feedIntoDataDigester(DataDigester md, long offset2, int size) throws IOException, DigestException {
        long filePosition = this.mFilePosition + offset2;
        long mmapFilePosition = filePosition / MEMORY_PAGE_SIZE_BYTES * MEMORY_PAGE_SIZE_BYTES;
        int dataStartOffsetInMmapRegion = (int)(filePosition - mmapFilePosition);
        long mmapRegionSize = size + dataStartOffsetInMmapRegion;
        long mmapPtr = 0L;
        try {
            mmapPtr = Os.mmap(0L, mmapRegionSize, OsConstants.PROT_READ, OsConstants.MAP_SHARED | OsConstants.MAP_POPULATE, this.mFd, mmapFilePosition);
            DirectByteBuffer buf = new DirectByteBuffer(size, mmapPtr + (long)dataStartOffsetInMmapRegion, this.mFd, null, true);
            md.consume(buf);
        }
        catch (ErrnoException e) {
            throw new IOException("Failed to mmap " + mmapRegionSize + " bytes", e);
        }
        finally {
            if (mmapPtr != 0L) {
                try {
                    Os.munmap(mmapPtr, mmapRegionSize);
                }
                catch (ErrnoException errnoException) {}
            }
        }
    }
}

