/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.system.ErrnoException;
import android.system.Os;
import android.util.apk.DataDigester;
import android.util.apk.DataSource;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.DigestException;

class ReadFileDataSource
implements DataSource {
    private final FileDescriptor mFd;
    private final long mFilePosition;
    private final long mSize;
    private static final int CHUNK_SIZE = 0x100000;

    ReadFileDataSource(FileDescriptor fd, long position, long size) {
        this.mFd = fd;
        this.mFilePosition = position;
        this.mSize = size;
    }

    @Override
    public long size() {
        return this.mSize;
    }

    @Override
    public void feedIntoDataDigester(DataDigester md, long offset2, int size) throws IOException, DigestException {
        try {
            byte[] buffer = new byte[Math.min(size, 0x100000)];
            long start = this.mFilePosition + offset2;
            long end = start + (long)size;
            long pos = start;
            long curSize = Math.min(size, 0x100000);
            while (pos < end) {
                int readSize = Os.pread(this.mFd, buffer, 0, (int)curSize, pos);
                md.consume(ByteBuffer.wrap(buffer, 0, readSize));
                curSize = Math.min(end - (pos += (long)readSize), 0x100000L);
            }
        }
        catch (ErrnoException e) {
            throw new IOException(e);
        }
    }
}

