/*
 * Decompiled with CFR 0.152.
 */
package android.util.proto;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ProtoStream {
    public static final int FIELD_ID_SHIFT = 3;
    public static final int WIRE_TYPE_MASK = 7;
    public static final int FIELD_ID_MASK = -8;
    public static final int WIRE_TYPE_VARINT = 0;
    public static final int WIRE_TYPE_FIXED64 = 1;
    public static final int WIRE_TYPE_LENGTH_DELIMITED = 2;
    public static final int WIRE_TYPE_START_GROUP = 3;
    public static final int WIRE_TYPE_END_GROUP = 4;
    public static final int WIRE_TYPE_FIXED32 = 5;
    public static final int FIELD_TYPE_SHIFT = 32;
    public static final long FIELD_TYPE_MASK = 0xFF00000000L;
    public static final long FIELD_TYPE_UNKNOWN = 0L;
    public static final long FIELD_TYPE_DOUBLE = 0x100000000L;
    public static final long FIELD_TYPE_FLOAT = 0x200000000L;
    public static final long FIELD_TYPE_INT64 = 0x300000000L;
    public static final long FIELD_TYPE_UINT64 = 0x400000000L;
    public static final long FIELD_TYPE_INT32 = 0x500000000L;
    public static final long FIELD_TYPE_FIXED64 = 0x600000000L;
    public static final long FIELD_TYPE_FIXED32 = 0x700000000L;
    public static final long FIELD_TYPE_BOOL = 0x800000000L;
    public static final long FIELD_TYPE_STRING = 0x900000000L;
    public static final long FIELD_TYPE_MESSAGE = 0xB00000000L;
    public static final long FIELD_TYPE_BYTES = 0xC00000000L;
    public static final long FIELD_TYPE_UINT32 = 0xD00000000L;
    public static final long FIELD_TYPE_ENUM = 0xE00000000L;
    public static final long FIELD_TYPE_SFIXED32 = 0xF00000000L;
    public static final long FIELD_TYPE_SFIXED64 = 0x1000000000L;
    public static final long FIELD_TYPE_SINT32 = 0x1100000000L;
    public static final long FIELD_TYPE_SINT64 = 0x1200000000L;
    private static final String[] FIELD_TYPE_NAMES = new String[]{"Double", "Float", "Int64", "UInt64", "Int32", "Fixed64", "Fixed32", "Bool", "String", "Group", "Message", "Bytes", "UInt32", "Enum", "SFixed32", "SFixed64", "SInt32", "SInt64"};
    public static final int FIELD_COUNT_SHIFT = 40;
    public static final long FIELD_COUNT_MASK = 0xF0000000000L;
    public static final long FIELD_COUNT_UNKNOWN = 0L;
    public static final long FIELD_COUNT_SINGLE = 0x10000000000L;
    public static final long FIELD_COUNT_REPEATED = 0x20000000000L;
    public static final long FIELD_COUNT_PACKED = 0x50000000000L;

    public static String getFieldTypeString(long fieldType) {
        int index = (int)((fieldType & 0xFF00000000L) >>> 32) - 1;
        if (index >= 0 && index < FIELD_TYPE_NAMES.length) {
            return FIELD_TYPE_NAMES[index];
        }
        return null;
    }

    public static String getFieldCountString(long fieldCount) {
        if (fieldCount == 0x10000000000L) {
            return "";
        }
        if (fieldCount == 0x20000000000L) {
            return "Repeated";
        }
        if (fieldCount == 0x50000000000L) {
            return "Packed";
        }
        return null;
    }

    public static String getWireTypeString(int wireType) {
        switch (wireType) {
            case 0: {
                return "Varint";
            }
            case 1: {
                return "Fixed64";
            }
            case 2: {
                return "Length Delimited";
            }
            case 3: {
                return "Start Group";
            }
            case 4: {
                return "End Group";
            }
            case 5: {
                return "Fixed32";
            }
        }
        return null;
    }

    public static String getFieldIdString(long fieldId) {
        long fieldType;
        String typeString;
        long fieldCount = fieldId & 0xF0000000000L;
        String countString = ProtoStream.getFieldCountString(fieldCount);
        if (countString == null) {
            countString = "fieldCount=" + fieldCount;
        }
        if (countString.length() > 0) {
            countString = countString + " ";
        }
        if ((typeString = ProtoStream.getFieldTypeString(fieldType = fieldId & 0xFF00000000L)) == null) {
            typeString = "fieldType=" + fieldType;
        }
        return countString + typeString + " tag=" + (int)fieldId + " fieldId=0x" + Long.toHexString(fieldId);
    }

    public static long makeFieldId(int id2, long fieldFlags) {
        return fieldFlags | (long)id2 & 0xFFFFFFFFL;
    }

    public static long makeToken(int tagSize, boolean repeated, int depth, int objectId, int offset2) {
        return (7L & (long)tagSize) << 61 | (repeated ? 0x1000000000000000L : 0L) | (0x1FFL & (long)depth) << 51 | (0x7FFFFL & (long)objectId) << 32 | 0xFFFFFFFFL & (long)offset2;
    }

    public static int getTagSizeFromToken(long token) {
        return (int)(7L & token >> 61);
    }

    public static boolean getRepeatedFromToken(long token) {
        return (1L & token >> 60) != 0L;
    }

    public static int getDepthFromToken(long token) {
        return (int)(0x1FFL & token >> 51);
    }

    public static int getObjectIdFromToken(long token) {
        return (int)(0x7FFFFL & token >> 32);
    }

    public static int getOffsetFromToken(long token) {
        return (int)token;
    }

    public static int convertObjectIdToOrdinal(int objectId) {
        return 524287 - objectId;
    }

    public static String token2String(long token) {
        if (token == 0L) {
            return "Token(0)";
        }
        return "Token(val=0x" + Long.toHexString(token) + " depth=" + ProtoStream.getDepthFromToken(token) + " object=" + ProtoStream.convertObjectIdToOrdinal(ProtoStream.getObjectIdFromToken(token)) + " tagSize=" + ProtoStream.getTagSizeFromToken(token) + " offset=" + ProtoStream.getOffsetFromToken(token) + ')';
    }

    protected ProtoStream() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FieldCount {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FieldType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WireType {
    }
}

