/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.uwb.IUwbAdapterStateCallbacks;
import android.uwb.IUwbAdfProvisionStateCallbacks;
import android.uwb.IUwbRangingCallbacks;
import android.uwb.IUwbVendorUciCallback;
import android.uwb.SessionHandle;
import android.uwb.UwbAddress;
import java.util.ArrayList;
import java.util.List;

public interface IUwbAdapter
extends IInterface {
    public static final String DESCRIPTOR = "android.uwb.IUwbAdapter";
    public static final int RANGING_SESSION_OPEN_THRESHOLD_MS = 3000;
    public static final int RANGING_SESSION_START_THRESHOLD_MS = 3000;
    public static final int RANGING_SESSION_CLOSE_THRESHOLD_MS = 3000;

    public void registerAdapterStateCallbacks(IUwbAdapterStateCallbacks var1) throws RemoteException;

    public void registerVendorExtensionCallback(IUwbVendorUciCallback var1) throws RemoteException;

    public void unregisterVendorExtensionCallback(IUwbVendorUciCallback var1) throws RemoteException;

    public void unregisterAdapterStateCallbacks(IUwbAdapterStateCallbacks var1) throws RemoteException;

    public long getTimestampResolutionNanos(String var1) throws RemoteException;

    public PersistableBundle getSpecificationInfo(String var1) throws RemoteException;

    public void openRanging(AttributionSource var1, SessionHandle var2, IUwbRangingCallbacks var3, PersistableBundle var4, String var5) throws RemoteException;

    public void startRanging(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void reconfigureRanging(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void stopRanging(SessionHandle var1) throws RemoteException;

    public void closeRanging(SessionHandle var1) throws RemoteException;

    public void addControlee(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void removeControlee(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void pause(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void resume(SessionHandle var1, PersistableBundle var2) throws RemoteException;

    public void sendData(SessionHandle var1, UwbAddress var2, PersistableBundle var3, byte[] var4) throws RemoteException;

    public void setEnabled(boolean var1) throws RemoteException;

    public int getAdapterState() throws RemoteException;

    public List<PersistableBundle> getChipInfos() throws RemoteException;

    public List<String> getChipIds() throws RemoteException;

    public String getDefaultChipId() throws RemoteException;

    public PersistableBundle addServiceProfile(PersistableBundle var1) throws RemoteException;

    public int removeServiceProfile(PersistableBundle var1) throws RemoteException;

    public PersistableBundle getAllServiceProfiles() throws RemoteException;

    public PersistableBundle getAdfProvisioningAuthorities(PersistableBundle var1) throws RemoteException;

    public PersistableBundle getAdfCertificateAndInfo(PersistableBundle var1) throws RemoteException;

    public void provisionProfileAdfByScript(PersistableBundle var1, IUwbAdfProvisionStateCallbacks var2) throws RemoteException;

    public int removeProfileAdf(PersistableBundle var1) throws RemoteException;

    public int sendVendorUciMessage(int var1, int var2, byte[] var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUwbAdapter {
        static final int TRANSACTION_registerAdapterStateCallbacks = 1;
        static final int TRANSACTION_registerVendorExtensionCallback = 2;
        static final int TRANSACTION_unregisterVendorExtensionCallback = 3;
        static final int TRANSACTION_unregisterAdapterStateCallbacks = 4;
        static final int TRANSACTION_getTimestampResolutionNanos = 5;
        static final int TRANSACTION_getSpecificationInfo = 6;
        static final int TRANSACTION_openRanging = 7;
        static final int TRANSACTION_startRanging = 8;
        static final int TRANSACTION_reconfigureRanging = 9;
        static final int TRANSACTION_stopRanging = 10;
        static final int TRANSACTION_closeRanging = 11;
        static final int TRANSACTION_addControlee = 12;
        static final int TRANSACTION_removeControlee = 13;
        static final int TRANSACTION_pause = 14;
        static final int TRANSACTION_resume = 15;
        static final int TRANSACTION_sendData = 16;
        static final int TRANSACTION_setEnabled = 17;
        static final int TRANSACTION_getAdapterState = 18;
        static final int TRANSACTION_getChipInfos = 19;
        static final int TRANSACTION_getChipIds = 20;
        static final int TRANSACTION_getDefaultChipId = 21;
        static final int TRANSACTION_addServiceProfile = 22;
        static final int TRANSACTION_removeServiceProfile = 23;
        static final int TRANSACTION_getAllServiceProfiles = 24;
        static final int TRANSACTION_getAdfProvisioningAuthorities = 25;
        static final int TRANSACTION_getAdfCertificateAndInfo = 26;
        static final int TRANSACTION_provisionProfileAdfByScript = 27;
        static final int TRANSACTION_removeProfileAdf = 28;
        static final int TRANSACTION_sendVendorUciMessage = 29;

        public Stub() {
            this.attachInterface(this, IUwbAdapter.DESCRIPTOR);
        }

        public static IUwbAdapter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IUwbAdapter.DESCRIPTOR);
            if (iin != null && iin instanceof IUwbAdapter) {
                return (IUwbAdapter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IUwbAdapter.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IUwbAdapterStateCallbacks _arg0 = IUwbAdapterStateCallbacks.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerAdapterStateCallbacks(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    IUwbVendorUciCallback _arg0 = IUwbVendorUciCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerVendorExtensionCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    IUwbVendorUciCallback _arg0 = IUwbVendorUciCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterVendorExtensionCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    IUwbAdapterStateCallbacks _arg0 = IUwbAdapterStateCallbacks.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterAdapterStateCallbacks(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    long _result = this.getTimestampResolutionNanos(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    PersistableBundle _result = this.getSpecificationInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 7: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    SessionHandle _arg1 = data.readTypedObject(SessionHandle.CREATOR);
                    IUwbRangingCallbacks _arg2 = IUwbRangingCallbacks.Stub.asInterface(data.readStrongBinder());
                    PersistableBundle _arg3 = data.readTypedObject(PersistableBundle.CREATOR);
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.openRanging(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.startRanging(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.reconfigureRanging(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.stopRanging(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.closeRanging(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.addControlee(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeControlee(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.pause(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.resume(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    SessionHandle _arg0 = data.readTypedObject(SessionHandle.CREATOR);
                    UwbAddress _arg1 = data.readTypedObject(UwbAddress.CREATOR);
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.sendData(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    int _result = this.getAdapterState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 19: {
                    List<PersistableBundle> _result = this.getChipInfos();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 20: {
                    List<String> _result = this.getChipIds();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 21: {
                    String _result = this.getDefaultChipId();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 22: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    PersistableBundle _result = this.addServiceProfile(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 23: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.removeServiceProfile(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 24: {
                    PersistableBundle _result = this.getAllServiceProfiles();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 25: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    PersistableBundle _result = this.getAdfProvisioningAuthorities(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 26: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    PersistableBundle _result = this.getAdfCertificateAndInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 27: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    IUwbAdfProvisionStateCallbacks _arg1 = IUwbAdfProvisionStateCallbacks.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.provisionProfileAdfByScript(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.removeProfileAdf(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    int _result = this.sendVendorUciMessage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IUwbAdapter {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IUwbAdapter.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAdapterStateCallbacks(IUwbAdapterStateCallbacks adapterStateCallbacks) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(adapterStateCallbacks);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerVendorExtensionCallback(IUwbVendorUciCallback callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterVendorExtensionCallback(IUwbVendorUciCallback callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterAdapterStateCallbacks(IUwbAdapterStateCallbacks callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getTimestampResolutionNanos(String chipId) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeString(chipId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getSpecificationInfo(String chipId) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeString(chipId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openRanging(AttributionSource attributionSource, SessionHandle sessionHandle, IUwbRangingCallbacks rangingCallbacks, PersistableBundle parameters, String chipId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeStrongInterface(rangingCallbacks);
                    _data.writeTypedObject(parameters, 0);
                    _data.writeString(chipId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startRanging(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(parameters, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reconfigureRanging(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(parameters, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopRanging(SessionHandle sessionHandle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeRanging(SessionHandle sessionHandle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addControlee(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeControlee(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pause(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resume(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendData(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, PersistableBundle params, byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(sessionHandle, 0);
                    _data.writeTypedObject(remoteDeviceAddress, 0);
                    _data.writeTypedObject(params, 0);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAdapterState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PersistableBundle> getChipInfos() throws RemoteException {
                ArrayList<PersistableBundle> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getChipIds() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getDefaultChipId() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle addServiceProfile(PersistableBundle parameters) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(parameters, 0);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeServiceProfile(PersistableBundle parameters) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(parameters, 0);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getAllServiceProfiles() throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getAdfProvisioningAuthorities(PersistableBundle parameters) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(parameters, 0);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getAdfCertificateAndInfo(PersistableBundle parameters) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(parameters, 0);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PersistableBundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void provisionProfileAdfByScript(PersistableBundle serviceProfileBundle, IUwbAdfProvisionStateCallbacks callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(serviceProfileBundle, 0);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeProfileAdf(PersistableBundle serviceProfileBundle) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeTypedObject(serviceProfileBundle, 0);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int sendVendorUciMessage(int gid, int oid, byte[] payload) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUwbAdapter.DESCRIPTOR);
                    _data.writeInt(gid);
                    _data.writeInt(oid);
                    _data.writeByteArray(payload);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IUwbAdapter {
        @Override
        public void registerAdapterStateCallbacks(IUwbAdapterStateCallbacks adapterStateCallbacks) throws RemoteException {
        }

        @Override
        public void registerVendorExtensionCallback(IUwbVendorUciCallback callbacks) throws RemoteException {
        }

        @Override
        public void unregisterVendorExtensionCallback(IUwbVendorUciCallback callbacks) throws RemoteException {
        }

        @Override
        public void unregisterAdapterStateCallbacks(IUwbAdapterStateCallbacks callbacks) throws RemoteException {
        }

        @Override
        public long getTimestampResolutionNanos(String chipId) throws RemoteException {
            return 0L;
        }

        @Override
        public PersistableBundle getSpecificationInfo(String chipId) throws RemoteException {
            return null;
        }

        @Override
        public void openRanging(AttributionSource attributionSource, SessionHandle sessionHandle, IUwbRangingCallbacks rangingCallbacks, PersistableBundle parameters, String chipId) throws RemoteException {
        }

        @Override
        public void startRanging(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void reconfigureRanging(SessionHandle sessionHandle, PersistableBundle parameters) throws RemoteException {
        }

        @Override
        public void stopRanging(SessionHandle sessionHandle) throws RemoteException {
        }

        @Override
        public void closeRanging(SessionHandle sessionHandle) throws RemoteException {
        }

        @Override
        public void addControlee(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
        }

        @Override
        public void removeControlee(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
        }

        @Override
        public void pause(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
        }

        @Override
        public void resume(SessionHandle sessionHandle, PersistableBundle params) throws RemoteException {
        }

        @Override
        public void sendData(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, PersistableBundle params, byte[] data) throws RemoteException {
        }

        @Override
        public void setEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public int getAdapterState() throws RemoteException {
            return 0;
        }

        @Override
        public List<PersistableBundle> getChipInfos() throws RemoteException {
            return null;
        }

        @Override
        public List<String> getChipIds() throws RemoteException {
            return null;
        }

        @Override
        public String getDefaultChipId() throws RemoteException {
            return null;
        }

        @Override
        public PersistableBundle addServiceProfile(PersistableBundle parameters) throws RemoteException {
            return null;
        }

        @Override
        public int removeServiceProfile(PersistableBundle parameters) throws RemoteException {
            return 0;
        }

        @Override
        public PersistableBundle getAllServiceProfiles() throws RemoteException {
            return null;
        }

        @Override
        public PersistableBundle getAdfProvisioningAuthorities(PersistableBundle parameters) throws RemoteException {
            return null;
        }

        @Override
        public PersistableBundle getAdfCertificateAndInfo(PersistableBundle parameters) throws RemoteException {
            return null;
        }

        @Override
        public void provisionProfileAdfByScript(PersistableBundle serviceProfileBundle, IUwbAdfProvisionStateCallbacks callback2) throws RemoteException {
        }

        @Override
        public int removeProfileAdf(PersistableBundle serviceProfileBundle) throws RemoteException {
            return 0;
        }

        @Override
        public int sendVendorUciMessage(int gid, int oid, byte[] payload) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

