/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.os.Binder;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.util.Log;
import android.uwb.IUwbAdapter;
import android.uwb.RangingReport;
import android.uwb.SessionHandle;
import android.uwb.UwbAddress;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

@SystemApi
public class RangingSession
implements AutoCloseable {
    private static final String TAG = "Uwb.RangingSession";
    private final SessionHandle mSessionHandle;
    private final IUwbAdapter mAdapter;
    private final Executor mExecutor;
    private final Callback mCallback;
    private final String mChipId;
    private State mState = State.INIT;

    public RangingSession(Executor executor, Callback callback2, IUwbAdapter adapter, SessionHandle sessionHandle) {
        this(executor, callback2, adapter, sessionHandle, null);
    }

    public RangingSession(Executor executor, Callback callback2, IUwbAdapter adapter, SessionHandle sessionHandle, String chipId) {
        this.mExecutor = executor;
        this.mCallback = callback2;
        this.mAdapter = adapter;
        this.mSessionHandle = sessionHandle;
        this.mChipId = chipId;
    }

    public boolean isOpen() {
        return this.mState == State.IDLE || this.mState == State.ACTIVE;
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void start(PersistableBundle params) {
        if (this.mState != State.IDLE) {
            throw new IllegalStateException();
        }
        try {
            this.mAdapter.startRanging(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void reconfigure(PersistableBundle params) {
        if (this.mState != State.ACTIVE && this.mState != State.IDLE) {
            throw new IllegalStateException();
        }
        try {
            this.mAdapter.reconfigureRanging(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void stop() {
        if (this.mState != State.ACTIVE) {
            throw new IllegalStateException();
        }
        try {
            this.mAdapter.stopRanging(this.mSessionHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void close() {
        if (this.mState == State.CLOSED) {
            this.mExecutor.execute(() -> this.mCallback.onClosed(1, new PersistableBundle()));
            return;
        }
        try {
            this.mAdapter.closeRanging(this.mSessionHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void addControlee(PersistableBundle params) {
        if (this.mState != State.ACTIVE && this.mState != State.IDLE) {
            throw new IllegalStateException();
        }
        try {
            this.mAdapter.addControlee(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void removeControlee(PersistableBundle params) {
        if (this.mState != State.ACTIVE && this.mState != State.IDLE) {
            throw new IllegalStateException();
        }
        try {
            this.mAdapter.removeControlee(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void pause(PersistableBundle params) {
        if (this.mState != State.ACTIVE) {
            throw new IllegalStateException();
        }
        try {
            this.mAdapter.pause(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void resume(PersistableBundle params) {
        if (this.mState != State.ACTIVE) {
            throw new IllegalStateException();
        }
        try {
            this.mAdapter.resume(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void sendData(UwbAddress remoteDeviceAddress, PersistableBundle params, byte[] data) {
        if (this.mState != State.ACTIVE) {
            throw new IllegalStateException();
        }
        try {
            this.mAdapter.sendData(this.mSessionHandle, remoteDeviceAddress, params, data);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void onRangingOpened() {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingOpened invoked for a closed session");
            return;
        }
        this.mState = State.IDLE;
        this.executeCallback(() -> this.mCallback.onOpened(this));
    }

    public void onRangingOpenFailed(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingOpenFailed invoked for a closed session");
            return;
        }
        this.mState = State.CLOSED;
        this.executeCallback(() -> this.mCallback.onOpenFailed(reason, params));
    }

    public void onRangingStarted(PersistableBundle parameters) {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingStarted invoked for a closed session");
            return;
        }
        this.mState = State.ACTIVE;
        this.executeCallback(() -> this.mCallback.onStarted(parameters));
    }

    public void onRangingStartFailed(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingStartFailed invoked for a closed session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onStartFailed(reason, params));
    }

    public void onRangingReconfigured(PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingReconfigured invoked for a closed session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onReconfigured(params));
    }

    public void onRangingReconfigureFailed(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingReconfigureFailed invoked for a closed session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onReconfigureFailed(reason, params));
    }

    public void onRangingStopped(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingStopped invoked for a closed session");
            return;
        }
        this.mState = State.IDLE;
        this.executeCallback(() -> this.mCallback.onStopped(reason, params));
    }

    public void onRangingStopFailed(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(TAG, "onRangingStopFailed invoked for a closed session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onStopFailed(reason, params));
    }

    public void onRangingClosed(int reason, PersistableBundle parameters) {
        this.mState = State.CLOSED;
        this.executeCallback(() -> this.mCallback.onClosed(reason, parameters));
    }

    public void onRangingResult(RangingReport report) {
        if (!this.isOpen()) {
            Log.w(TAG, "onRangingResult invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onReportReceived(report));
    }

    public void onControleeAdded(PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(TAG, "onControleeAdded invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onControleeAdded(params));
    }

    public void onControleeAddFailed(int reason, PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(TAG, "onControleeAddFailed invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onControleeAddFailed(reason, params));
    }

    public void onControleeRemoved(PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(TAG, "onControleeRemoved invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onControleeRemoved(params));
    }

    public void onControleeRemoveFailed(int reason, PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(TAG, "onControleeRemoveFailed invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onControleeRemoveFailed(reason, params));
    }

    public void onRangingPaused(PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(TAG, "onRangingPaused invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onPaused(params));
    }

    public void onRangingPauseFailed(int reason, PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(TAG, "onRangingPauseFailed invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onPauseFailed(reason, params));
    }

    public void onRangingResumed(PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(TAG, "onRangingResumed invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onResumed(params));
    }

    public void onRangingResumeFailed(int reason, PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(TAG, "onRangingResumeFailed invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onResumeFailed(reason, params));
    }

    public void onDataSent(UwbAddress remoteDeviceAddress, PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(TAG, "onDataSent invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onDataSent(remoteDeviceAddress, params));
    }

    public void onDataSendFailed(UwbAddress remoteDeviceAddress, int reason, PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(TAG, "onDataSendFailed invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onDataSendFailed(remoteDeviceAddress, reason, params));
    }

    public void onDataReceived(UwbAddress remoteDeviceAddress, PersistableBundle params, byte[] data) {
        if (!this.isOpen()) {
            Log.w(TAG, "onDataReceived invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onDataReceived(remoteDeviceAddress, params, data));
    }

    public void onDataReceiveFailed(UwbAddress remoteDeviceAddress, int reason, PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(TAG, "onDataReceiveFailed invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onDataReceiveFailed(remoteDeviceAddress, reason, params));
    }

    public void onServiceDiscovered(PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(TAG, "onServiceDiscovered invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onServiceDiscovered(params));
    }

    public void onServiceConnected(PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(TAG, "onServiceConnected invoked for non-open session");
            return;
        }
        this.executeCallback(() -> this.mCallback.onServiceConnected(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCallback(Runnable runnable) {
        long identity = Binder.clearCallingIdentity();
        try {
            this.mExecutor.execute(runnable);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public static interface Callback {
        public static final int REASON_UNKNOWN = 0;
        public static final int REASON_LOCAL_REQUEST = 1;
        public static final int REASON_REMOTE_REQUEST = 2;
        public static final int REASON_BAD_PARAMETERS = 3;
        public static final int REASON_GENERIC_ERROR = 4;
        public static final int REASON_MAX_SESSIONS_REACHED = 5;
        public static final int REASON_SYSTEM_POLICY = 6;
        public static final int REASON_PROTOCOL_SPECIFIC_ERROR = 7;
        public static final int REASON_MAX_RR_RETRY_REACHED = 9;
        public static final int REASON_SERVICE_DISCOVERY_FAILURE = 10;
        public static final int REASON_SERVICE_CONNECTION_FAILURE = 11;
        public static final int REASON_SE_NOT_SUPPORTED = 12;
        public static final int REASON_SE_INTERACTION_FAILURE = 13;
        public static final int CONTROLEE_FAILURE_REASON_MAX_CONTROLEE_REACHED = 0;
        public static final int DATA_FAILURE_REASON_DATA_SIZE_TOO_LARGE = 10;

        public void onOpened(RangingSession var1);

        public void onOpenFailed(int var1, PersistableBundle var2);

        public void onStarted(PersistableBundle var1);

        public void onStartFailed(int var1, PersistableBundle var2);

        public void onReconfigured(PersistableBundle var1);

        public void onReconfigureFailed(int var1, PersistableBundle var2);

        public void onStopped(int var1, PersistableBundle var2);

        public void onStopFailed(int var1, PersistableBundle var2);

        public void onClosed(int var1, PersistableBundle var2);

        public void onReportReceived(RangingReport var1);

        default public void onControleeAdded(PersistableBundle parameters) {
        }

        default public void onControleeAddFailed(int reason, PersistableBundle parameters) {
        }

        default public void onControleeRemoved(PersistableBundle parameters) {
        }

        default public void onControleeRemoveFailed(int reason, PersistableBundle parameters) {
        }

        default public void onPaused(PersistableBundle parameters) {
        }

        default public void onPauseFailed(int reason, PersistableBundle parameters) {
        }

        default public void onResumed(PersistableBundle parameters) {
        }

        default public void onResumeFailed(int reason, PersistableBundle parameters) {
        }

        default public void onDataSent(UwbAddress remoteDeviceAddress, PersistableBundle parameters) {
        }

        default public void onDataSendFailed(UwbAddress remoteDeviceAddress, int reason, PersistableBundle parameters) {
        }

        default public void onDataReceived(UwbAddress remoteDeviceAddress, PersistableBundle parameters, byte[] data) {
        }

        default public void onDataReceiveFailed(UwbAddress remoteDeviceAddress, int reason, PersistableBundle parameters) {
        }

        default public void onServiceDiscovered(PersistableBundle parameters) {
        }

        default public void onServiceConnected(PersistableBundle parameters) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DataFailureReason {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ControleeFailureReason {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Reason {
        }
    }

    private static enum State {
        INIT,
        IDLE,
        ACTIVE,
        CLOSED;

    }
}

