/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.Binder;
import android.os.CancellationSignal;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.util.Log;
import android.uwb.AdapterStateListener;
import android.uwb.IUwbAdapter;
import android.uwb.IUwbAdfProvisionStateCallbacks;
import android.uwb.RangingManager;
import android.uwb.RangingSession;
import android.uwb.UwbVendorUciCallbackListener;
import com.android.internal.annotations.GuardedBy;
import com.android.x.uwb.com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.concurrent.Executor;

@SystemApi
public class UwbManager {
    private static final String TAG = "UwbManager";
    private final Context mContext;
    private final IUwbAdapter mUwbAdapter;
    private final AdapterStateListener mAdapterStateListener;
    private final RangingManager mRangingManager;
    private final UwbVendorUciCallbackListener mUwbVendorUciCallbackListener;
    public static final int REMOVE_SERVICE_PROFILE_SUCCESS = 0;
    public static final int REMOVE_SERVICE_PROFILE_ERROR_UNKNOWN_SERVICE = 1;
    public static final int REMOVE_SERVICE_PROFILE_ERROR_INTERNAL = 2;
    public static final int REMOVE_PROFILE_ADF_SUCCESS = 0;
    public static final int REMOVE_PROFILE_ADF_ERROR_UNKNOWN_SERVICE = 1;
    public static final int REMOVE_PROFILE_ADF_ERROR_INTERNAL = 2;
    public static final int SEND_VENDOR_UCI_SUCCESS = 0;
    public static final int SEND_VENDOR_UCI_ERROR_HW = 1;
    public static final int SEND_VENDOR_UCI_ERROR_OFF = 2;
    public static final int SEND_VENDOR_UCI_ERROR_INVALID_ARGS = 3;
    public static final int SEND_VENDOR_UCI_ERROR_INVALID_GID = 4;

    public UwbManager(Context ctx, IUwbAdapter adapter) {
        this.mContext = ctx;
        this.mUwbAdapter = adapter;
        this.mAdapterStateListener = new AdapterStateListener(adapter);
        this.mRangingManager = new RangingManager(adapter);
        this.mUwbVendorUciCallbackListener = new UwbVendorUciCallbackListener(adapter);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void registerAdapterStateCallback(Executor executor, AdapterStateCallback callback2) {
        this.mAdapterStateListener.register(executor, callback2);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void unregisterAdapterStateCallback(AdapterStateCallback callback2) {
        this.mAdapterStateListener.unregister(callback2);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void registerUwbVendorUciCallback(Executor executor, UwbVendorUciCallback callback2) {
        this.mUwbVendorUciCallbackListener.register(executor, callback2);
    }

    public void unregisterUwbVendorUciCallback(UwbVendorUciCallback callback2) {
        this.mUwbVendorUciCallbackListener.unregister(callback2);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle getSpecificationInfo() {
        return this.getSpecificationInfoInternal(null);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle getSpecificationInfo(String chipId) {
        Preconditions.checkNotNull(chipId);
        return this.getSpecificationInfoInternal(chipId);
    }

    private PersistableBundle getSpecificationInfoInternal(String chipId) {
        try {
            return this.mUwbAdapter.getSpecificationInfo(chipId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"MethodNameUnits"})
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public long elapsedRealtimeResolutionNanos() {
        return this.elapsedRealtimeResolutionNanosInternal(null);
    }

    @SuppressLint(value={"MethodNameUnits"})
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public long elapsedRealtimeResolutionNanos(String chipId) {
        Preconditions.checkNotNull(chipId);
        return this.elapsedRealtimeResolutionNanosInternal(chipId);
    }

    private long elapsedRealtimeResolutionNanosInternal(String chipId) {
        try {
            return this.mUwbAdapter.getTimestampResolutionNanos(chipId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.UWB_PRIVILEGED", "android.permission.UWB_RANGING"})
    public CancellationSignal openRangingSession(PersistableBundle parameters, Executor executor, RangingSession.Callback callbacks) {
        return this.openRangingSessionInternal(parameters, executor, callbacks, null);
    }

    @RequiresPermission(allOf={"android.permission.UWB_PRIVILEGED", "android.permission.UWB_RANGING"})
    public CancellationSignal openRangingSession(PersistableBundle parameters, Executor executor, RangingSession.Callback callbacks, @SuppressLint(value={"ListenerLast"}) String chipId) {
        Preconditions.checkNotNull(chipId);
        return this.openRangingSessionInternal(parameters, executor, callbacks, chipId);
    }

    private CancellationSignal openRangingSessionInternal(PersistableBundle parameters, Executor executor, RangingSession.Callback callbacks, String chipId) {
        return this.mRangingManager.openSession(this.mContext.getAttributionSource(), parameters, executor, callbacks, chipId);
    }

    public int getAdapterState() {
        return this.mAdapterStateListener.getAdapterState();
    }

    public boolean isUwbEnabled() {
        int adapterState = this.getAdapterState();
        return adapterState == 2 || adapterState == 1;
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void setUwbEnabled(boolean enabled) {
        this.mAdapterStateListener.setEnabled(enabled);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public List<PersistableBundle> getChipInfos() {
        try {
            return this.mUwbAdapter.getChipInfos();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public String getDefaultChipId() {
        try {
            return this.mUwbAdapter.getDefaultChipId();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle addServiceProfile(PersistableBundle parameters) {
        try {
            return this.mUwbAdapter.addServiceProfile(parameters);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public int removeServiceProfile(PersistableBundle parameters) {
        try {
            return this.mUwbAdapter.removeServiceProfile(parameters);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle getAllServiceProfiles() {
        try {
            return this.mUwbAdapter.getAllServiceProfiles();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle getAdfProvisioningAuthorities(PersistableBundle serviceProfileBundle) {
        try {
            return this.mUwbAdapter.getAdfProvisioningAuthorities(serviceProfileBundle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle getAdfCertificateInfo(PersistableBundle serviceProfileBundle) {
        try {
            return this.mUwbAdapter.getAdfCertificateAndInfo(serviceProfileBundle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void provisionProfileAdfByScript(PersistableBundle serviceProfileBundle, Executor executor, AdfProvisionStateCallback callback2) {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (callback2 == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        AdfProvisionStateCallback.AdfProvisionStateCallbackProxy proxy = callback2.getProxy();
        proxy.initProxy(executor, callback2);
        try {
            this.mUwbAdapter.provisionProfileAdfByScript(serviceProfileBundle, proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public int removeProfileAdf(PersistableBundle serviceProfileBundle) {
        try {
            return this.mUwbAdapter.removeProfileAdf(serviceProfileBundle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public int sendVendorUciMessage(int gid, int oid, byte[] payload) {
        try {
            return this.mUwbAdapter.sendVendorUciMessage(gid, oid, payload);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface SendVendorUciStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface RemoveProfileAdf {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface RemoveServiceProfile {
    }

    public static interface UwbVendorUciCallback {
        public void onVendorUciResponse(int var1, int var2, byte[] var3);

        public void onVendorUciNotification(int var1, int var2, byte[] var3);
    }

    public static abstract class AdfProvisionStateCallback {
        private final AdfProvisionStateCallbackProxy mAdfProvisionStateCallbackProxy = new AdfProvisionStateCallbackProxy();
        public static final int REASON_INVALID_OID = 1;
        public static final int REASON_SE_FAILURE = 2;
        public static final int REASON_UNKNOWN = 3;

        public abstract void onProfileAdfsProvisioned(PersistableBundle var1);

        public abstract void onProfileAdfsProvisionFailed(int var1, PersistableBundle var2);

        AdfProvisionStateCallbackProxy getProxy() {
            return this.mAdfProvisionStateCallbackProxy;
        }

        private static class AdfProvisionStateCallbackProxy
        extends IUwbAdfProvisionStateCallbacks.Stub {
            private final Object mLock = new Object();
            @GuardedBy(value={"mLock"})
            private Executor mExecutor = null;
            @GuardedBy(value={"mLock"})
            private AdfProvisionStateCallback mCallback = null;

            AdfProvisionStateCallbackProxy() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void initProxy(Executor executor, AdfProvisionStateCallback callback2) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = executor;
                    this.mCallback = callback2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void cleanUpProxy() {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = null;
                    this.mCallback = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProfileAdfsProvisioned(PersistableBundle params) {
                AdfProvisionStateCallback callback2;
                Executor executor;
                Log.v(UwbManager.TAG, "AdfProvisionStateCallbackProxy: onProfileAdfsProvisioned : " + params);
                Object object = this.mLock;
                synchronized (object) {
                    executor = this.mExecutor;
                    callback2 = this.mCallback;
                }
                if (callback2 == null || executor == null) {
                    return;
                }
                Binder.clearCallingIdentity();
                executor.execute(() -> callback2.onProfileAdfsProvisioned(params));
                this.cleanUpProxy();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProfileAdfsProvisionFailed(int reason, PersistableBundle params) {
                AdfProvisionStateCallback callback2;
                Executor executor;
                Log.v(UwbManager.TAG, "AdfProvisionStateCallbackProxy: onProfileAdfsProvisionFailed : " + reason + ", " + params);
                Object object = this.mLock;
                synchronized (object) {
                    executor = this.mExecutor;
                    callback2 = this.mCallback;
                }
                if (callback2 == null || executor == null) {
                    return;
                }
                Binder.clearCallingIdentity();
                executor.execute(() -> callback2.onProfileAdfsProvisionFailed(reason, params));
                this.cleanUpProxy();
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface Reason {
        }
    }

    public static interface AdapterStateCallback {
        public static final int STATE_CHANGED_REASON_SESSION_STARTED = 0;
        public static final int STATE_CHANGED_REASON_ALL_SESSIONS_CLOSED = 1;
        public static final int STATE_CHANGED_REASON_SYSTEM_POLICY = 2;
        public static final int STATE_CHANGED_REASON_SYSTEM_BOOT = 3;
        public static final int STATE_CHANGED_REASON_ERROR_UNKNOWN = 4;
        public static final int STATE_DISABLED = 0;
        public static final int STATE_ENABLED_INACTIVE = 1;
        public static final int STATE_ENABLED_ACTIVE = 2;

        public void onStateChanged(int var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface State {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface StateChangedReason {
        }
    }
}

